/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transfer.model.ExecutionError;
import com.amazonaws.services.transfer.model.WorkflowStepType;
import com.amazonaws.services.transfer.model.transform.ExecutionStepResultMarshaller;
import java.io.Serializable;

public class ExecutionStepResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String stepType;
    private String outputs;
    private ExecutionError error;

    public void setStepType(String stepType) {
        this.stepType = stepType;
    }

    public String getStepType() {
        return this.stepType;
    }

    public ExecutionStepResult withStepType(String stepType) {
        this.setStepType(stepType);
        return this;
    }

    public ExecutionStepResult withStepType(WorkflowStepType stepType) {
        this.stepType = stepType.toString();
        return this;
    }

    public void setOutputs(String outputs) {
        this.outputs = outputs;
    }

    public String getOutputs() {
        return this.outputs;
    }

    public ExecutionStepResult withOutputs(String outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public void setError(ExecutionError error) {
        this.error = error;
    }

    public ExecutionError getError() {
        return this.error;
    }

    public ExecutionStepResult withError(ExecutionError error) {
        this.setError(error);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStepType() != null) {
            sb.append("StepType: ").append(this.getStepType()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getError() != null) {
            sb.append("Error: ").append(this.getError());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionStepResult)) {
            return false;
        }
        ExecutionStepResult other = (ExecutionStepResult)obj;
        if (other.getStepType() == null ^ this.getStepType() == null) {
            return false;
        }
        if (other.getStepType() != null && !other.getStepType().equals(this.getStepType())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getError() == null ^ this.getError() == null) {
            return false;
        }
        return other.getError() == null || other.getError().equals(this.getError());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStepType() == null ? 0 : this.getStepType().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getError() == null ? 0 : this.getError().hashCode());
        return hashCode;
    }

    public ExecutionStepResult clone() {
        try {
            return (ExecutionStepResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionStepResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

