/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transfer.model.As2ConnectorConfig;
import com.amazonaws.services.transfer.model.SftpConnectorConfig;
import com.amazonaws.services.transfer.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateConnectorRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String url;
    private As2ConnectorConfig as2Config;
    private String accessRole;
    private String loggingRole;
    private List<Tag> tags;
    private SftpConnectorConfig sftpConfig;

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public CreateConnectorRequest withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public void setAs2Config(As2ConnectorConfig as2Config) {
        this.as2Config = as2Config;
    }

    public As2ConnectorConfig getAs2Config() {
        return this.as2Config;
    }

    public CreateConnectorRequest withAs2Config(As2ConnectorConfig as2Config) {
        this.setAs2Config(as2Config);
        return this;
    }

    public void setAccessRole(String accessRole) {
        this.accessRole = accessRole;
    }

    public String getAccessRole() {
        return this.accessRole;
    }

    public CreateConnectorRequest withAccessRole(String accessRole) {
        this.setAccessRole(accessRole);
        return this;
    }

    public void setLoggingRole(String loggingRole) {
        this.loggingRole = loggingRole;
    }

    public String getLoggingRole() {
        return this.loggingRole;
    }

    public CreateConnectorRequest withLoggingRole(String loggingRole) {
        this.setLoggingRole(loggingRole);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateConnectorRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateConnectorRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setSftpConfig(SftpConnectorConfig sftpConfig) {
        this.sftpConfig = sftpConfig;
    }

    public SftpConnectorConfig getSftpConfig() {
        return this.sftpConfig;
    }

    public CreateConnectorRequest withSftpConfig(SftpConnectorConfig sftpConfig) {
        this.setSftpConfig(sftpConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUrl() != null) {
            sb.append("Url: ").append(this.getUrl()).append(",");
        }
        if (this.getAs2Config() != null) {
            sb.append("As2Config: ").append(this.getAs2Config()).append(",");
        }
        if (this.getAccessRole() != null) {
            sb.append("AccessRole: ").append(this.getAccessRole()).append(",");
        }
        if (this.getLoggingRole() != null) {
            sb.append("LoggingRole: ").append(this.getLoggingRole()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getSftpConfig() != null) {
            sb.append("SftpConfig: ").append(this.getSftpConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorRequest)) {
            return false;
        }
        CreateConnectorRequest other = (CreateConnectorRequest)obj;
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        if (other.getUrl() != null && !other.getUrl().equals(this.getUrl())) {
            return false;
        }
        if (other.getAs2Config() == null ^ this.getAs2Config() == null) {
            return false;
        }
        if (other.getAs2Config() != null && !other.getAs2Config().equals(this.getAs2Config())) {
            return false;
        }
        if (other.getAccessRole() == null ^ this.getAccessRole() == null) {
            return false;
        }
        if (other.getAccessRole() != null && !other.getAccessRole().equals(this.getAccessRole())) {
            return false;
        }
        if (other.getLoggingRole() == null ^ this.getLoggingRole() == null) {
            return false;
        }
        if (other.getLoggingRole() != null && !other.getLoggingRole().equals(this.getLoggingRole())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getSftpConfig() == null ^ this.getSftpConfig() == null) {
            return false;
        }
        return other.getSftpConfig() == null || other.getSftpConfig().equals(this.getSftpConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        hashCode = 31 * hashCode + (this.getAs2Config() == null ? 0 : this.getAs2Config().hashCode());
        hashCode = 31 * hashCode + (this.getAccessRole() == null ? 0 : this.getAccessRole().hashCode());
        hashCode = 31 * hashCode + (this.getLoggingRole() == null ? 0 : this.getLoggingRole().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getSftpConfig() == null ? 0 : this.getSftpConfig().hashCode());
        return hashCode;
    }

    public CreateConnectorRequest clone() {
        return (CreateConnectorRequest)super.clone();
    }
}

