/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transfer.model.CertificateUsageType;
import com.amazonaws.services.transfer.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ImportCertificateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String usage;
    private String certificate;
    private String certificateChain;
    private String privateKey;
    private Date activeDate;
    private Date inactiveDate;
    private String description;
    private List<Tag> tags;

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getUsage() {
        return this.usage;
    }

    public ImportCertificateRequest withUsage(String usage) {
        this.setUsage(usage);
        return this;
    }

    public ImportCertificateRequest withUsage(CertificateUsageType usage) {
        this.usage = usage.toString();
        return this;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public ImportCertificateRequest withCertificate(String certificate) {
        this.setCertificate(certificate);
        return this;
    }

    public void setCertificateChain(String certificateChain) {
        this.certificateChain = certificateChain;
    }

    public String getCertificateChain() {
        return this.certificateChain;
    }

    public ImportCertificateRequest withCertificateChain(String certificateChain) {
        this.setCertificateChain(certificateChain);
        return this;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public ImportCertificateRequest withPrivateKey(String privateKey) {
        this.setPrivateKey(privateKey);
        return this;
    }

    public void setActiveDate(Date activeDate) {
        this.activeDate = activeDate;
    }

    public Date getActiveDate() {
        return this.activeDate;
    }

    public ImportCertificateRequest withActiveDate(Date activeDate) {
        this.setActiveDate(activeDate);
        return this;
    }

    public void setInactiveDate(Date inactiveDate) {
        this.inactiveDate = inactiveDate;
    }

    public Date getInactiveDate() {
        return this.inactiveDate;
    }

    public ImportCertificateRequest withInactiveDate(Date inactiveDate) {
        this.setInactiveDate(inactiveDate);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ImportCertificateRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ImportCertificateRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ImportCertificateRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsage() != null) {
            sb.append("Usage: ").append(this.getUsage()).append(",");
        }
        if (this.getCertificate() != null) {
            sb.append("Certificate: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCertificateChain() != null) {
            sb.append("CertificateChain: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPrivateKey() != null) {
            sb.append("PrivateKey: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getActiveDate() != null) {
            sb.append("ActiveDate: ").append(this.getActiveDate()).append(",");
        }
        if (this.getInactiveDate() != null) {
            sb.append("InactiveDate: ").append(this.getInactiveDate()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCertificateRequest)) {
            return false;
        }
        ImportCertificateRequest other = (ImportCertificateRequest)obj;
        if (other.getUsage() == null ^ this.getUsage() == null) {
            return false;
        }
        if (other.getUsage() != null && !other.getUsage().equals(this.getUsage())) {
            return false;
        }
        if (other.getCertificate() == null ^ this.getCertificate() == null) {
            return false;
        }
        if (other.getCertificate() != null && !other.getCertificate().equals(this.getCertificate())) {
            return false;
        }
        if (other.getCertificateChain() == null ^ this.getCertificateChain() == null) {
            return false;
        }
        if (other.getCertificateChain() != null && !other.getCertificateChain().equals(this.getCertificateChain())) {
            return false;
        }
        if (other.getPrivateKey() == null ^ this.getPrivateKey() == null) {
            return false;
        }
        if (other.getPrivateKey() != null && !other.getPrivateKey().equals(this.getPrivateKey())) {
            return false;
        }
        if (other.getActiveDate() == null ^ this.getActiveDate() == null) {
            return false;
        }
        if (other.getActiveDate() != null && !other.getActiveDate().equals(this.getActiveDate())) {
            return false;
        }
        if (other.getInactiveDate() == null ^ this.getInactiveDate() == null) {
            return false;
        }
        if (other.getInactiveDate() != null && !other.getInactiveDate().equals(this.getInactiveDate())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsage() == null ? 0 : this.getUsage().hashCode());
        hashCode = 31 * hashCode + (this.getCertificate() == null ? 0 : this.getCertificate().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateChain() == null ? 0 : this.getCertificateChain().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateKey() == null ? 0 : this.getPrivateKey().hashCode());
        hashCode = 31 * hashCode + (this.getActiveDate() == null ? 0 : this.getActiveDate().hashCode());
        hashCode = 31 * hashCode + (this.getInactiveDate() == null ? 0 : this.getInactiveDate().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ImportCertificateRequest clone() {
        return (ImportCertificateRequest)super.clone();
    }
}

