/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.transfer.AWSTransfer;
import com.amazonaws.services.transfer.model.DescribeServerRequest;
import com.amazonaws.services.transfer.waiters.DescribeServerFunction;
import com.amazonaws.services.transfer.waiters.ServerOffline;
import com.amazonaws.services.transfer.waiters.ServerOnline;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AWSTransferWaiters {
    private final AWSTransfer client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSTransferWaiters");

    @SdkInternalApi
    public AWSTransferWaiters(AWSTransfer client) {
        this.client = client;
    }

    public Waiter<DescribeServerRequest> serverOnline() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeServerFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ServerOnline.IsONLINEMatcher(), new ServerOnline.IsSTART_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeServerRequest> serverOffline() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeServerFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ServerOffline.IsOFFLINEMatcher(), new ServerOffline.IsSTOP_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

