/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transfer.model.EndpointDetails;
import com.amazonaws.services.transfer.model.EndpointType;
import com.amazonaws.services.transfer.model.IdentityProviderDetails;
import com.amazonaws.services.transfer.model.Protocol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateServerRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String certificate;
    private EndpointDetails endpointDetails;
    private String endpointType;
    private String hostKey;
    private IdentityProviderDetails identityProviderDetails;
    private String loggingRole;
    private List<String> protocols;
    private String serverId;

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public UpdateServerRequest withCertificate(String certificate) {
        this.setCertificate(certificate);
        return this;
    }

    public void setEndpointDetails(EndpointDetails endpointDetails) {
        this.endpointDetails = endpointDetails;
    }

    public EndpointDetails getEndpointDetails() {
        return this.endpointDetails;
    }

    public UpdateServerRequest withEndpointDetails(EndpointDetails endpointDetails) {
        this.setEndpointDetails(endpointDetails);
        return this;
    }

    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    public String getEndpointType() {
        return this.endpointType;
    }

    public UpdateServerRequest withEndpointType(String endpointType) {
        this.setEndpointType(endpointType);
        return this;
    }

    public UpdateServerRequest withEndpointType(EndpointType endpointType) {
        this.endpointType = endpointType.toString();
        return this;
    }

    public void setHostKey(String hostKey) {
        this.hostKey = hostKey;
    }

    public String getHostKey() {
        return this.hostKey;
    }

    public UpdateServerRequest withHostKey(String hostKey) {
        this.setHostKey(hostKey);
        return this;
    }

    public void setIdentityProviderDetails(IdentityProviderDetails identityProviderDetails) {
        this.identityProviderDetails = identityProviderDetails;
    }

    public IdentityProviderDetails getIdentityProviderDetails() {
        return this.identityProviderDetails;
    }

    public UpdateServerRequest withIdentityProviderDetails(IdentityProviderDetails identityProviderDetails) {
        this.setIdentityProviderDetails(identityProviderDetails);
        return this;
    }

    public void setLoggingRole(String loggingRole) {
        this.loggingRole = loggingRole;
    }

    public String getLoggingRole() {
        return this.loggingRole;
    }

    public UpdateServerRequest withLoggingRole(String loggingRole) {
        this.setLoggingRole(loggingRole);
        return this;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(Collection<String> protocols) {
        if (protocols == null) {
            this.protocols = null;
            return;
        }
        this.protocols = new ArrayList<String>(protocols);
    }

    public UpdateServerRequest withProtocols(String ... protocols) {
        if (this.protocols == null) {
            this.setProtocols(new ArrayList<String>(protocols.length));
        }
        for (String ele : protocols) {
            this.protocols.add(ele);
        }
        return this;
    }

    public UpdateServerRequest withProtocols(Collection<String> protocols) {
        this.setProtocols(protocols);
        return this;
    }

    public UpdateServerRequest withProtocols(Protocol ... protocols) {
        ArrayList<String> protocolsCopy = new ArrayList<String>(protocols.length);
        for (Protocol value : protocols) {
            protocolsCopy.add(value.toString());
        }
        if (this.getProtocols() == null) {
            this.setProtocols(protocolsCopy);
        } else {
            this.getProtocols().addAll(protocolsCopy);
        }
        return this;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public UpdateServerRequest withServerId(String serverId) {
        this.setServerId(serverId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificate() != null) {
            sb.append("Certificate: ").append(this.getCertificate()).append(",");
        }
        if (this.getEndpointDetails() != null) {
            sb.append("EndpointDetails: ").append(this.getEndpointDetails()).append(",");
        }
        if (this.getEndpointType() != null) {
            sb.append("EndpointType: ").append(this.getEndpointType()).append(",");
        }
        if (this.getHostKey() != null) {
            sb.append("HostKey: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getIdentityProviderDetails() != null) {
            sb.append("IdentityProviderDetails: ").append(this.getIdentityProviderDetails()).append(",");
        }
        if (this.getLoggingRole() != null) {
            sb.append("LoggingRole: ").append(this.getLoggingRole()).append(",");
        }
        if (this.getProtocols() != null) {
            sb.append("Protocols: ").append(this.getProtocols()).append(",");
        }
        if (this.getServerId() != null) {
            sb.append("ServerId: ").append(this.getServerId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServerRequest)) {
            return false;
        }
        UpdateServerRequest other = (UpdateServerRequest)obj;
        if (other.getCertificate() == null ^ this.getCertificate() == null) {
            return false;
        }
        if (other.getCertificate() != null && !other.getCertificate().equals(this.getCertificate())) {
            return false;
        }
        if (other.getEndpointDetails() == null ^ this.getEndpointDetails() == null) {
            return false;
        }
        if (other.getEndpointDetails() != null && !other.getEndpointDetails().equals(this.getEndpointDetails())) {
            return false;
        }
        if (other.getEndpointType() == null ^ this.getEndpointType() == null) {
            return false;
        }
        if (other.getEndpointType() != null && !other.getEndpointType().equals(this.getEndpointType())) {
            return false;
        }
        if (other.getHostKey() == null ^ this.getHostKey() == null) {
            return false;
        }
        if (other.getHostKey() != null && !other.getHostKey().equals(this.getHostKey())) {
            return false;
        }
        if (other.getIdentityProviderDetails() == null ^ this.getIdentityProviderDetails() == null) {
            return false;
        }
        if (other.getIdentityProviderDetails() != null && !other.getIdentityProviderDetails().equals(this.getIdentityProviderDetails())) {
            return false;
        }
        if (other.getLoggingRole() == null ^ this.getLoggingRole() == null) {
            return false;
        }
        if (other.getLoggingRole() != null && !other.getLoggingRole().equals(this.getLoggingRole())) {
            return false;
        }
        if (other.getProtocols() == null ^ this.getProtocols() == null) {
            return false;
        }
        if (other.getProtocols() != null && !other.getProtocols().equals(this.getProtocols())) {
            return false;
        }
        if (other.getServerId() == null ^ this.getServerId() == null) {
            return false;
        }
        return other.getServerId() == null || other.getServerId().equals(this.getServerId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificate() == null ? 0 : this.getCertificate().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointDetails() == null ? 0 : this.getEndpointDetails().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointType() == null ? 0 : this.getEndpointType().hashCode());
        hashCode = 31 * hashCode + (this.getHostKey() == null ? 0 : this.getHostKey().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityProviderDetails() == null ? 0 : this.getIdentityProviderDetails().hashCode());
        hashCode = 31 * hashCode + (this.getLoggingRole() == null ? 0 : this.getLoggingRole().hashCode());
        hashCode = 31 * hashCode + (this.getProtocols() == null ? 0 : this.getProtocols().hashCode());
        hashCode = 31 * hashCode + (this.getServerId() == null ? 0 : this.getServerId().hashCode());
        return hashCode;
    }

    public UpdateServerRequest clone() {
        return (UpdateServerRequest)super.clone();
    }
}

