/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.transfer.AWSTransferAsync;
import com.amazonaws.services.transfer.AWSTransferAsyncClientBuilder;
import com.amazonaws.services.transfer.AWSTransferClient;
import com.amazonaws.services.transfer.model.CreateServerRequest;
import com.amazonaws.services.transfer.model.CreateServerResult;
import com.amazonaws.services.transfer.model.CreateUserRequest;
import com.amazonaws.services.transfer.model.CreateUserResult;
import com.amazonaws.services.transfer.model.DeleteServerRequest;
import com.amazonaws.services.transfer.model.DeleteServerResult;
import com.amazonaws.services.transfer.model.DeleteSshPublicKeyRequest;
import com.amazonaws.services.transfer.model.DeleteSshPublicKeyResult;
import com.amazonaws.services.transfer.model.DeleteUserRequest;
import com.amazonaws.services.transfer.model.DeleteUserResult;
import com.amazonaws.services.transfer.model.DescribeServerRequest;
import com.amazonaws.services.transfer.model.DescribeServerResult;
import com.amazonaws.services.transfer.model.DescribeUserRequest;
import com.amazonaws.services.transfer.model.DescribeUserResult;
import com.amazonaws.services.transfer.model.ImportSshPublicKeyRequest;
import com.amazonaws.services.transfer.model.ImportSshPublicKeyResult;
import com.amazonaws.services.transfer.model.ListServersRequest;
import com.amazonaws.services.transfer.model.ListServersResult;
import com.amazonaws.services.transfer.model.ListTagsForResourceRequest;
import com.amazonaws.services.transfer.model.ListTagsForResourceResult;
import com.amazonaws.services.transfer.model.ListUsersRequest;
import com.amazonaws.services.transfer.model.ListUsersResult;
import com.amazonaws.services.transfer.model.StartServerRequest;
import com.amazonaws.services.transfer.model.StartServerResult;
import com.amazonaws.services.transfer.model.StopServerRequest;
import com.amazonaws.services.transfer.model.StopServerResult;
import com.amazonaws.services.transfer.model.TagResourceRequest;
import com.amazonaws.services.transfer.model.TagResourceResult;
import com.amazonaws.services.transfer.model.TestIdentityProviderRequest;
import com.amazonaws.services.transfer.model.TestIdentityProviderResult;
import com.amazonaws.services.transfer.model.UntagResourceRequest;
import com.amazonaws.services.transfer.model.UntagResourceResult;
import com.amazonaws.services.transfer.model.UpdateServerRequest;
import com.amazonaws.services.transfer.model.UpdateServerResult;
import com.amazonaws.services.transfer.model.UpdateUserRequest;
import com.amazonaws.services.transfer.model.UpdateUserResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSTransferAsyncClient
extends AWSTransferClient
implements AWSTransferAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSTransferAsyncClientBuilder asyncBuilder() {
        return AWSTransferAsyncClientBuilder.standard();
    }

    AWSTransferAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateServerResult> createServerAsync(CreateServerRequest request) {
        return this.createServerAsync(request, null);
    }

    @Override
    public Future<CreateServerResult> createServerAsync(CreateServerRequest request, final AsyncHandler<CreateServerRequest, CreateServerResult> asyncHandler) {
        final CreateServerRequest finalRequest = (CreateServerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateServerResult>(){

            @Override
            public CreateServerResult call() throws Exception {
                CreateServerResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeCreateServer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request) {
        return this.createUserAsync(request, null);
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request, final AsyncHandler<CreateUserRequest, CreateUserResult> asyncHandler) {
        final CreateUserRequest finalRequest = (CreateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateUserResult>(){

            @Override
            public CreateUserResult call() throws Exception {
                CreateUserResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeCreateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteServerResult> deleteServerAsync(DeleteServerRequest request) {
        return this.deleteServerAsync(request, null);
    }

    @Override
    public Future<DeleteServerResult> deleteServerAsync(DeleteServerRequest request, final AsyncHandler<DeleteServerRequest, DeleteServerResult> asyncHandler) {
        final DeleteServerRequest finalRequest = (DeleteServerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteServerResult>(){

            @Override
            public DeleteServerResult call() throws Exception {
                DeleteServerResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeDeleteServer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSshPublicKeyResult> deleteSshPublicKeyAsync(DeleteSshPublicKeyRequest request) {
        return this.deleteSshPublicKeyAsync(request, null);
    }

    @Override
    public Future<DeleteSshPublicKeyResult> deleteSshPublicKeyAsync(DeleteSshPublicKeyRequest request, final AsyncHandler<DeleteSshPublicKeyRequest, DeleteSshPublicKeyResult> asyncHandler) {
        final DeleteSshPublicKeyRequest finalRequest = (DeleteSshPublicKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSshPublicKeyResult>(){

            @Override
            public DeleteSshPublicKeyResult call() throws Exception {
                DeleteSshPublicKeyResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeDeleteSshPublicKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request) {
        return this.deleteUserAsync(request, null);
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request, final AsyncHandler<DeleteUserRequest, DeleteUserResult> asyncHandler) {
        final DeleteUserRequest finalRequest = (DeleteUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteUserResult>(){

            @Override
            public DeleteUserResult call() throws Exception {
                DeleteUserResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeDeleteUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeServerResult> describeServerAsync(DescribeServerRequest request) {
        return this.describeServerAsync(request, null);
    }

    @Override
    public Future<DescribeServerResult> describeServerAsync(DescribeServerRequest request, final AsyncHandler<DescribeServerRequest, DescribeServerResult> asyncHandler) {
        final DescribeServerRequest finalRequest = (DescribeServerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeServerResult>(){

            @Override
            public DescribeServerResult call() throws Exception {
                DescribeServerResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeDescribeServer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request) {
        return this.describeUserAsync(request, null);
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request, final AsyncHandler<DescribeUserRequest, DescribeUserResult> asyncHandler) {
        final DescribeUserRequest finalRequest = (DescribeUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUserResult>(){

            @Override
            public DescribeUserResult call() throws Exception {
                DescribeUserResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeDescribeUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportSshPublicKeyResult> importSshPublicKeyAsync(ImportSshPublicKeyRequest request) {
        return this.importSshPublicKeyAsync(request, null);
    }

    @Override
    public Future<ImportSshPublicKeyResult> importSshPublicKeyAsync(ImportSshPublicKeyRequest request, final AsyncHandler<ImportSshPublicKeyRequest, ImportSshPublicKeyResult> asyncHandler) {
        final ImportSshPublicKeyRequest finalRequest = (ImportSshPublicKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportSshPublicKeyResult>(){

            @Override
            public ImportSshPublicKeyResult call() throws Exception {
                ImportSshPublicKeyResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeImportSshPublicKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListServersResult> listServersAsync(ListServersRequest request) {
        return this.listServersAsync(request, null);
    }

    @Override
    public Future<ListServersResult> listServersAsync(ListServersRequest request, final AsyncHandler<ListServersRequest, ListServersResult> asyncHandler) {
        final ListServersRequest finalRequest = (ListServersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListServersResult>(){

            @Override
            public ListServersResult call() throws Exception {
                ListServersResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeListServers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request) {
        return this.listUsersAsync(request, null);
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request, final AsyncHandler<ListUsersRequest, ListUsersResult> asyncHandler) {
        final ListUsersRequest finalRequest = (ListUsersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsersResult>(){

            @Override
            public ListUsersResult call() throws Exception {
                ListUsersResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeListUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartServerResult> startServerAsync(StartServerRequest request) {
        return this.startServerAsync(request, null);
    }

    @Override
    public Future<StartServerResult> startServerAsync(StartServerRequest request, final AsyncHandler<StartServerRequest, StartServerResult> asyncHandler) {
        final StartServerRequest finalRequest = (StartServerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartServerResult>(){

            @Override
            public StartServerResult call() throws Exception {
                StartServerResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeStartServer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopServerResult> stopServerAsync(StopServerRequest request) {
        return this.stopServerAsync(request, null);
    }

    @Override
    public Future<StopServerResult> stopServerAsync(StopServerRequest request, final AsyncHandler<StopServerRequest, StopServerResult> asyncHandler) {
        final StopServerRequest finalRequest = (StopServerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopServerResult>(){

            @Override
            public StopServerResult call() throws Exception {
                StopServerResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeStopServer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestIdentityProviderResult> testIdentityProviderAsync(TestIdentityProviderRequest request) {
        return this.testIdentityProviderAsync(request, null);
    }

    @Override
    public Future<TestIdentityProviderResult> testIdentityProviderAsync(TestIdentityProviderRequest request, final AsyncHandler<TestIdentityProviderRequest, TestIdentityProviderResult> asyncHandler) {
        final TestIdentityProviderRequest finalRequest = (TestIdentityProviderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TestIdentityProviderResult>(){

            @Override
            public TestIdentityProviderResult call() throws Exception {
                TestIdentityProviderResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeTestIdentityProvider(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateServerResult> updateServerAsync(UpdateServerRequest request) {
        return this.updateServerAsync(request, null);
    }

    @Override
    public Future<UpdateServerResult> updateServerAsync(UpdateServerRequest request, final AsyncHandler<UpdateServerRequest, UpdateServerResult> asyncHandler) {
        final UpdateServerRequest finalRequest = (UpdateServerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateServerResult>(){

            @Override
            public UpdateServerResult call() throws Exception {
                UpdateServerResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeUpdateServer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request) {
        return this.updateUserAsync(request, null);
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request, final AsyncHandler<UpdateUserRequest, UpdateUserResult> asyncHandler) {
        final UpdateUserRequest finalRequest = (UpdateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserResult>(){

            @Override
            public UpdateUserResult call() throws Exception {
                UpdateUserResult result = null;
                try {
                    result = AWSTransferAsyncClient.this.executeUpdateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

