/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transcribe.model.ContentRedaction;
import com.amazonaws.services.transcribe.model.LanguageCode;
import com.amazonaws.services.transcribe.model.VocabularyFilterMethod;
import com.amazonaws.services.transcribe.model.transform.CallAnalyticsJobSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CallAnalyticsJobSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String vocabularyName;
    private String vocabularyFilterName;
    private String vocabularyFilterMethod;
    private String languageModelName;
    private ContentRedaction contentRedaction;
    private List<String> languageOptions;

    public void setVocabularyName(String vocabularyName) {
        this.vocabularyName = vocabularyName;
    }

    public String getVocabularyName() {
        return this.vocabularyName;
    }

    public CallAnalyticsJobSettings withVocabularyName(String vocabularyName) {
        this.setVocabularyName(vocabularyName);
        return this;
    }

    public void setVocabularyFilterName(String vocabularyFilterName) {
        this.vocabularyFilterName = vocabularyFilterName;
    }

    public String getVocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public CallAnalyticsJobSettings withVocabularyFilterName(String vocabularyFilterName) {
        this.setVocabularyFilterName(vocabularyFilterName);
        return this;
    }

    public void setVocabularyFilterMethod(String vocabularyFilterMethod) {
        this.vocabularyFilterMethod = vocabularyFilterMethod;
    }

    public String getVocabularyFilterMethod() {
        return this.vocabularyFilterMethod;
    }

    public CallAnalyticsJobSettings withVocabularyFilterMethod(String vocabularyFilterMethod) {
        this.setVocabularyFilterMethod(vocabularyFilterMethod);
        return this;
    }

    public CallAnalyticsJobSettings withVocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
        this.vocabularyFilterMethod = vocabularyFilterMethod.toString();
        return this;
    }

    public void setLanguageModelName(String languageModelName) {
        this.languageModelName = languageModelName;
    }

    public String getLanguageModelName() {
        return this.languageModelName;
    }

    public CallAnalyticsJobSettings withLanguageModelName(String languageModelName) {
        this.setLanguageModelName(languageModelName);
        return this;
    }

    public void setContentRedaction(ContentRedaction contentRedaction) {
        this.contentRedaction = contentRedaction;
    }

    public ContentRedaction getContentRedaction() {
        return this.contentRedaction;
    }

    public CallAnalyticsJobSettings withContentRedaction(ContentRedaction contentRedaction) {
        this.setContentRedaction(contentRedaction);
        return this;
    }

    public List<String> getLanguageOptions() {
        return this.languageOptions;
    }

    public void setLanguageOptions(Collection<String> languageOptions) {
        if (languageOptions == null) {
            this.languageOptions = null;
            return;
        }
        this.languageOptions = new ArrayList<String>(languageOptions);
    }

    public CallAnalyticsJobSettings withLanguageOptions(String ... languageOptions) {
        if (this.languageOptions == null) {
            this.setLanguageOptions(new ArrayList<String>(languageOptions.length));
        }
        for (String ele : languageOptions) {
            this.languageOptions.add(ele);
        }
        return this;
    }

    public CallAnalyticsJobSettings withLanguageOptions(Collection<String> languageOptions) {
        this.setLanguageOptions(languageOptions);
        return this;
    }

    public CallAnalyticsJobSettings withLanguageOptions(LanguageCode ... languageOptions) {
        ArrayList<String> languageOptionsCopy = new ArrayList<String>(languageOptions.length);
        for (LanguageCode value : languageOptions) {
            languageOptionsCopy.add(value.toString());
        }
        if (this.getLanguageOptions() == null) {
            this.setLanguageOptions(languageOptionsCopy);
        } else {
            this.getLanguageOptions().addAll(languageOptionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVocabularyName() != null) {
            sb.append("VocabularyName: ").append(this.getVocabularyName()).append(",");
        }
        if (this.getVocabularyFilterName() != null) {
            sb.append("VocabularyFilterName: ").append(this.getVocabularyFilterName()).append(",");
        }
        if (this.getVocabularyFilterMethod() != null) {
            sb.append("VocabularyFilterMethod: ").append(this.getVocabularyFilterMethod()).append(",");
        }
        if (this.getLanguageModelName() != null) {
            sb.append("LanguageModelName: ").append(this.getLanguageModelName()).append(",");
        }
        if (this.getContentRedaction() != null) {
            sb.append("ContentRedaction: ").append(this.getContentRedaction()).append(",");
        }
        if (this.getLanguageOptions() != null) {
            sb.append("LanguageOptions: ").append(this.getLanguageOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsJobSettings)) {
            return false;
        }
        CallAnalyticsJobSettings other = (CallAnalyticsJobSettings)obj;
        if (other.getVocabularyName() == null ^ this.getVocabularyName() == null) {
            return false;
        }
        if (other.getVocabularyName() != null && !other.getVocabularyName().equals(this.getVocabularyName())) {
            return false;
        }
        if (other.getVocabularyFilterName() == null ^ this.getVocabularyFilterName() == null) {
            return false;
        }
        if (other.getVocabularyFilterName() != null && !other.getVocabularyFilterName().equals(this.getVocabularyFilterName())) {
            return false;
        }
        if (other.getVocabularyFilterMethod() == null ^ this.getVocabularyFilterMethod() == null) {
            return false;
        }
        if (other.getVocabularyFilterMethod() != null && !other.getVocabularyFilterMethod().equals(this.getVocabularyFilterMethod())) {
            return false;
        }
        if (other.getLanguageModelName() == null ^ this.getLanguageModelName() == null) {
            return false;
        }
        if (other.getLanguageModelName() != null && !other.getLanguageModelName().equals(this.getLanguageModelName())) {
            return false;
        }
        if (other.getContentRedaction() == null ^ this.getContentRedaction() == null) {
            return false;
        }
        if (other.getContentRedaction() != null && !other.getContentRedaction().equals(this.getContentRedaction())) {
            return false;
        }
        if (other.getLanguageOptions() == null ^ this.getLanguageOptions() == null) {
            return false;
        }
        return other.getLanguageOptions() == null || other.getLanguageOptions().equals(this.getLanguageOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVocabularyName() == null ? 0 : this.getVocabularyName().hashCode());
        hashCode = 31 * hashCode + (this.getVocabularyFilterName() == null ? 0 : this.getVocabularyFilterName().hashCode());
        hashCode = 31 * hashCode + (this.getVocabularyFilterMethod() == null ? 0 : this.getVocabularyFilterMethod().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageModelName() == null ? 0 : this.getLanguageModelName().hashCode());
        hashCode = 31 * hashCode + (this.getContentRedaction() == null ? 0 : this.getContentRedaction().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageOptions() == null ? 0 : this.getLanguageOptions().hashCode());
        return hashCode;
    }

    public CallAnalyticsJobSettings clone() {
        try {
            return (CallAnalyticsJobSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CallAnalyticsJobSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

