/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transcribe.model.ContentRedaction;
import com.amazonaws.services.transcribe.model.JobExecutionSettings;
import com.amazonaws.services.transcribe.model.LanguageCode;
import com.amazonaws.services.transcribe.model.LanguageIdSettings;
import com.amazonaws.services.transcribe.model.Media;
import com.amazonaws.services.transcribe.model.MediaFormat;
import com.amazonaws.services.transcribe.model.ModelSettings;
import com.amazonaws.services.transcribe.model.Settings;
import com.amazonaws.services.transcribe.model.Subtitles;
import com.amazonaws.services.transcribe.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartTranscriptionJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String transcriptionJobName;
    private String languageCode;
    private Integer mediaSampleRateHertz;
    private String mediaFormat;
    private Media media;
    private String outputBucketName;
    private String outputKey;
    private String outputEncryptionKMSKeyId;
    private Map<String, String> kMSEncryptionContext;
    private Settings settings;
    private ModelSettings modelSettings;
    private JobExecutionSettings jobExecutionSettings;
    private ContentRedaction contentRedaction;
    private Boolean identifyLanguage;
    private Boolean identifyMultipleLanguages;
    private List<String> languageOptions;
    private Subtitles subtitles;
    private List<Tag> tags;
    private Map<String, LanguageIdSettings> languageIdSettings;

    public void setTranscriptionJobName(String transcriptionJobName) {
        this.transcriptionJobName = transcriptionJobName;
    }

    public String getTranscriptionJobName() {
        return this.transcriptionJobName;
    }

    public StartTranscriptionJobRequest withTranscriptionJobName(String transcriptionJobName) {
        this.setTranscriptionJobName(transcriptionJobName);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public StartTranscriptionJobRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public StartTranscriptionJobRequest withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
        this.mediaSampleRateHertz = mediaSampleRateHertz;
    }

    public Integer getMediaSampleRateHertz() {
        return this.mediaSampleRateHertz;
    }

    public StartTranscriptionJobRequest withMediaSampleRateHertz(Integer mediaSampleRateHertz) {
        this.setMediaSampleRateHertz(mediaSampleRateHertz);
        return this;
    }

    public void setMediaFormat(String mediaFormat) {
        this.mediaFormat = mediaFormat;
    }

    public String getMediaFormat() {
        return this.mediaFormat;
    }

    public StartTranscriptionJobRequest withMediaFormat(String mediaFormat) {
        this.setMediaFormat(mediaFormat);
        return this;
    }

    public StartTranscriptionJobRequest withMediaFormat(MediaFormat mediaFormat) {
        this.mediaFormat = mediaFormat.toString();
        return this;
    }

    public void setMedia(Media media) {
        this.media = media;
    }

    public Media getMedia() {
        return this.media;
    }

    public StartTranscriptionJobRequest withMedia(Media media) {
        this.setMedia(media);
        return this;
    }

    public void setOutputBucketName(String outputBucketName) {
        this.outputBucketName = outputBucketName;
    }

    public String getOutputBucketName() {
        return this.outputBucketName;
    }

    public StartTranscriptionJobRequest withOutputBucketName(String outputBucketName) {
        this.setOutputBucketName(outputBucketName);
        return this;
    }

    public void setOutputKey(String outputKey) {
        this.outputKey = outputKey;
    }

    public String getOutputKey() {
        return this.outputKey;
    }

    public StartTranscriptionJobRequest withOutputKey(String outputKey) {
        this.setOutputKey(outputKey);
        return this;
    }

    public void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
        this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
    }

    public String getOutputEncryptionKMSKeyId() {
        return this.outputEncryptionKMSKeyId;
    }

    public StartTranscriptionJobRequest withOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
        this.setOutputEncryptionKMSKeyId(outputEncryptionKMSKeyId);
        return this;
    }

    public Map<String, String> getKMSEncryptionContext() {
        return this.kMSEncryptionContext;
    }

    public void setKMSEncryptionContext(Map<String, String> kMSEncryptionContext) {
        this.kMSEncryptionContext = kMSEncryptionContext;
    }

    public StartTranscriptionJobRequest withKMSEncryptionContext(Map<String, String> kMSEncryptionContext) {
        this.setKMSEncryptionContext(kMSEncryptionContext);
        return this;
    }

    public StartTranscriptionJobRequest addKMSEncryptionContextEntry(String key, String value) {
        if (null == this.kMSEncryptionContext) {
            this.kMSEncryptionContext = new HashMap<String, String>();
        }
        if (this.kMSEncryptionContext.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.kMSEncryptionContext.put(key, value);
        return this;
    }

    public StartTranscriptionJobRequest clearKMSEncryptionContextEntries() {
        this.kMSEncryptionContext = null;
        return this;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public StartTranscriptionJobRequest withSettings(Settings settings) {
        this.setSettings(settings);
        return this;
    }

    public void setModelSettings(ModelSettings modelSettings) {
        this.modelSettings = modelSettings;
    }

    public ModelSettings getModelSettings() {
        return this.modelSettings;
    }

    public StartTranscriptionJobRequest withModelSettings(ModelSettings modelSettings) {
        this.setModelSettings(modelSettings);
        return this;
    }

    public void setJobExecutionSettings(JobExecutionSettings jobExecutionSettings) {
        this.jobExecutionSettings = jobExecutionSettings;
    }

    public JobExecutionSettings getJobExecutionSettings() {
        return this.jobExecutionSettings;
    }

    public StartTranscriptionJobRequest withJobExecutionSettings(JobExecutionSettings jobExecutionSettings) {
        this.setJobExecutionSettings(jobExecutionSettings);
        return this;
    }

    public void setContentRedaction(ContentRedaction contentRedaction) {
        this.contentRedaction = contentRedaction;
    }

    public ContentRedaction getContentRedaction() {
        return this.contentRedaction;
    }

    public StartTranscriptionJobRequest withContentRedaction(ContentRedaction contentRedaction) {
        this.setContentRedaction(contentRedaction);
        return this;
    }

    public void setIdentifyLanguage(Boolean identifyLanguage) {
        this.identifyLanguage = identifyLanguage;
    }

    public Boolean getIdentifyLanguage() {
        return this.identifyLanguage;
    }

    public StartTranscriptionJobRequest withIdentifyLanguage(Boolean identifyLanguage) {
        this.setIdentifyLanguage(identifyLanguage);
        return this;
    }

    public Boolean isIdentifyLanguage() {
        return this.identifyLanguage;
    }

    public void setIdentifyMultipleLanguages(Boolean identifyMultipleLanguages) {
        this.identifyMultipleLanguages = identifyMultipleLanguages;
    }

    public Boolean getIdentifyMultipleLanguages() {
        return this.identifyMultipleLanguages;
    }

    public StartTranscriptionJobRequest withIdentifyMultipleLanguages(Boolean identifyMultipleLanguages) {
        this.setIdentifyMultipleLanguages(identifyMultipleLanguages);
        return this;
    }

    public Boolean isIdentifyMultipleLanguages() {
        return this.identifyMultipleLanguages;
    }

    public List<String> getLanguageOptions() {
        return this.languageOptions;
    }

    public void setLanguageOptions(Collection<String> languageOptions) {
        if (languageOptions == null) {
            this.languageOptions = null;
            return;
        }
        this.languageOptions = new ArrayList<String>(languageOptions);
    }

    public StartTranscriptionJobRequest withLanguageOptions(String ... languageOptions) {
        if (this.languageOptions == null) {
            this.setLanguageOptions(new ArrayList<String>(languageOptions.length));
        }
        for (String ele : languageOptions) {
            this.languageOptions.add(ele);
        }
        return this;
    }

    public StartTranscriptionJobRequest withLanguageOptions(Collection<String> languageOptions) {
        this.setLanguageOptions(languageOptions);
        return this;
    }

    public StartTranscriptionJobRequest withLanguageOptions(LanguageCode ... languageOptions) {
        ArrayList<String> languageOptionsCopy = new ArrayList<String>(languageOptions.length);
        for (LanguageCode value : languageOptions) {
            languageOptionsCopy.add(value.toString());
        }
        if (this.getLanguageOptions() == null) {
            this.setLanguageOptions(languageOptionsCopy);
        } else {
            this.getLanguageOptions().addAll(languageOptionsCopy);
        }
        return this;
    }

    public void setSubtitles(Subtitles subtitles) {
        this.subtitles = subtitles;
    }

    public Subtitles getSubtitles() {
        return this.subtitles;
    }

    public StartTranscriptionJobRequest withSubtitles(Subtitles subtitles) {
        this.setSubtitles(subtitles);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public StartTranscriptionJobRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public StartTranscriptionJobRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public Map<String, LanguageIdSettings> getLanguageIdSettings() {
        return this.languageIdSettings;
    }

    public void setLanguageIdSettings(Map<String, LanguageIdSettings> languageIdSettings) {
        this.languageIdSettings = languageIdSettings;
    }

    public StartTranscriptionJobRequest withLanguageIdSettings(Map<String, LanguageIdSettings> languageIdSettings) {
        this.setLanguageIdSettings(languageIdSettings);
        return this;
    }

    public StartTranscriptionJobRequest addLanguageIdSettingsEntry(String key, LanguageIdSettings value) {
        if (null == this.languageIdSettings) {
            this.languageIdSettings = new HashMap<String, LanguageIdSettings>();
        }
        if (this.languageIdSettings.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.languageIdSettings.put(key, value);
        return this;
    }

    public StartTranscriptionJobRequest clearLanguageIdSettingsEntries() {
        this.languageIdSettings = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTranscriptionJobName() != null) {
            sb.append("TranscriptionJobName: ").append(this.getTranscriptionJobName()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getMediaSampleRateHertz() != null) {
            sb.append("MediaSampleRateHertz: ").append(this.getMediaSampleRateHertz()).append(",");
        }
        if (this.getMediaFormat() != null) {
            sb.append("MediaFormat: ").append(this.getMediaFormat()).append(",");
        }
        if (this.getMedia() != null) {
            sb.append("Media: ").append(this.getMedia()).append(",");
        }
        if (this.getOutputBucketName() != null) {
            sb.append("OutputBucketName: ").append(this.getOutputBucketName()).append(",");
        }
        if (this.getOutputKey() != null) {
            sb.append("OutputKey: ").append(this.getOutputKey()).append(",");
        }
        if (this.getOutputEncryptionKMSKeyId() != null) {
            sb.append("OutputEncryptionKMSKeyId: ").append(this.getOutputEncryptionKMSKeyId()).append(",");
        }
        if (this.getKMSEncryptionContext() != null) {
            sb.append("KMSEncryptionContext: ").append(this.getKMSEncryptionContext()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings()).append(",");
        }
        if (this.getModelSettings() != null) {
            sb.append("ModelSettings: ").append(this.getModelSettings()).append(",");
        }
        if (this.getJobExecutionSettings() != null) {
            sb.append("JobExecutionSettings: ").append(this.getJobExecutionSettings()).append(",");
        }
        if (this.getContentRedaction() != null) {
            sb.append("ContentRedaction: ").append(this.getContentRedaction()).append(",");
        }
        if (this.getIdentifyLanguage() != null) {
            sb.append("IdentifyLanguage: ").append(this.getIdentifyLanguage()).append(",");
        }
        if (this.getIdentifyMultipleLanguages() != null) {
            sb.append("IdentifyMultipleLanguages: ").append(this.getIdentifyMultipleLanguages()).append(",");
        }
        if (this.getLanguageOptions() != null) {
            sb.append("LanguageOptions: ").append(this.getLanguageOptions()).append(",");
        }
        if (this.getSubtitles() != null) {
            sb.append("Subtitles: ").append(this.getSubtitles()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getLanguageIdSettings() != null) {
            sb.append("LanguageIdSettings: ").append(this.getLanguageIdSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTranscriptionJobRequest)) {
            return false;
        }
        StartTranscriptionJobRequest other = (StartTranscriptionJobRequest)obj;
        if (other.getTranscriptionJobName() == null ^ this.getTranscriptionJobName() == null) {
            return false;
        }
        if (other.getTranscriptionJobName() != null && !other.getTranscriptionJobName().equals(this.getTranscriptionJobName())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getMediaSampleRateHertz() == null ^ this.getMediaSampleRateHertz() == null) {
            return false;
        }
        if (other.getMediaSampleRateHertz() != null && !other.getMediaSampleRateHertz().equals(this.getMediaSampleRateHertz())) {
            return false;
        }
        if (other.getMediaFormat() == null ^ this.getMediaFormat() == null) {
            return false;
        }
        if (other.getMediaFormat() != null && !other.getMediaFormat().equals(this.getMediaFormat())) {
            return false;
        }
        if (other.getMedia() == null ^ this.getMedia() == null) {
            return false;
        }
        if (other.getMedia() != null && !other.getMedia().equals(this.getMedia())) {
            return false;
        }
        if (other.getOutputBucketName() == null ^ this.getOutputBucketName() == null) {
            return false;
        }
        if (other.getOutputBucketName() != null && !other.getOutputBucketName().equals(this.getOutputBucketName())) {
            return false;
        }
        if (other.getOutputKey() == null ^ this.getOutputKey() == null) {
            return false;
        }
        if (other.getOutputKey() != null && !other.getOutputKey().equals(this.getOutputKey())) {
            return false;
        }
        if (other.getOutputEncryptionKMSKeyId() == null ^ this.getOutputEncryptionKMSKeyId() == null) {
            return false;
        }
        if (other.getOutputEncryptionKMSKeyId() != null && !other.getOutputEncryptionKMSKeyId().equals(this.getOutputEncryptionKMSKeyId())) {
            return false;
        }
        if (other.getKMSEncryptionContext() == null ^ this.getKMSEncryptionContext() == null) {
            return false;
        }
        if (other.getKMSEncryptionContext() != null && !other.getKMSEncryptionContext().equals(this.getKMSEncryptionContext())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        if (other.getSettings() != null && !other.getSettings().equals(this.getSettings())) {
            return false;
        }
        if (other.getModelSettings() == null ^ this.getModelSettings() == null) {
            return false;
        }
        if (other.getModelSettings() != null && !other.getModelSettings().equals(this.getModelSettings())) {
            return false;
        }
        if (other.getJobExecutionSettings() == null ^ this.getJobExecutionSettings() == null) {
            return false;
        }
        if (other.getJobExecutionSettings() != null && !other.getJobExecutionSettings().equals(this.getJobExecutionSettings())) {
            return false;
        }
        if (other.getContentRedaction() == null ^ this.getContentRedaction() == null) {
            return false;
        }
        if (other.getContentRedaction() != null && !other.getContentRedaction().equals(this.getContentRedaction())) {
            return false;
        }
        if (other.getIdentifyLanguage() == null ^ this.getIdentifyLanguage() == null) {
            return false;
        }
        if (other.getIdentifyLanguage() != null && !other.getIdentifyLanguage().equals(this.getIdentifyLanguage())) {
            return false;
        }
        if (other.getIdentifyMultipleLanguages() == null ^ this.getIdentifyMultipleLanguages() == null) {
            return false;
        }
        if (other.getIdentifyMultipleLanguages() != null && !other.getIdentifyMultipleLanguages().equals(this.getIdentifyMultipleLanguages())) {
            return false;
        }
        if (other.getLanguageOptions() == null ^ this.getLanguageOptions() == null) {
            return false;
        }
        if (other.getLanguageOptions() != null && !other.getLanguageOptions().equals(this.getLanguageOptions())) {
            return false;
        }
        if (other.getSubtitles() == null ^ this.getSubtitles() == null) {
            return false;
        }
        if (other.getSubtitles() != null && !other.getSubtitles().equals(this.getSubtitles())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getLanguageIdSettings() == null ^ this.getLanguageIdSettings() == null) {
            return false;
        }
        return other.getLanguageIdSettings() == null || other.getLanguageIdSettings().equals(this.getLanguageIdSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTranscriptionJobName() == null ? 0 : this.getTranscriptionJobName().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getMediaSampleRateHertz() == null ? 0 : this.getMediaSampleRateHertz().hashCode());
        hashCode = 31 * hashCode + (this.getMediaFormat() == null ? 0 : this.getMediaFormat().hashCode());
        hashCode = 31 * hashCode + (this.getMedia() == null ? 0 : this.getMedia().hashCode());
        hashCode = 31 * hashCode + (this.getOutputBucketName() == null ? 0 : this.getOutputBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputKey() == null ? 0 : this.getOutputKey().hashCode());
        hashCode = 31 * hashCode + (this.getOutputEncryptionKMSKeyId() == null ? 0 : this.getOutputEncryptionKMSKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getKMSEncryptionContext() == null ? 0 : this.getKMSEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        hashCode = 31 * hashCode + (this.getModelSettings() == null ? 0 : this.getModelSettings().hashCode());
        hashCode = 31 * hashCode + (this.getJobExecutionSettings() == null ? 0 : this.getJobExecutionSettings().hashCode());
        hashCode = 31 * hashCode + (this.getContentRedaction() == null ? 0 : this.getContentRedaction().hashCode());
        hashCode = 31 * hashCode + (this.getIdentifyLanguage() == null ? 0 : this.getIdentifyLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getIdentifyMultipleLanguages() == null ? 0 : this.getIdentifyMultipleLanguages().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageOptions() == null ? 0 : this.getLanguageOptions().hashCode());
        hashCode = 31 * hashCode + (this.getSubtitles() == null ? 0 : this.getSubtitles().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageIdSettings() == null ? 0 : this.getLanguageIdSettings().hashCode());
        return hashCode;
    }

    public StartTranscriptionJobRequest clone() {
        return (StartTranscriptionJobRequest)super.clone();
    }
}

