/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.timestreamwrite.AmazonTimestreamWrite;
import com.amazonaws.services.timestreamwrite.AmazonTimestreamWriteClientBuilder;
import com.amazonaws.services.timestreamwrite.endpointdiscovery.AmazonTimestreamWriteEndpointCache;
import com.amazonaws.services.timestreamwrite.model.AmazonTimestreamWriteException;
import com.amazonaws.services.timestreamwrite.model.CreateBatchLoadTaskRequest;
import com.amazonaws.services.timestreamwrite.model.CreateBatchLoadTaskResult;
import com.amazonaws.services.timestreamwrite.model.CreateDatabaseRequest;
import com.amazonaws.services.timestreamwrite.model.CreateDatabaseResult;
import com.amazonaws.services.timestreamwrite.model.CreateTableRequest;
import com.amazonaws.services.timestreamwrite.model.CreateTableResult;
import com.amazonaws.services.timestreamwrite.model.DeleteDatabaseRequest;
import com.amazonaws.services.timestreamwrite.model.DeleteDatabaseResult;
import com.amazonaws.services.timestreamwrite.model.DeleteTableRequest;
import com.amazonaws.services.timestreamwrite.model.DeleteTableResult;
import com.amazonaws.services.timestreamwrite.model.DescribeBatchLoadTaskRequest;
import com.amazonaws.services.timestreamwrite.model.DescribeBatchLoadTaskResult;
import com.amazonaws.services.timestreamwrite.model.DescribeDatabaseRequest;
import com.amazonaws.services.timestreamwrite.model.DescribeDatabaseResult;
import com.amazonaws.services.timestreamwrite.model.DescribeEndpointsRequest;
import com.amazonaws.services.timestreamwrite.model.DescribeEndpointsResult;
import com.amazonaws.services.timestreamwrite.model.DescribeTableRequest;
import com.amazonaws.services.timestreamwrite.model.DescribeTableResult;
import com.amazonaws.services.timestreamwrite.model.ListBatchLoadTasksRequest;
import com.amazonaws.services.timestreamwrite.model.ListBatchLoadTasksResult;
import com.amazonaws.services.timestreamwrite.model.ListDatabasesRequest;
import com.amazonaws.services.timestreamwrite.model.ListDatabasesResult;
import com.amazonaws.services.timestreamwrite.model.ListTablesRequest;
import com.amazonaws.services.timestreamwrite.model.ListTablesResult;
import com.amazonaws.services.timestreamwrite.model.ListTagsForResourceRequest;
import com.amazonaws.services.timestreamwrite.model.ListTagsForResourceResult;
import com.amazonaws.services.timestreamwrite.model.ResumeBatchLoadTaskRequest;
import com.amazonaws.services.timestreamwrite.model.ResumeBatchLoadTaskResult;
import com.amazonaws.services.timestreamwrite.model.TagResourceRequest;
import com.amazonaws.services.timestreamwrite.model.TagResourceResult;
import com.amazonaws.services.timestreamwrite.model.UntagResourceRequest;
import com.amazonaws.services.timestreamwrite.model.UntagResourceResult;
import com.amazonaws.services.timestreamwrite.model.UpdateDatabaseRequest;
import com.amazonaws.services.timestreamwrite.model.UpdateDatabaseResult;
import com.amazonaws.services.timestreamwrite.model.UpdateTableRequest;
import com.amazonaws.services.timestreamwrite.model.UpdateTableResult;
import com.amazonaws.services.timestreamwrite.model.WriteRecordsRequest;
import com.amazonaws.services.timestreamwrite.model.WriteRecordsResult;
import com.amazonaws.services.timestreamwrite.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.CreateBatchLoadTaskRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.CreateBatchLoadTaskResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.CreateDatabaseRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.CreateDatabaseResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.CreateTableRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.CreateTableResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DeleteDatabaseRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DeleteDatabaseResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DeleteTableRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DeleteTableResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DescribeBatchLoadTaskRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DescribeBatchLoadTaskResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DescribeDatabaseRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DescribeDatabaseResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DescribeEndpointsRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DescribeEndpointsResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DescribeTableRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.DescribeTableResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.InvalidEndpointExceptionUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ListBatchLoadTasksRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ListBatchLoadTasksResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ListDatabasesRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ListDatabasesResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ListTablesRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ListTablesResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.RejectedRecordsExceptionUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ResumeBatchLoadTaskRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ResumeBatchLoadTaskResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.UpdateDatabaseRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.UpdateDatabaseResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.UpdateTableRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.UpdateTableResultJsonUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.WriteRecordsRequestProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.transform.WriteRecordsResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonTimestreamWriteClient
extends AmazonWebServiceClient
implements AmazonTimestreamWrite {
    protected AmazonTimestreamWriteEndpointCache cache;
    private final boolean endpointDiscoveryEnabled;
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonTimestreamWrite.class);
    private static final String DEFAULT_SIGNING_NAME = "timestream";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidEndpointException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidEndpointExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RejectedRecordsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RejectedRecordsExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonTimestreamWriteException.class));

    public static AmazonTimestreamWriteClientBuilder builder() {
        return AmazonTimestreamWriteClientBuilder.standard();
    }

    AmazonTimestreamWriteClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonTimestreamWriteClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        if (this.endpointDiscoveryEnabled) {
            this.cache = new AmazonTimestreamWriteEndpointCache(this);
        }
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("ingest.timestream");
        this.setEndpoint("ingest.timestream.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/timestreamwrite/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/timestreamwrite/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateBatchLoadTaskResult createBatchLoadTask(CreateBatchLoadTaskRequest request) {
        request = (CreateBatchLoadTaskRequest)this.beforeClientExecution(request);
        return this.executeCreateBatchLoadTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBatchLoadTaskResult executeCreateBatchLoadTask(CreateBatchLoadTaskRequest createBatchLoadTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBatchLoadTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBatchLoadTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBatchLoadTaskRequestProtocolMarshaller(protocolFactory).marshall((CreateBatchLoadTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBatchLoadTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateBatchLoadTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBatchLoadTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            CreateBatchLoadTaskResult createBatchLoadTaskResult = (CreateBatchLoadTaskResult)response.getAwsResponse();
            return createBatchLoadTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDatabaseResult createDatabase(CreateDatabaseRequest request) {
        request = (CreateDatabaseRequest)this.beforeClientExecution(request);
        return this.executeCreateDatabase(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDatabaseResult executeCreateDatabase(CreateDatabaseRequest createDatabaseRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDatabaseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDatabaseRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDatabaseRequestProtocolMarshaller(protocolFactory).marshall((CreateDatabaseRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDatabaseRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDatabase");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDatabaseResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            CreateDatabaseResult createDatabaseResult = (CreateDatabaseResult)response.getAwsResponse();
            return createDatabaseResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateTableResult createTable(CreateTableRequest request) {
        request = (CreateTableRequest)this.beforeClientExecution(request);
        return this.executeCreateTable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTableResult executeCreateTable(CreateTableRequest createTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTableRequestProtocolMarshaller(protocolFactory).marshall((CreateTableRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateTable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            CreateTableResult createTableResult = (CreateTableResult)response.getAwsResponse();
            return createTableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDatabaseResult deleteDatabase(DeleteDatabaseRequest request) {
        request = (DeleteDatabaseRequest)this.beforeClientExecution(request);
        return this.executeDeleteDatabase(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDatabaseResult executeDeleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDatabaseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatabaseRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatabaseRequestProtocolMarshaller(protocolFactory).marshall((DeleteDatabaseRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDatabaseRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDatabase");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDatabaseResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            DeleteDatabaseResult deleteDatabaseResult = (DeleteDatabaseResult)response.getAwsResponse();
            return deleteDatabaseResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTableResult deleteTable(DeleteTableRequest request) {
        request = (DeleteTableRequest)this.beforeClientExecution(request);
        return this.executeDeleteTable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTableResult executeDeleteTable(DeleteTableRequest deleteTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTableRequestProtocolMarshaller(protocolFactory).marshall((DeleteTableRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteTable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            DeleteTableResult deleteTableResult = (DeleteTableResult)response.getAwsResponse();
            return deleteTableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBatchLoadTaskResult describeBatchLoadTask(DescribeBatchLoadTaskRequest request) {
        request = (DescribeBatchLoadTaskRequest)this.beforeClientExecution(request);
        return this.executeDescribeBatchLoadTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBatchLoadTaskResult executeDescribeBatchLoadTask(DescribeBatchLoadTaskRequest describeBatchLoadTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBatchLoadTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBatchLoadTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBatchLoadTaskRequestProtocolMarshaller(protocolFactory).marshall((DescribeBatchLoadTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBatchLoadTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBatchLoadTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBatchLoadTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            DescribeBatchLoadTaskResult describeBatchLoadTaskResult = (DescribeBatchLoadTaskResult)response.getAwsResponse();
            return describeBatchLoadTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDatabaseResult describeDatabase(DescribeDatabaseRequest request) {
        request = (DescribeDatabaseRequest)this.beforeClientExecution(request);
        return this.executeDescribeDatabase(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDatabaseResult executeDescribeDatabase(DescribeDatabaseRequest describeDatabaseRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDatabaseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDatabaseRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDatabaseRequestProtocolMarshaller(protocolFactory).marshall((DescribeDatabaseRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDatabaseRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDatabase");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDatabaseResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            DescribeDatabaseResult describeDatabaseResult = (DescribeDatabaseResult)response.getAwsResponse();
            return describeDatabaseResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEndpointsResult describeEndpoints(DescribeEndpointsRequest request) {
        request = (DescribeEndpointsRequest)this.beforeClientExecution(request);
        return this.executeDescribeEndpoints(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEndpointsResult executeDescribeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEndpointsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEndpointsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEndpointsRequestProtocolMarshaller(protocolFactory).marshall((DescribeEndpointsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEndpointsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEndpoints");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEndpointsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEndpointsResult describeEndpointsResult = (DescribeEndpointsResult)response.getAwsResponse();
            return describeEndpointsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTableResult describeTable(DescribeTableRequest request) {
        request = (DescribeTableRequest)this.beforeClientExecution(request);
        return this.executeDescribeTable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTableResult executeDescribeTable(DescribeTableRequest describeTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTableRequestProtocolMarshaller(protocolFactory).marshall((DescribeTableRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeTable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            DescribeTableResult describeTableResult = (DescribeTableResult)response.getAwsResponse();
            return describeTableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBatchLoadTasksResult listBatchLoadTasks(ListBatchLoadTasksRequest request) {
        request = (ListBatchLoadTasksRequest)this.beforeClientExecution(request);
        return this.executeListBatchLoadTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBatchLoadTasksResult executeListBatchLoadTasks(ListBatchLoadTasksRequest listBatchLoadTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBatchLoadTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBatchLoadTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBatchLoadTasksRequestProtocolMarshaller(protocolFactory).marshall((ListBatchLoadTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listBatchLoadTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListBatchLoadTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBatchLoadTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            ListBatchLoadTasksResult listBatchLoadTasksResult = (ListBatchLoadTasksResult)response.getAwsResponse();
            return listBatchLoadTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDatabasesResult listDatabases(ListDatabasesRequest request) {
        request = (ListDatabasesRequest)this.beforeClientExecution(request);
        return this.executeListDatabases(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDatabasesResult executeListDatabases(ListDatabasesRequest listDatabasesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDatabasesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatabasesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatabasesRequestProtocolMarshaller(protocolFactory).marshall((ListDatabasesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDatabasesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDatabases");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDatabasesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            ListDatabasesResult listDatabasesResult = (ListDatabasesResult)response.getAwsResponse();
            return listDatabasesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTablesResult listTables(ListTablesRequest request) {
        request = (ListTablesRequest)this.beforeClientExecution(request);
        return this.executeListTables(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTablesResult executeListTables(ListTablesRequest listTablesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTablesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTablesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTablesRequestProtocolMarshaller(protocolFactory).marshall((ListTablesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTablesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTables");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTablesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            ListTablesResult listTablesResult = (ListTablesResult)response.getAwsResponse();
            return listTablesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResumeBatchLoadTaskResult resumeBatchLoadTask(ResumeBatchLoadTaskRequest request) {
        request = (ResumeBatchLoadTaskRequest)this.beforeClientExecution(request);
        return this.executeResumeBatchLoadTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ResumeBatchLoadTaskResult executeResumeBatchLoadTask(ResumeBatchLoadTaskRequest resumeBatchLoadTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resumeBatchLoadTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ResumeBatchLoadTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ResumeBatchLoadTaskRequestProtocolMarshaller(protocolFactory).marshall((ResumeBatchLoadTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)resumeBatchLoadTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ResumeBatchLoadTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ResumeBatchLoadTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            ResumeBatchLoadTaskResult resumeBatchLoadTaskResult = (ResumeBatchLoadTaskResult)response.getAwsResponse();
            return resumeBatchLoadTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDatabaseResult updateDatabase(UpdateDatabaseRequest request) {
        request = (UpdateDatabaseRequest)this.beforeClientExecution(request);
        return this.executeUpdateDatabase(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDatabaseResult executeUpdateDatabase(UpdateDatabaseRequest updateDatabaseRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDatabaseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDatabaseRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDatabaseRequestProtocolMarshaller(protocolFactory).marshall((UpdateDatabaseRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDatabaseRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDatabase");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDatabaseResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            UpdateDatabaseResult updateDatabaseResult = (UpdateDatabaseResult)response.getAwsResponse();
            return updateDatabaseResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateTableResult updateTable(UpdateTableRequest request) {
        request = (UpdateTableRequest)this.beforeClientExecution(request);
        return this.executeUpdateTable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateTableResult executeUpdateTable(UpdateTableRequest updateTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTableRequestProtocolMarshaller(protocolFactory).marshall((UpdateTableRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateTableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateTable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateTableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            UpdateTableResult updateTableResult = (UpdateTableResult)response.getAwsResponse();
            return updateTableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public WriteRecordsResult writeRecords(WriteRecordsRequest request) {
        request = (WriteRecordsRequest)this.beforeClientExecution(request);
        return this.executeWriteRecords(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final WriteRecordsResult executeWriteRecords(WriteRecordsRequest writeRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(writeRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<WriteRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new WriteRecordsRequestProtocolMarshaller(protocolFactory).marshall((WriteRecordsRequest)super.beforeMarshalling((AmazonWebServiceRequest)writeRecordsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Write");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"WriteRecords");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new WriteRecordsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            WriteRecordsResult writeRecordsResult = (WriteRecordsResult)response.getAwsResponse();
            return writeRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.cache != null) {
            this.cache.shutdown();
        }
    }
}

