/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.timestreamwrite.model.Record;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WriteRecordsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String databaseName;
    private String tableName;
    private Record commonAttributes;
    private List<Record> records;

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public WriteRecordsRequest withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public WriteRecordsRequest withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public void setCommonAttributes(Record commonAttributes) {
        this.commonAttributes = commonAttributes;
    }

    public Record getCommonAttributes() {
        return this.commonAttributes;
    }

    public WriteRecordsRequest withCommonAttributes(Record commonAttributes) {
        this.setCommonAttributes(commonAttributes);
        return this;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public void setRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        this.records = new ArrayList<Record>(records);
    }

    public WriteRecordsRequest withRecords(Record ... records) {
        if (this.records == null) {
            this.setRecords(new ArrayList<Record>(records.length));
        }
        for (Record ele : records) {
            this.records.add(ele);
        }
        return this;
    }

    public WriteRecordsRequest withRecords(Collection<Record> records) {
        this.setRecords(records);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getCommonAttributes() != null) {
            sb.append("CommonAttributes: ").append(this.getCommonAttributes()).append(",");
        }
        if (this.getRecords() != null) {
            sb.append("Records: ").append(this.getRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteRecordsRequest)) {
            return false;
        }
        WriteRecordsRequest other = (WriteRecordsRequest)obj;
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getCommonAttributes() == null ^ this.getCommonAttributes() == null) {
            return false;
        }
        if (other.getCommonAttributes() != null && !other.getCommonAttributes().equals(this.getCommonAttributes())) {
            return false;
        }
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        return other.getRecords() == null || other.getRecords().equals(this.getRecords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getCommonAttributes() == null ? 0 : this.getCommonAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : this.getRecords().hashCode());
        return hashCode;
    }

    public WriteRecordsRequest clone() {
        return (WriteRecordsRequest)super.clone();
    }
}

