/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.ExecutionStats;

@SdkInternalApi
public class ExecutionStatsMarshaller {
    private static final MarshallingInfo<Long> EXECUTIONTIMEINMILLIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionTimeInMillis").build();
    private static final MarshallingInfo<Long> DATAWRITES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataWrites").build();
    private static final MarshallingInfo<Long> BYTESMETERED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BytesMetered").build();
    private static final MarshallingInfo<Long> CUMULATIVEBYTESSCANNED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CumulativeBytesScanned").build();
    private static final MarshallingInfo<Long> RECORDSINGESTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordsIngested").build();
    private static final MarshallingInfo<Long> QUERYRESULTROWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryResultRows").build();
    private static final ExecutionStatsMarshaller instance = new ExecutionStatsMarshaller();

    public static ExecutionStatsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExecutionStats executionStats, ProtocolMarshaller protocolMarshaller) {
        if (executionStats == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)executionStats.getExecutionTimeInMillis(), EXECUTIONTIMEINMILLIS_BINDING);
            protocolMarshaller.marshall((Object)executionStats.getDataWrites(), DATAWRITES_BINDING);
            protocolMarshaller.marshall((Object)executionStats.getBytesMetered(), BYTESMETERED_BINDING);
            protocolMarshaller.marshall((Object)executionStats.getCumulativeBytesScanned(), CUMULATIVEBYTESSCANNED_BINDING);
            protocolMarshaller.marshall((Object)executionStats.getRecordsIngested(), RECORDSINGESTED_BINDING);
            protocolMarshaller.marshall((Object)executionStats.getQueryResultRows(), QUERYRESULTROWS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

