/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryAsync;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryAsyncClientBuilder;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryClient;
import com.amazonaws.services.timestreamquery.model.CancelQueryRequest;
import com.amazonaws.services.timestreamquery.model.CancelQueryResult;
import com.amazonaws.services.timestreamquery.model.CreateScheduledQueryRequest;
import com.amazonaws.services.timestreamquery.model.CreateScheduledQueryResult;
import com.amazonaws.services.timestreamquery.model.DeleteScheduledQueryRequest;
import com.amazonaws.services.timestreamquery.model.DeleteScheduledQueryResult;
import com.amazonaws.services.timestreamquery.model.DescribeEndpointsRequest;
import com.amazonaws.services.timestreamquery.model.DescribeEndpointsResult;
import com.amazonaws.services.timestreamquery.model.DescribeScheduledQueryRequest;
import com.amazonaws.services.timestreamquery.model.DescribeScheduledQueryResult;
import com.amazonaws.services.timestreamquery.model.ExecuteScheduledQueryRequest;
import com.amazonaws.services.timestreamquery.model.ExecuteScheduledQueryResult;
import com.amazonaws.services.timestreamquery.model.ListScheduledQueriesRequest;
import com.amazonaws.services.timestreamquery.model.ListScheduledQueriesResult;
import com.amazonaws.services.timestreamquery.model.ListTagsForResourceRequest;
import com.amazonaws.services.timestreamquery.model.ListTagsForResourceResult;
import com.amazonaws.services.timestreamquery.model.PrepareQueryRequest;
import com.amazonaws.services.timestreamquery.model.PrepareQueryResult;
import com.amazonaws.services.timestreamquery.model.QueryRequest;
import com.amazonaws.services.timestreamquery.model.QueryResult;
import com.amazonaws.services.timestreamquery.model.TagResourceRequest;
import com.amazonaws.services.timestreamquery.model.TagResourceResult;
import com.amazonaws.services.timestreamquery.model.UntagResourceRequest;
import com.amazonaws.services.timestreamquery.model.UntagResourceResult;
import com.amazonaws.services.timestreamquery.model.UpdateScheduledQueryRequest;
import com.amazonaws.services.timestreamquery.model.UpdateScheduledQueryResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonTimestreamQueryAsyncClient
extends AmazonTimestreamQueryClient
implements AmazonTimestreamQueryAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonTimestreamQueryAsyncClientBuilder asyncBuilder() {
        return AmazonTimestreamQueryAsyncClientBuilder.standard();
    }

    AmazonTimestreamQueryAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonTimestreamQueryAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelQueryResult> cancelQueryAsync(CancelQueryRequest request) {
        return this.cancelQueryAsync(request, null);
    }

    @Override
    public Future<CancelQueryResult> cancelQueryAsync(CancelQueryRequest request, final AsyncHandler<CancelQueryRequest, CancelQueryResult> asyncHandler) {
        final CancelQueryRequest finalRequest = (CancelQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelQueryResult>(){

            @Override
            public CancelQueryResult call() throws Exception {
                CancelQueryResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeCancelQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateScheduledQueryResult> createScheduledQueryAsync(CreateScheduledQueryRequest request) {
        return this.createScheduledQueryAsync(request, null);
    }

    @Override
    public Future<CreateScheduledQueryResult> createScheduledQueryAsync(CreateScheduledQueryRequest request, final AsyncHandler<CreateScheduledQueryRequest, CreateScheduledQueryResult> asyncHandler) {
        final CreateScheduledQueryRequest finalRequest = (CreateScheduledQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateScheduledQueryResult>(){

            @Override
            public CreateScheduledQueryResult call() throws Exception {
                CreateScheduledQueryResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeCreateScheduledQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteScheduledQueryResult> deleteScheduledQueryAsync(DeleteScheduledQueryRequest request) {
        return this.deleteScheduledQueryAsync(request, null);
    }

    @Override
    public Future<DeleteScheduledQueryResult> deleteScheduledQueryAsync(DeleteScheduledQueryRequest request, final AsyncHandler<DeleteScheduledQueryRequest, DeleteScheduledQueryResult> asyncHandler) {
        final DeleteScheduledQueryRequest finalRequest = (DeleteScheduledQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteScheduledQueryResult>(){

            @Override
            public DeleteScheduledQueryResult call() throws Exception {
                DeleteScheduledQueryResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeDeleteScheduledQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEndpointsResult> describeEndpointsAsync(DescribeEndpointsRequest request) {
        return this.describeEndpointsAsync(request, null);
    }

    @Override
    public Future<DescribeEndpointsResult> describeEndpointsAsync(DescribeEndpointsRequest request, final AsyncHandler<DescribeEndpointsRequest, DescribeEndpointsResult> asyncHandler) {
        final DescribeEndpointsRequest finalRequest = (DescribeEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEndpointsResult>(){

            @Override
            public DescribeEndpointsResult call() throws Exception {
                DescribeEndpointsResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeDescribeEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScheduledQueryResult> describeScheduledQueryAsync(DescribeScheduledQueryRequest request) {
        return this.describeScheduledQueryAsync(request, null);
    }

    @Override
    public Future<DescribeScheduledQueryResult> describeScheduledQueryAsync(DescribeScheduledQueryRequest request, final AsyncHandler<DescribeScheduledQueryRequest, DescribeScheduledQueryResult> asyncHandler) {
        final DescribeScheduledQueryRequest finalRequest = (DescribeScheduledQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeScheduledQueryResult>(){

            @Override
            public DescribeScheduledQueryResult call() throws Exception {
                DescribeScheduledQueryResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeDescribeScheduledQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExecuteScheduledQueryResult> executeScheduledQueryAsync(ExecuteScheduledQueryRequest request) {
        return this.executeScheduledQueryAsync(request, null);
    }

    @Override
    public Future<ExecuteScheduledQueryResult> executeScheduledQueryAsync(ExecuteScheduledQueryRequest request, final AsyncHandler<ExecuteScheduledQueryRequest, ExecuteScheduledQueryResult> asyncHandler) {
        final ExecuteScheduledQueryRequest finalRequest = (ExecuteScheduledQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExecuteScheduledQueryResult>(){

            @Override
            public ExecuteScheduledQueryResult call() throws Exception {
                ExecuteScheduledQueryResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeExecuteScheduledQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListScheduledQueriesResult> listScheduledQueriesAsync(ListScheduledQueriesRequest request) {
        return this.listScheduledQueriesAsync(request, null);
    }

    @Override
    public Future<ListScheduledQueriesResult> listScheduledQueriesAsync(ListScheduledQueriesRequest request, final AsyncHandler<ListScheduledQueriesRequest, ListScheduledQueriesResult> asyncHandler) {
        final ListScheduledQueriesRequest finalRequest = (ListScheduledQueriesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListScheduledQueriesResult>(){

            @Override
            public ListScheduledQueriesResult call() throws Exception {
                ListScheduledQueriesResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeListScheduledQueries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PrepareQueryResult> prepareQueryAsync(PrepareQueryRequest request) {
        return this.prepareQueryAsync(request, null);
    }

    @Override
    public Future<PrepareQueryResult> prepareQueryAsync(PrepareQueryRequest request, final AsyncHandler<PrepareQueryRequest, PrepareQueryResult> asyncHandler) {
        final PrepareQueryRequest finalRequest = (PrepareQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PrepareQueryResult>(){

            @Override
            public PrepareQueryResult call() throws Exception {
                PrepareQueryResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executePrepareQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<QueryResult> queryAsync(QueryRequest request) {
        return this.queryAsync(request, null);
    }

    @Override
    public Future<QueryResult> queryAsync(QueryRequest request, final AsyncHandler<QueryRequest, QueryResult> asyncHandler) {
        final QueryRequest finalRequest = (QueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<QueryResult>(){

            @Override
            public QueryResult call() throws Exception {
                QueryResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateScheduledQueryResult> updateScheduledQueryAsync(UpdateScheduledQueryRequest request) {
        return this.updateScheduledQueryAsync(request, null);
    }

    @Override
    public Future<UpdateScheduledQueryResult> updateScheduledQueryAsync(UpdateScheduledQueryRequest request, final AsyncHandler<UpdateScheduledQueryRequest, UpdateScheduledQueryResult> asyncHandler) {
        final UpdateScheduledQueryRequest finalRequest = (UpdateScheduledQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateScheduledQueryResult>(){

            @Override
            public UpdateScheduledQueryResult call() throws Exception {
                UpdateScheduledQueryResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeUpdateScheduledQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

