/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.LendingField;
import java.util.List;

@SdkInternalApi
public class LendingFieldMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<StructuredPojo> KEYDETECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyDetection").build();
    private static final MarshallingInfo<List> VALUEDETECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValueDetections").build();
    private static final LendingFieldMarshaller instance = new LendingFieldMarshaller();

    public static LendingFieldMarshaller getInstance() {
        return instance;
    }

    public void marshall(LendingField lendingField, ProtocolMarshaller protocolMarshaller) {
        if (lendingField == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)lendingField.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)lendingField.getKeyDetection(), KEYDETECTION_BINDING);
            protocolMarshaller.marshall(lendingField.getValueDetections(), VALUEDETECTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

