/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.LendingField;
import com.amazonaws.services.textract.model.SignatureDetection;
import com.amazonaws.services.textract.model.transform.LendingDocumentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LendingDocument
implements Serializable,
Cloneable,
StructuredPojo {
    private List<LendingField> lendingFields;
    private List<SignatureDetection> signatureDetections;

    public List<LendingField> getLendingFields() {
        return this.lendingFields;
    }

    public void setLendingFields(Collection<LendingField> lendingFields) {
        if (lendingFields == null) {
            this.lendingFields = null;
            return;
        }
        this.lendingFields = new ArrayList<LendingField>(lendingFields);
    }

    public LendingDocument withLendingFields(LendingField ... lendingFields) {
        if (this.lendingFields == null) {
            this.setLendingFields(new ArrayList<LendingField>(lendingFields.length));
        }
        for (LendingField ele : lendingFields) {
            this.lendingFields.add(ele);
        }
        return this;
    }

    public LendingDocument withLendingFields(Collection<LendingField> lendingFields) {
        this.setLendingFields(lendingFields);
        return this;
    }

    public List<SignatureDetection> getSignatureDetections() {
        return this.signatureDetections;
    }

    public void setSignatureDetections(Collection<SignatureDetection> signatureDetections) {
        if (signatureDetections == null) {
            this.signatureDetections = null;
            return;
        }
        this.signatureDetections = new ArrayList<SignatureDetection>(signatureDetections);
    }

    public LendingDocument withSignatureDetections(SignatureDetection ... signatureDetections) {
        if (this.signatureDetections == null) {
            this.setSignatureDetections(new ArrayList<SignatureDetection>(signatureDetections.length));
        }
        for (SignatureDetection ele : signatureDetections) {
            this.signatureDetections.add(ele);
        }
        return this;
    }

    public LendingDocument withSignatureDetections(Collection<SignatureDetection> signatureDetections) {
        this.setSignatureDetections(signatureDetections);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLendingFields() != null) {
            sb.append("LendingFields: ").append(this.getLendingFields()).append(",");
        }
        if (this.getSignatureDetections() != null) {
            sb.append("SignatureDetections: ").append(this.getSignatureDetections());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingDocument)) {
            return false;
        }
        LendingDocument other = (LendingDocument)obj;
        if (other.getLendingFields() == null ^ this.getLendingFields() == null) {
            return false;
        }
        if (other.getLendingFields() != null && !other.getLendingFields().equals(this.getLendingFields())) {
            return false;
        }
        if (other.getSignatureDetections() == null ^ this.getSignatureDetections() == null) {
            return false;
        }
        return other.getSignatureDetections() == null || other.getSignatureDetections().equals(this.getSignatureDetections());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLendingFields() == null ? 0 : this.getLendingFields().hashCode());
        hashCode = 31 * hashCode + (this.getSignatureDetections() == null ? 0 : this.getSignatureDetections().hashCode());
        return hashCode;
    }

    public LendingDocument clone() {
        try {
            return (LendingDocument)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LendingDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

