/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.textract.model.AdapterVersionOverview;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AdapterVersionOverviewMarshaller {
    private static final MarshallingInfo<String> ADAPTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdapterId").build();
    private static final MarshallingInfo<String> ADAPTERVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdapterVersion").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> FEATURETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeatureTypes").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").build();
    private static final AdapterVersionOverviewMarshaller instance = new AdapterVersionOverviewMarshaller();

    public static AdapterVersionOverviewMarshaller getInstance() {
        return instance;
    }

    public void marshall(AdapterVersionOverview adapterVersionOverview, ProtocolMarshaller protocolMarshaller) {
        if (adapterVersionOverview == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)adapterVersionOverview.getAdapterId(), ADAPTERID_BINDING);
            protocolMarshaller.marshall((Object)adapterVersionOverview.getAdapterVersion(), ADAPTERVERSION_BINDING);
            protocolMarshaller.marshall((Object)adapterVersionOverview.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(adapterVersionOverview.getFeatureTypes(), FEATURETYPES_BINDING);
            protocolMarshaller.marshall((Object)adapterVersionOverview.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)adapterVersionOverview.getStatusMessage(), STATUSMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

