/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.LendingDetection;
import com.amazonaws.services.textract.model.transform.LendingFieldMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LendingField
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private LendingDetection keyDetection;
    private List<LendingDetection> valueDetections;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public LendingField withType(String type) {
        this.setType(type);
        return this;
    }

    public void setKeyDetection(LendingDetection keyDetection) {
        this.keyDetection = keyDetection;
    }

    public LendingDetection getKeyDetection() {
        return this.keyDetection;
    }

    public LendingField withKeyDetection(LendingDetection keyDetection) {
        this.setKeyDetection(keyDetection);
        return this;
    }

    public List<LendingDetection> getValueDetections() {
        return this.valueDetections;
    }

    public void setValueDetections(Collection<LendingDetection> valueDetections) {
        if (valueDetections == null) {
            this.valueDetections = null;
            return;
        }
        this.valueDetections = new ArrayList<LendingDetection>(valueDetections);
    }

    public LendingField withValueDetections(LendingDetection ... valueDetections) {
        if (this.valueDetections == null) {
            this.setValueDetections(new ArrayList<LendingDetection>(valueDetections.length));
        }
        for (LendingDetection ele : valueDetections) {
            this.valueDetections.add(ele);
        }
        return this;
    }

    public LendingField withValueDetections(Collection<LendingDetection> valueDetections) {
        this.setValueDetections(valueDetections);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getKeyDetection() != null) {
            sb.append("KeyDetection: ").append(this.getKeyDetection()).append(",");
        }
        if (this.getValueDetections() != null) {
            sb.append("ValueDetections: ").append(this.getValueDetections());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingField)) {
            return false;
        }
        LendingField other = (LendingField)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getKeyDetection() == null ^ this.getKeyDetection() == null) {
            return false;
        }
        if (other.getKeyDetection() != null && !other.getKeyDetection().equals(this.getKeyDetection())) {
            return false;
        }
        if (other.getValueDetections() == null ^ this.getValueDetections() == null) {
            return false;
        }
        return other.getValueDetections() == null || other.getValueDetections().equals(this.getValueDetections());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getKeyDetection() == null ? 0 : this.getKeyDetection().hashCode());
        hashCode = 31 * hashCode + (this.getValueDetections() == null ? 0 : this.getValueDetections().hashCode());
        return hashCode;
    }

    public LendingField clone() {
        try {
            return (LendingField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LendingFieldMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

