/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.services.textract.model.ExpenseDocument;
import com.amazonaws.services.textract.model.transform.BlockJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.ExpenseFieldJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.LineItemGroupJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class ExpenseDocumentJsonUnmarshaller
implements Unmarshaller<ExpenseDocument, JsonUnmarshallerContext> {
    private static ExpenseDocumentJsonUnmarshaller instance;

    public ExpenseDocument unmarshall(JsonUnmarshallerContext context) throws Exception {
        ExpenseDocument expenseDocument = new ExpenseDocument();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ExpenseIndex", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    expenseDocument.setExpenseIndex((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("SummaryFields", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    expenseDocument.setSummaryFields(new ListUnmarshaller((Unmarshaller)ExpenseFieldJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("LineItemGroups", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    expenseDocument.setLineItemGroups(new ListUnmarshaller((Unmarshaller)LineItemGroupJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Blocks", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    expenseDocument.setBlocks(new ListUnmarshaller((Unmarshaller)BlockJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return expenseDocument;
    }

    public static ExpenseDocumentJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ExpenseDocumentJsonUnmarshaller();
        }
        return instance;
    }
}

