/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.textract.model.DocumentGroup;
import java.util.List;

@SdkInternalApi
public class DocumentGroupMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<List> SPLITDOCUMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SplitDocuments").build();
    private static final MarshallingInfo<List> DETECTEDSIGNATURES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetectedSignatures").build();
    private static final MarshallingInfo<List> UNDETECTEDSIGNATURES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UndetectedSignatures").build();
    private static final DocumentGroupMarshaller instance = new DocumentGroupMarshaller();

    public static DocumentGroupMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentGroup documentGroup, ProtocolMarshaller protocolMarshaller) {
        if (documentGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentGroup.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(documentGroup.getSplitDocuments(), SPLITDOCUMENTS_BINDING);
            protocolMarshaller.marshall(documentGroup.getDetectedSignatures(), DETECTEDSIGNATURES_BINDING);
            protocolMarshaller.marshall(documentGroup.getUndetectedSignatures(), UNDETECTEDSIGNATURES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

