/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.taxsettings.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.taxsettings.model.AccountDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTaxRegistrationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AccountDetails> accountDetails;
    private String nextToken;

    public List<AccountDetails> getAccountDetails() {
        return this.accountDetails;
    }

    public void setAccountDetails(Collection<AccountDetails> accountDetails) {
        if (accountDetails == null) {
            this.accountDetails = null;
            return;
        }
        this.accountDetails = new ArrayList<AccountDetails>(accountDetails);
    }

    public ListTaxRegistrationsResult withAccountDetails(AccountDetails ... accountDetails) {
        if (this.accountDetails == null) {
            this.setAccountDetails(new ArrayList<AccountDetails>(accountDetails.length));
        }
        for (AccountDetails ele : accountDetails) {
            this.accountDetails.add(ele);
        }
        return this;
    }

    public ListTaxRegistrationsResult withAccountDetails(Collection<AccountDetails> accountDetails) {
        this.setAccountDetails(accountDetails);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTaxRegistrationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountDetails() != null) {
            sb.append("AccountDetails: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaxRegistrationsResult)) {
            return false;
        }
        ListTaxRegistrationsResult other = (ListTaxRegistrationsResult)obj;
        if (other.getAccountDetails() == null ^ this.getAccountDetails() == null) {
            return false;
        }
        if (other.getAccountDetails() != null && !other.getAccountDetails().equals(this.getAccountDetails())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountDetails() == null ? 0 : this.getAccountDetails().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListTaxRegistrationsResult clone() {
        try {
            return (ListTaxRegistrationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

