/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.synthetics;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.synthetics.AWSSyntheticsAsync;
import com.amazonaws.services.synthetics.AWSSyntheticsAsyncClientBuilder;
import com.amazonaws.services.synthetics.AWSSyntheticsClient;
import com.amazonaws.services.synthetics.model.AssociateResourceRequest;
import com.amazonaws.services.synthetics.model.AssociateResourceResult;
import com.amazonaws.services.synthetics.model.CreateCanaryRequest;
import com.amazonaws.services.synthetics.model.CreateCanaryResult;
import com.amazonaws.services.synthetics.model.CreateGroupRequest;
import com.amazonaws.services.synthetics.model.CreateGroupResult;
import com.amazonaws.services.synthetics.model.DeleteCanaryRequest;
import com.amazonaws.services.synthetics.model.DeleteCanaryResult;
import com.amazonaws.services.synthetics.model.DeleteGroupRequest;
import com.amazonaws.services.synthetics.model.DeleteGroupResult;
import com.amazonaws.services.synthetics.model.DescribeCanariesLastRunRequest;
import com.amazonaws.services.synthetics.model.DescribeCanariesLastRunResult;
import com.amazonaws.services.synthetics.model.DescribeCanariesRequest;
import com.amazonaws.services.synthetics.model.DescribeCanariesResult;
import com.amazonaws.services.synthetics.model.DescribeRuntimeVersionsRequest;
import com.amazonaws.services.synthetics.model.DescribeRuntimeVersionsResult;
import com.amazonaws.services.synthetics.model.DisassociateResourceRequest;
import com.amazonaws.services.synthetics.model.DisassociateResourceResult;
import com.amazonaws.services.synthetics.model.GetCanaryRequest;
import com.amazonaws.services.synthetics.model.GetCanaryResult;
import com.amazonaws.services.synthetics.model.GetCanaryRunsRequest;
import com.amazonaws.services.synthetics.model.GetCanaryRunsResult;
import com.amazonaws.services.synthetics.model.GetGroupRequest;
import com.amazonaws.services.synthetics.model.GetGroupResult;
import com.amazonaws.services.synthetics.model.ListAssociatedGroupsRequest;
import com.amazonaws.services.synthetics.model.ListAssociatedGroupsResult;
import com.amazonaws.services.synthetics.model.ListGroupResourcesRequest;
import com.amazonaws.services.synthetics.model.ListGroupResourcesResult;
import com.amazonaws.services.synthetics.model.ListGroupsRequest;
import com.amazonaws.services.synthetics.model.ListGroupsResult;
import com.amazonaws.services.synthetics.model.ListTagsForResourceRequest;
import com.amazonaws.services.synthetics.model.ListTagsForResourceResult;
import com.amazonaws.services.synthetics.model.StartCanaryRequest;
import com.amazonaws.services.synthetics.model.StartCanaryResult;
import com.amazonaws.services.synthetics.model.StopCanaryRequest;
import com.amazonaws.services.synthetics.model.StopCanaryResult;
import com.amazonaws.services.synthetics.model.TagResourceRequest;
import com.amazonaws.services.synthetics.model.TagResourceResult;
import com.amazonaws.services.synthetics.model.UntagResourceRequest;
import com.amazonaws.services.synthetics.model.UntagResourceResult;
import com.amazonaws.services.synthetics.model.UpdateCanaryRequest;
import com.amazonaws.services.synthetics.model.UpdateCanaryResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSyntheticsAsyncClient
extends AWSSyntheticsClient
implements AWSSyntheticsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSyntheticsAsyncClientBuilder asyncBuilder() {
        return AWSSyntheticsAsyncClientBuilder.standard();
    }

    AWSSyntheticsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSyntheticsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateResourceResult> associateResourceAsync(AssociateResourceRequest request) {
        return this.associateResourceAsync(request, null);
    }

    @Override
    public Future<AssociateResourceResult> associateResourceAsync(AssociateResourceRequest request, final AsyncHandler<AssociateResourceRequest, AssociateResourceResult> asyncHandler) {
        final AssociateResourceRequest finalRequest = (AssociateResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateResourceResult>(){

            @Override
            public AssociateResourceResult call() throws Exception {
                AssociateResourceResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeAssociateResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCanaryResult> createCanaryAsync(CreateCanaryRequest request) {
        return this.createCanaryAsync(request, null);
    }

    @Override
    public Future<CreateCanaryResult> createCanaryAsync(CreateCanaryRequest request, final AsyncHandler<CreateCanaryRequest, CreateCanaryResult> asyncHandler) {
        final CreateCanaryRequest finalRequest = (CreateCanaryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCanaryResult>(){

            @Override
            public CreateCanaryResult call() throws Exception {
                CreateCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeCreateCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request) {
        return this.createGroupAsync(request, null);
    }

    @Override
    public Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request, final AsyncHandler<CreateGroupRequest, CreateGroupResult> asyncHandler) {
        final CreateGroupRequest finalRequest = (CreateGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGroupResult>(){

            @Override
            public CreateGroupResult call() throws Exception {
                CreateGroupResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeCreateGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCanaryResult> deleteCanaryAsync(DeleteCanaryRequest request) {
        return this.deleteCanaryAsync(request, null);
    }

    @Override
    public Future<DeleteCanaryResult> deleteCanaryAsync(DeleteCanaryRequest request, final AsyncHandler<DeleteCanaryRequest, DeleteCanaryResult> asyncHandler) {
        final DeleteCanaryRequest finalRequest = (DeleteCanaryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCanaryResult>(){

            @Override
            public DeleteCanaryResult call() throws Exception {
                DeleteCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeDeleteCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request) {
        return this.deleteGroupAsync(request, null);
    }

    @Override
    public Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request, final AsyncHandler<DeleteGroupRequest, DeleteGroupResult> asyncHandler) {
        final DeleteGroupRequest finalRequest = (DeleteGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGroupResult>(){

            @Override
            public DeleteGroupResult call() throws Exception {
                DeleteGroupResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeDeleteGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCanariesResult> describeCanariesAsync(DescribeCanariesRequest request) {
        return this.describeCanariesAsync(request, null);
    }

    @Override
    public Future<DescribeCanariesResult> describeCanariesAsync(DescribeCanariesRequest request, final AsyncHandler<DescribeCanariesRequest, DescribeCanariesResult> asyncHandler) {
        final DescribeCanariesRequest finalRequest = (DescribeCanariesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCanariesResult>(){

            @Override
            public DescribeCanariesResult call() throws Exception {
                DescribeCanariesResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeDescribeCanaries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCanariesLastRunResult> describeCanariesLastRunAsync(DescribeCanariesLastRunRequest request) {
        return this.describeCanariesLastRunAsync(request, null);
    }

    @Override
    public Future<DescribeCanariesLastRunResult> describeCanariesLastRunAsync(DescribeCanariesLastRunRequest request, final AsyncHandler<DescribeCanariesLastRunRequest, DescribeCanariesLastRunResult> asyncHandler) {
        final DescribeCanariesLastRunRequest finalRequest = (DescribeCanariesLastRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCanariesLastRunResult>(){

            @Override
            public DescribeCanariesLastRunResult call() throws Exception {
                DescribeCanariesLastRunResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeDescribeCanariesLastRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRuntimeVersionsResult> describeRuntimeVersionsAsync(DescribeRuntimeVersionsRequest request) {
        return this.describeRuntimeVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeRuntimeVersionsResult> describeRuntimeVersionsAsync(DescribeRuntimeVersionsRequest request, final AsyncHandler<DescribeRuntimeVersionsRequest, DescribeRuntimeVersionsResult> asyncHandler) {
        final DescribeRuntimeVersionsRequest finalRequest = (DescribeRuntimeVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRuntimeVersionsResult>(){

            @Override
            public DescribeRuntimeVersionsResult call() throws Exception {
                DescribeRuntimeVersionsResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeDescribeRuntimeVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateResourceResult> disassociateResourceAsync(DisassociateResourceRequest request) {
        return this.disassociateResourceAsync(request, null);
    }

    @Override
    public Future<DisassociateResourceResult> disassociateResourceAsync(DisassociateResourceRequest request, final AsyncHandler<DisassociateResourceRequest, DisassociateResourceResult> asyncHandler) {
        final DisassociateResourceRequest finalRequest = (DisassociateResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateResourceResult>(){

            @Override
            public DisassociateResourceResult call() throws Exception {
                DisassociateResourceResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeDisassociateResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCanaryResult> getCanaryAsync(GetCanaryRequest request) {
        return this.getCanaryAsync(request, null);
    }

    @Override
    public Future<GetCanaryResult> getCanaryAsync(GetCanaryRequest request, final AsyncHandler<GetCanaryRequest, GetCanaryResult> asyncHandler) {
        final GetCanaryRequest finalRequest = (GetCanaryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCanaryResult>(){

            @Override
            public GetCanaryResult call() throws Exception {
                GetCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeGetCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCanaryRunsResult> getCanaryRunsAsync(GetCanaryRunsRequest request) {
        return this.getCanaryRunsAsync(request, null);
    }

    @Override
    public Future<GetCanaryRunsResult> getCanaryRunsAsync(GetCanaryRunsRequest request, final AsyncHandler<GetCanaryRunsRequest, GetCanaryRunsResult> asyncHandler) {
        final GetCanaryRunsRequest finalRequest = (GetCanaryRunsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCanaryRunsResult>(){

            @Override
            public GetCanaryRunsResult call() throws Exception {
                GetCanaryRunsResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeGetCanaryRuns(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGroupResult> getGroupAsync(GetGroupRequest request) {
        return this.getGroupAsync(request, null);
    }

    @Override
    public Future<GetGroupResult> getGroupAsync(GetGroupRequest request, final AsyncHandler<GetGroupRequest, GetGroupResult> asyncHandler) {
        final GetGroupRequest finalRequest = (GetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGroupResult>(){

            @Override
            public GetGroupResult call() throws Exception {
                GetGroupResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeGetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssociatedGroupsResult> listAssociatedGroupsAsync(ListAssociatedGroupsRequest request) {
        return this.listAssociatedGroupsAsync(request, null);
    }

    @Override
    public Future<ListAssociatedGroupsResult> listAssociatedGroupsAsync(ListAssociatedGroupsRequest request, final AsyncHandler<ListAssociatedGroupsRequest, ListAssociatedGroupsResult> asyncHandler) {
        final ListAssociatedGroupsRequest finalRequest = (ListAssociatedGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAssociatedGroupsResult>(){

            @Override
            public ListAssociatedGroupsResult call() throws Exception {
                ListAssociatedGroupsResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeListAssociatedGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGroupResourcesResult> listGroupResourcesAsync(ListGroupResourcesRequest request) {
        return this.listGroupResourcesAsync(request, null);
    }

    @Override
    public Future<ListGroupResourcesResult> listGroupResourcesAsync(ListGroupResourcesRequest request, final AsyncHandler<ListGroupResourcesRequest, ListGroupResourcesResult> asyncHandler) {
        final ListGroupResourcesRequest finalRequest = (ListGroupResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGroupResourcesResult>(){

            @Override
            public ListGroupResourcesResult call() throws Exception {
                ListGroupResourcesResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeListGroupResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request) {
        return this.listGroupsAsync(request, null);
    }

    @Override
    public Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request, final AsyncHandler<ListGroupsRequest, ListGroupsResult> asyncHandler) {
        final ListGroupsRequest finalRequest = (ListGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGroupsResult>(){

            @Override
            public ListGroupsResult call() throws Exception {
                ListGroupsResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeListGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartCanaryResult> startCanaryAsync(StartCanaryRequest request) {
        return this.startCanaryAsync(request, null);
    }

    @Override
    public Future<StartCanaryResult> startCanaryAsync(StartCanaryRequest request, final AsyncHandler<StartCanaryRequest, StartCanaryResult> asyncHandler) {
        final StartCanaryRequest finalRequest = (StartCanaryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartCanaryResult>(){

            @Override
            public StartCanaryResult call() throws Exception {
                StartCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeStartCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopCanaryResult> stopCanaryAsync(StopCanaryRequest request) {
        return this.stopCanaryAsync(request, null);
    }

    @Override
    public Future<StopCanaryResult> stopCanaryAsync(StopCanaryRequest request, final AsyncHandler<StopCanaryRequest, StopCanaryResult> asyncHandler) {
        final StopCanaryRequest finalRequest = (StopCanaryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopCanaryResult>(){

            @Override
            public StopCanaryResult call() throws Exception {
                StopCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeStopCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCanaryResult> updateCanaryAsync(UpdateCanaryRequest request) {
        return this.updateCanaryAsync(request, null);
    }

    @Override
    public Future<UpdateCanaryResult> updateCanaryAsync(UpdateCanaryRequest request, final AsyncHandler<UpdateCanaryRequest, UpdateCanaryResult> asyncHandler) {
        final UpdateCanaryRequest finalRequest = (UpdateCanaryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCanaryResult>(){

            @Override
            public UpdateCanaryResult call() throws Exception {
                UpdateCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeUpdateCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

