/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;

public class WorkflowHistoryDecisionTaskIterator
implements Iterator<PollForDecisionTaskResponse> {
    private final SwfClient service;
    private final String domain;
    private final SimpleWorkflowClientConfig config;
    private final PollForDecisionTaskResponse decisionTask;
    private PollForDecisionTaskResponse next;
    private boolean initialized;

    public WorkflowHistoryDecisionTaskIterator(SwfClient service, String domain, PollForDecisionTaskResponse decisionTask, SimpleWorkflowClientConfig config) {
        this.service = service;
        this.domain = domain;
        this.decisionTask = decisionTask;
        this.config = config;
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.initNext();
        }
        if (this.next == null) {
            return false;
        }
        List events = this.next.events();
        return events.size() != 0;
    }

    @Override
    public PollForDecisionTaskResponse next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("hasNext() == false");
        }
        PollForDecisionTaskResponse result = this.next;
        this.next = this.next.nextPageToken() == null ? null : this.getNextHistoryTask(this.next.nextPageToken());
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void initNext() {
        this.initialized = true;
        this.next = this.getNextHistoryTask(null);
    }

    private PollForDecisionTaskResponse getNextHistoryTask(String nextPageToken) {
        GetWorkflowExecutionHistoryResponse history = WorkflowExecutionUtils.getHistoryPage(nextPageToken, this.service, this.domain, WorkflowExecution.fromSdkType(this.decisionTask.workflowExecution()), this.config);
        List events = history.events();
        if (events == null) {
            return null;
        }
        List eventsForDecisionTask = events.stream().filter(event -> event.eventId() <= this.decisionTask.startedEventId()).collect(Collectors.toList());
        return (PollForDecisionTaskResponse)this.decisionTask.toBuilder().events(eventsForDecisionTask).nextPageToken(history.nextPageToken()).build();
    }
}

