/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.ActivityExecutionContext;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementation;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricHelper;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.Metrics;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricsRegistry;
import com.amazonaws.services.simpleworkflow.flow.monitoring.NullMetricsRegistry;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import com.amazonaws.services.simpleworkflow.flow.retry.SynchronousRetrier;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeCompletionRetryOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeExecutionOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.ExponentialRetryParameters;
import com.amazonaws.services.simpleworkflow.flow.worker.SuspendableSemaphore;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.PollForActivityTaskRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.services.swf.model.UnknownResourceException;

public class ActivityTaskPoller
implements TaskPoller<ActivityTask> {
    private static final Log log = LogFactory.getLog(ActivityTaskPoller.class);
    private static final long SECOND = 1000L;
    private SwfClient service;
    private String domain;
    private String taskListToPoll;
    private ActivityImplementationFactory activityImplementationFactory;
    private String identity;
    private boolean initialized;
    private boolean suspended;
    private final Lock lock = new ReentrantLock();
    private final Condition suspentionCondition = this.lock.newCondition();
    private SimpleWorkflowClientConfig config;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private MetricsRegistry metricsRegistry;
    private SuspendableSemaphore pollingSemaphore;

    ActivityTaskPoller() {
        this.identity = ManagementFactory.getRuntimeMXBean().getName();
        int length = Math.min(this.identity.length(), 256);
        this.identity = this.identity.substring(0, length);
        this.metricsRegistry = new NullMetricsRegistry();
    }

    public ActivityTaskPoller(SwfClient service, String domain, String pollTaskList, ActivityImplementationFactory activityImplementationFactory) {
        this(service, domain, pollTaskList, activityImplementationFactory, null);
    }

    public ActivityTaskPoller(SwfClient service, String domain, String pollTaskList, ActivityImplementationFactory activityImplementationFactory, SimpleWorkflowClientConfig config) {
        this(service, domain, pollTaskList, activityImplementationFactory, 100, config);
    }

    public ActivityTaskPoller(SwfClient service, String domain, String pollTaskList, ActivityImplementationFactory activityImplementationFactory, int executeThreadCount, SimpleWorkflowClientConfig config) {
        this();
        this.service = service;
        this.domain = domain;
        this.taskListToPoll = pollTaskList;
        this.activityImplementationFactory = activityImplementationFactory;
        this.config = config;
        this.pollingSemaphore = new SuspendableSemaphore(executeThreadCount);
    }

    private Exception wrapFailure(ActivityTask task, Throwable failure) {
        WorkflowExecution execution = task.getWorkflowExecution();
        RuntimeException e2 = new RuntimeException("Failure taskId=\"" + task.getStartedEventId() + "\" workflowExecutionRunId=\"" + execution.getRunId() + "\" workflowExecutionId=\"" + execution.getWorkflowId() + "\"", failure);
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityTask poll() throws InterruptedException {
        ActivityTask result;
        this.waitIfSuspended();
        if (!this.initialized) {
            this.checkRequiredProperty(this.service, "service");
            this.checkRequiredProperty(this.domain, "domain");
            this.checkRequiredProperty(this.taskListToPoll, "taskListToPoll");
            this.initialized = true;
        }
        Metrics metrics = this.metricsRegistry.newMetrics(MetricName.Operation.ACTIVITY_TASK_POLL.getName());
        metrics.addProperty(MetricName.Property.TASK_LIST.getName(), this.taskListToPoll);
        metrics.addProperty(MetricName.Property.DOMAIN.getName(), this.domain);
        PollForActivityTaskRequest pollRequest = (PollForActivityTaskRequest)PollForActivityTaskRequest.builder().domain(this.domain).identity(this.identity).taskList((TaskList)TaskList.builder().name(this.taskListToPoll).build()).build();
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll request begin: " + pollRequest));
        }
        pollRequest = RequestTimeoutHelper.overridePollRequestTimeout(pollRequest, this.config);
        try {
            PollForActivityTaskRequest finalPollRequest = pollRequest;
            result = ActivityTask.fromSdkType(metrics.recordSupplier(() -> this.service.pollForActivityTask(finalPollRequest), MetricName.Operation.POLL_FOR_ACTIVITY_TASK.getName(), TimeUnit.MILLISECONDS));
            if (result == null || result.getTaskToken() == null) {
                result = null;
            } else {
                MetricHelper.recordMetrics(result, metrics);
            }
            metrics.recordCount(MetricName.EMPTY_POLL_COUNT.getName(), result == null, MetricName.getOperationDimension(MetricName.Operation.POLL_FOR_ACTIVITY_TASK.getName()));
        }
        finally {
            metrics.close();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void execute(ActivityTask task) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void waitIfSuspended() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.suspended) {
                this.suspentionCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void suspend() {
        this.lock.lock();
        try {
            this.suspended = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resume() {
        this.lock.lock();
        try {
            this.suspended = false;
            this.suspentionCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isSuspended() {
        this.lock.lock();
        try {
            boolean bl = this.suspended;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdown() {
    }

    protected void checkRequiredProperty(Object value, String name) {
        if (value == null) {
            throw new IllegalStateException("required property " + name + " is not set");
        }
    }

    protected void respondActivityTaskFailed(String taskToken, String reason, String details) {
        RespondActivityTaskFailedRequest failedResponse = (RespondActivityTaskFailedRequest)RespondActivityTaskFailedRequest.builder().taskToken(taskToken).reason(WorkflowExecutionUtils.truncateReason(reason)).details(details).build();
        RespondActivityTaskFailedRequest finalFailedResponse = failedResponse = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(failedResponse, this.config);
        ThreadLocalMetrics.getMetrics().recordRunnable(() -> this.service.respondActivityTaskFailed(finalFailedResponse), MetricName.Operation.RESPOND_ACTIVITY_TASK_FAILED.getName(), TimeUnit.MILLISECONDS);
    }

    protected void respondActivityTaskCanceledWithRetry(String taskToken, String details, ActivityTypeExecutionOptions executionOptions) {
        SynchronousRetrier retrier = null;
        if (executionOptions != null) {
            ActivityTypeCompletionRetryOptions completionRetryOptions = executionOptions.getCompletionRetryOptions();
            retrier = this.createRetrier(completionRetryOptions);
        }
        if (retrier != null) {
            retrier.retry(() -> this.respondActivityTaskCanceled(taskToken, details));
        } else {
            this.respondActivityTaskCanceled(taskToken, details);
        }
    }

    private SynchronousRetrier createRetrier(ActivityTypeCompletionRetryOptions activityTypeCompletionRetryOptions) {
        if (activityTypeCompletionRetryOptions == null) {
            return null;
        }
        ExponentialRetryParameters retryParameters = new ExponentialRetryParameters();
        retryParameters.setBackoffCoefficient(activityTypeCompletionRetryOptions.getBackoffCoefficient());
        retryParameters.setExpirationInterval(activityTypeCompletionRetryOptions.getRetryExpirationSeconds() * 1000L);
        retryParameters.setInitialInterval(activityTypeCompletionRetryOptions.getInitialRetryIntervalSeconds() * 1000L);
        retryParameters.setMaximumRetries(activityTypeCompletionRetryOptions.getMaximumAttempts() - 1);
        retryParameters.setMaximumRetryInterval(activityTypeCompletionRetryOptions.getMaximumRetryIntervalSeconds() * 1000L);
        retryParameters.setMinimumRetries(activityTypeCompletionRetryOptions.getMinimumAttempts() - 1);
        return new SynchronousRetrier(retryParameters, UnknownResourceException.class);
    }

    protected void respondActivityTaskCanceled(String taskToken, String details) {
        RespondActivityTaskCanceledRequest canceledResponse = (RespondActivityTaskCanceledRequest)RespondActivityTaskCanceledRequest.builder().taskToken(taskToken).details(details).build();
        RespondActivityTaskCanceledRequest finalCanceledResponse = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(canceledResponse, this.config);
        ThreadLocalMetrics.getMetrics().recordRunnable(() -> this.service.respondActivityTaskCanceled(finalCanceledResponse), MetricName.Operation.RESPOND_ACTIVITY_TASK_CANCELED.getName(), TimeUnit.MILLISECONDS);
    }

    protected void respondActivityTaskCompletedWithRetry(String taskToken, String output, ActivityTypeExecutionOptions executionOptions) {
        SynchronousRetrier retrier = null;
        if (executionOptions != null) {
            retrier = this.createRetrier(executionOptions.getCompletionRetryOptions());
        }
        if (retrier != null) {
            retrier.retry(() -> this.respondActivityTaskCompleted(taskToken, output));
        } else {
            this.respondActivityTaskCompleted(taskToken, output);
        }
    }

    protected void respondActivityTaskCompleted(String taskToken, String output) {
        RespondActivityTaskCompletedRequest completedResponse = (RespondActivityTaskCompletedRequest)RespondActivityTaskCompletedRequest.builder().taskToken(taskToken).result(output).build();
        RespondActivityTaskCompletedRequest finalCompletedResponse = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(completedResponse, this.config);
        ThreadLocalMetrics.getMetrics().recordRunnable(() -> this.service.respondActivityTaskCompleted(finalCompletedResponse), MetricName.Operation.RESPOND_ACTIVITY_TASK_COMPLETED.getName(), TimeUnit.MILLISECONDS);
    }

    protected void respondActivityTaskFailedWithRetry(String taskToken, String reason, String details, ActivityTypeExecutionOptions executionOptions) {
        SynchronousRetrier retrier = null;
        if (executionOptions != null) {
            retrier = this.createRetrier(executionOptions.getFailureRetryOptions());
        }
        if (retrier != null) {
            retrier.retry(() -> this.respondActivityTaskFailed(taskToken, reason, details));
        } else {
            this.respondActivityTaskFailed(taskToken, reason, details);
        }
    }

    public SwfClient getService() {
        return this.service;
    }

    public void setService(SwfClient service) {
        this.service = service;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getTaskListToPoll() {
        return this.taskListToPoll;
    }

    public ActivityImplementationFactory getActivityImplementationFactory() {
        return this.activityImplementationFactory;
    }

    public void setActivityImplementationFactory(ActivityImplementationFactory activityImplementationFactory) {
        this.activityImplementationFactory = activityImplementationFactory;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public SimpleWorkflowClientConfig getConfig() {
        return this.config;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public void setMetricsRegistry(MetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
    }

    @Override
    public SuspendableSemaphore getPollingSemaphore() {
        return this.pollingSemaphore;
    }

    private static /* synthetic */ String lambda$execute$1(ActivityImplementation activityImplementation, ActivityExecutionContext context) throws Exception {
        return activityImplementation.execute(context);
    }
}

