/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.retry;

import com.amazonaws.services.simpleworkflow.flow.retry.Retrier;
import com.amazonaws.services.simpleworkflow.flow.worker.BackoffThrottler;
import com.amazonaws.services.simpleworkflow.flow.worker.BackoffThrottlerWithJitter;
import com.amazonaws.services.simpleworkflow.flow.worker.ExponentialRetryParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.retry.RetryUtils;

public class ThrottlingRetrier
extends Retrier {
    private static final Log logger = LogFactory.getLog(ThrottlingRetrier.class);

    public ThrottlingRetrier(ExponentialRetryParameters retryParameters) {
        super(retryParameters, logger);
    }

    @Override
    protected BackoffThrottler createBackoffThrottler() {
        return new BackoffThrottlerWithJitter(this.getRetryParameters().getInitialInterval(), this.getRetryParameters().getMaximumRetryInterval(), this.getRetryParameters().getBackoffCoefficient());
    }

    @Override
    protected boolean shouldRetry(RuntimeException e) {
        return e instanceof AwsServiceException && RetryUtils.isThrottlingException((SdkException)((AwsServiceException)e));
    }
}

