/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.retry;

import com.amazonaws.services.simpleworkflow.flow.worker.BackoffThrottler;
import com.amazonaws.services.simpleworkflow.flow.worker.ExponentialRetryParameters;
import org.apache.commons.logging.Log;

public abstract class Retrier {
    private final ExponentialRetryParameters retryParameters;
    private final Log logger;

    public Retrier(ExponentialRetryParameters retryParameters, Log logger) {
        if (retryParameters.getBackoffCoefficient() < 0.0) {
            throw new IllegalArgumentException("negative backoffCoefficient");
        }
        if (retryParameters.getInitialInterval() < 10L) {
            throw new IllegalArgumentException("initialInterval cannot be less then 10: " + retryParameters.getInitialInterval());
        }
        if (retryParameters.getExpirationInterval() < retryParameters.getInitialInterval()) {
            throw new IllegalArgumentException("expirationInterval < initialInterval");
        }
        if (retryParameters.getMaximumRetries() < retryParameters.getMinimumRetries()) {
            throw new IllegalArgumentException("maximumRetries < minimumRetries");
        }
        this.retryParameters = retryParameters;
        this.logger = logger;
    }

    protected abstract BackoffThrottler createBackoffThrottler();

    protected abstract boolean shouldRetry(RuntimeException var1);

    public void retry(Runnable r) {
        int attempt = 0;
        long startTime = System.currentTimeMillis();
        BackoffThrottler throttler = this.createBackoffThrottler();
        boolean success = false;
        do {
            try {
                ++attempt;
                throttler.throttle();
                r.run();
                success = true;
                throttler.success();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (RuntimeException e) {
                throttler.failure();
                if (!this.shouldRetry(e)) {
                    throw e;
                }
                long elapsed = System.currentTimeMillis() - startTime;
                if (attempt > this.retryParameters.getMaximumRetries() || elapsed >= this.retryParameters.getExpirationInterval() && attempt > this.retryParameters.getMinimumRetries()) {
                    throw e;
                }
                this.logger.warn((Object)"Retrying after failure", (Throwable)e);
            }
        } while (!success);
    }

    public ExponentialRetryParameters getRetryParameters() {
        return this.retryParameters;
    }
}

