/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.pojo;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.WorkflowException;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.TryCatch;
import com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.Metrics;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import com.amazonaws.services.simpleworkflow.flow.pojo.MethodConverterPair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class POJOWorkflowDefinition
extends WorkflowDefinition {
    private final MethodConverterPair workflowMethod;
    private final Map<String, MethodConverterPair> signals;
    private final MethodConverterPair getStateMethod;
    private final Object workflowImplementationInstance;
    private final DataConverter converter;
    private final DecisionContext context;

    public POJOWorkflowDefinition(Object workflowImplmentationInstance, MethodConverterPair workflowImplementationMethod, Map<String, MethodConverterPair> signals, MethodConverterPair getStateMethod, DataConverter converter, DecisionContext context) throws ClassNotFoundException, SecurityException, NoSuchMethodException, NoSuchFieldException {
        this.workflowImplementationInstance = workflowImplmentationInstance;
        this.workflowMethod = workflowImplementationMethod;
        this.getStateMethod = getStateMethod;
        this.signals = signals;
        this.converter = converter;
        this.context = context;
    }

    @Override
    public Promise<String> execute(final String input) throws WorkflowException {
        final DataConverter c = this.workflowMethod.getConverter() == null ? this.converter : this.workflowMethod.getConverter();
        final Settable<String> result = new Settable<String>();
        final AtomicReference methodResult = new AtomicReference();
        new TryCatchFinally(){

            @Override
            protected void doTry() throws Throwable {
                Object[] parameters = ThreadLocalMetrics.getMetrics().recordSupplier(() -> c.fromData(input, Object[].class), c.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_DESERIALIZE.getName(), TimeUnit.MILLISECONDS);
                Method method = POJOWorkflowDefinition.this.workflowMethod.getMethod();
                Object r = POJOWorkflowDefinition.this.invokeMethod(method, parameters);
                if (!method.getReturnType().equals(Void.TYPE)) {
                    methodResult.set((Promise)r);
                }
            }

            @Override
            protected void doCatch(Throwable e) throws Throwable {
                if (!(e instanceof CancellationException) || !POJOWorkflowDefinition.this.context.getWorkflowContext().isCancelRequested() && !(e.getCause() instanceof WorkflowException)) {
                    POJOWorkflowDefinition.this.throwWorkflowException(c, e);
                }
            }

            @Override
            protected void doFinally() throws Throwable {
                Promise r = (Promise)methodResult.get();
                if (r == null || r.isReady()) {
                    Object workflowResult = r == null ? null : r.get();
                    result.set(ThreadLocalMetrics.getMetrics().recordSupplier(() -> c.toData(workflowResult), c.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS));
                }
            }
        };
        return result;
    }

    @Override
    public void signalRecieved(String signalName, String details) throws WorkflowException {
        MethodConverterPair signalMethod = this.signals.get(signalName);
        if (signalMethod != null) {
            DataConverter c = signalMethod.getConverter();
            if (c == null) {
                c = this.converter;
            }
            final Method method = signalMethod.getMethod();
            final DataConverter delegatedConverter = c;
            final Object[] parameters = ThreadLocalMetrics.getMetrics().recordSupplier(() -> delegatedConverter.fromData(details, Object[].class), delegatedConverter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_DESERIALIZE.getName(), TimeUnit.MILLISECONDS);
            new TryCatch(new Promise[0]){

                @Override
                protected void doTry() throws Throwable {
                    POJOWorkflowDefinition.this.invokeMethod(method, parameters);
                }

                @Override
                protected void doCatch(Throwable e) throws Throwable {
                    POJOWorkflowDefinition.this.throwWorkflowException(delegatedConverter, e);
                    throw new IllegalStateException("Unreacheable");
                }
            };
        }
    }

    @Override
    public String getWorkflowState() throws WorkflowException {
        if (this.getStateMethod == null) {
            return null;
        }
        DataConverter c = this.getStateMethod.getConverter() == null ? this.converter : this.getStateMethod.getConverter();
        try {
            Method method = this.getStateMethod.getMethod();
            Object result = this.invokeMethod(method, null);
            return ThreadLocalMetrics.getMetrics().recordSupplier(() -> c.toData(result), c.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            this.throwWorkflowException(c, e);
            throw new IllegalStateException("Unreacheable");
        }
    }

    private Object invokeMethod(Method method, Object[] input) throws Throwable {
        Metrics metrics = ThreadLocalMetrics.getMetrics();
        Metrics childMetrics = metrics.newMetrics();
        ThreadLocalMetrics.setCurrent(childMetrics);
        try {
            Object[] parameters = FlowHelpers.getInputParameters(method.getParameterTypes(), input);
            Object object = method.invoke(this.workflowImplementationInstance, parameters);
            return object;
        }
        catch (InvocationTargetException invocationException) {
            if (invocationException.getTargetException() != null) {
                throw invocationException.getTargetException();
            }
            throw invocationException;
        }
        finally {
            childMetrics.close();
            ThreadLocalMetrics.setCurrent(metrics);
        }
    }

    private void throwWorkflowException(DataConverter c, Throwable exception) throws WorkflowException {
        String details;
        if (exception instanceof WorkflowException) {
            throw (WorkflowException)exception;
        }
        String reason = WorkflowExecutionUtils.truncateReason(exception.getMessage());
        try {
            details = ThreadLocalMetrics.getMetrics().recordSupplier(() -> c.toData(exception), c.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS);
        }
        catch (DataConverterException dataConverterException) {
            if (dataConverterException.getCause() == null) {
                dataConverterException.initCause(exception);
            }
            throw dataConverterException;
        }
        throw new WorkflowException(reason, details);
    }

    public Object getImplementationInstance() {
        return this.workflowImplementationInstance;
    }
}

