/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.model;

import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=WorkflowExecutionMetadataBuilder.class)
public class WorkflowExecutionMetadata {
    private String taskList;
    private WorkflowType workflowType;
    private List<String> tagList;

    public static WorkflowExecutionMetadata fromSdkType(WorkflowExecutionStartedEventAttributes attributes) {
        return attributes == null ? null : WorkflowExecutionMetadata.builder().taskList(attributes.taskList().name()).workflowType(WorkflowType.fromSdkType(attributes.workflowType())).tagList(attributes.tagList()).build();
    }

    WorkflowExecutionMetadata(String taskList, WorkflowType workflowType, List<String> tagList) {
        this.taskList = taskList;
        this.workflowType = workflowType;
        this.tagList = tagList;
    }

    public static WorkflowExecutionMetadataBuilder builder() {
        return new WorkflowExecutionMetadataBuilder();
    }

    public WorkflowExecutionMetadataBuilder toBuilder() {
        return new WorkflowExecutionMetadataBuilder().taskList(this.taskList).workflowType(this.workflowType).tagList(this.tagList);
    }

    public String getTaskList() {
        return this.taskList;
    }

    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public List<String> getTagList() {
        return this.tagList;
    }

    public void setTaskList(String taskList) {
        this.taskList = taskList;
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public void setTagList(List<String> tagList) {
        this.tagList = tagList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowExecutionMetadata)) {
            return false;
        }
        WorkflowExecutionMetadata other = (WorkflowExecutionMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$taskList = this.getTaskList();
        String other$taskList = other.getTaskList();
        if (this$taskList == null ? other$taskList != null : !this$taskList.equals(other$taskList)) {
            return false;
        }
        WorkflowType this$workflowType = this.getWorkflowType();
        WorkflowType other$workflowType = other.getWorkflowType();
        if (this$workflowType == null ? other$workflowType != null : !((Object)this$workflowType).equals(other$workflowType)) {
            return false;
        }
        List<String> this$tagList = this.getTagList();
        List<String> other$tagList = other.getTagList();
        return !(this$tagList == null ? other$tagList != null : !((Object)this$tagList).equals(other$tagList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkflowExecutionMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $taskList = this.getTaskList();
        result = result * 59 + ($taskList == null ? 43 : $taskList.hashCode());
        WorkflowType $workflowType = this.getWorkflowType();
        result = result * 59 + ($workflowType == null ? 43 : ((Object)$workflowType).hashCode());
        List<String> $tagList = this.getTagList();
        result = result * 59 + ($tagList == null ? 43 : ((Object)$tagList).hashCode());
        return result;
    }

    public String toString() {
        return "WorkflowExecutionMetadata(taskList=" + this.getTaskList() + ", workflowType=" + this.getWorkflowType() + ", tagList=" + this.getTagList() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class WorkflowExecutionMetadataBuilder {
        private String taskList;
        private WorkflowType workflowType;
        private List<String> tagList;

        WorkflowExecutionMetadataBuilder() {
        }

        public WorkflowExecutionMetadataBuilder taskList(String taskList) {
            this.taskList = taskList;
            return this;
        }

        public WorkflowExecutionMetadataBuilder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public WorkflowExecutionMetadataBuilder tagList(List<String> tagList) {
            this.tagList = tagList;
            return this;
        }

        public WorkflowExecutionMetadata build() {
            return new WorkflowExecutionMetadata(this.taskList, this.workflowType, this.tagList);
        }

        public String toString() {
            return "WorkflowExecutionMetadata.WorkflowExecutionMetadataBuilder(taskList=" + this.taskList + ", workflowType=" + this.workflowType + ", tagList=" + this.tagList + ")";
        }
    }
}

