/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=ActivityTypeBuilder.class)
public class ActivityType {
    private String name;
    private String version;

    public static ActivityType fromSdkType(software.amazon.awssdk.services.swf.model.ActivityType activityType) {
        return activityType == null ? null : ActivityType.builder().name(activityType.name()).version(activityType.version()).build();
    }

    public software.amazon.awssdk.services.swf.model.ActivityType toSdkType() {
        return (software.amazon.awssdk.services.swf.model.ActivityType)software.amazon.awssdk.services.swf.model.ActivityType.builder().name(this.name).version(this.version).build();
    }

    ActivityType(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public static ActivityTypeBuilder builder() {
        return new ActivityTypeBuilder();
    }

    public ActivityTypeBuilder toBuilder() {
        return new ActivityTypeBuilder().name(this.name).version(this.version);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivityType)) {
            return false;
        }
        ActivityType other = (ActivityType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivityType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public String toString() {
        return "ActivityType(name=" + this.getName() + ", version=" + this.getVersion() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ActivityTypeBuilder {
        private String name;
        private String version;

        ActivityTypeBuilder() {
        }

        public ActivityTypeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ActivityTypeBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ActivityType build() {
            return new ActivityType(this.name, this.version);
        }

        public String toString() {
            return "ActivityType.ActivityTypeBuilder(name=" + this.name + ", version=" + this.version + ")";
        }
    }
}

