/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.model;

import com.amazonaws.services.simpleworkflow.flow.model.ActivityType;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import software.amazon.awssdk.services.swf.model.PollForActivityTaskResponse;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=ActivityTaskBuilder.class)
public class ActivityTask {
    private String taskToken;
    private String activityId;
    private Long startedEventId;
    private WorkflowExecution workflowExecution;
    private ActivityType activityType;
    private String input;

    public static ActivityTask fromSdkType(PollForActivityTaskResponse sdkResponse) {
        if (sdkResponse == null) {
            return null;
        }
        return ActivityTask.builder().activityId(sdkResponse.activityId()).activityType(ActivityType.fromSdkType(sdkResponse.activityType())).input(sdkResponse.input()).workflowExecution(WorkflowExecution.fromSdkType(sdkResponse.workflowExecution())).startedEventId(sdkResponse.startedEventId()).taskToken(sdkResponse.taskToken()).build();
    }

    public PollForActivityTaskResponse toSdkType() {
        return (PollForActivityTaskResponse)PollForActivityTaskResponse.builder().activityId(this.activityId).activityType(this.activityType.toSdkType()).input(this.input).workflowExecution(this.workflowExecution.toSdkType()).activityType(this.activityType.toSdkType()).taskToken(this.taskToken).startedEventId(this.startedEventId).build();
    }

    ActivityTask(String taskToken, String activityId, Long startedEventId, WorkflowExecution workflowExecution, ActivityType activityType, String input) {
        this.taskToken = taskToken;
        this.activityId = activityId;
        this.startedEventId = startedEventId;
        this.workflowExecution = workflowExecution;
        this.activityType = activityType;
        this.input = input;
    }

    public static ActivityTaskBuilder builder() {
        return new ActivityTaskBuilder();
    }

    public ActivityTaskBuilder toBuilder() {
        return new ActivityTaskBuilder().taskToken(this.taskToken).activityId(this.activityId).startedEventId(this.startedEventId).workflowExecution(this.workflowExecution).activityType(this.activityType).input(this.input);
    }

    public String getTaskToken() {
        return this.taskToken;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public Long getStartedEventId() {
        return this.startedEventId;
    }

    public WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    public ActivityType getActivityType() {
        return this.activityType;
    }

    public String getInput() {
        return this.input;
    }

    public void setTaskToken(String taskToken) {
        this.taskToken = taskToken;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public void setStartedEventId(Long startedEventId) {
        this.startedEventId = startedEventId;
    }

    public void setWorkflowExecution(WorkflowExecution workflowExecution) {
        this.workflowExecution = workflowExecution;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivityTask)) {
            return false;
        }
        ActivityTask other = (ActivityTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$startedEventId = this.getStartedEventId();
        Long other$startedEventId = other.getStartedEventId();
        if (this$startedEventId == null ? other$startedEventId != null : !((Object)this$startedEventId).equals(other$startedEventId)) {
            return false;
        }
        String this$taskToken = this.getTaskToken();
        String other$taskToken = other.getTaskToken();
        if (this$taskToken == null ? other$taskToken != null : !this$taskToken.equals(other$taskToken)) {
            return false;
        }
        String this$activityId = this.getActivityId();
        String other$activityId = other.getActivityId();
        if (this$activityId == null ? other$activityId != null : !this$activityId.equals(other$activityId)) {
            return false;
        }
        WorkflowExecution this$workflowExecution = this.getWorkflowExecution();
        WorkflowExecution other$workflowExecution = other.getWorkflowExecution();
        if (this$workflowExecution == null ? other$workflowExecution != null : !((Object)this$workflowExecution).equals(other$workflowExecution)) {
            return false;
        }
        ActivityType this$activityType = this.getActivityType();
        ActivityType other$activityType = other.getActivityType();
        if (this$activityType == null ? other$activityType != null : !((Object)this$activityType).equals(other$activityType)) {
            return false;
        }
        String this$input = this.getInput();
        String other$input = other.getInput();
        return !(this$input == null ? other$input != null : !this$input.equals(other$input));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivityTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $startedEventId = this.getStartedEventId();
        result = result * 59 + ($startedEventId == null ? 43 : ((Object)$startedEventId).hashCode());
        String $taskToken = this.getTaskToken();
        result = result * 59 + ($taskToken == null ? 43 : $taskToken.hashCode());
        String $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : $activityId.hashCode());
        WorkflowExecution $workflowExecution = this.getWorkflowExecution();
        result = result * 59 + ($workflowExecution == null ? 43 : ((Object)$workflowExecution).hashCode());
        ActivityType $activityType = this.getActivityType();
        result = result * 59 + ($activityType == null ? 43 : ((Object)$activityType).hashCode());
        String $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        return result;
    }

    public String toString() {
        return "ActivityTask(taskToken=" + this.getTaskToken() + ", activityId=" + this.getActivityId() + ", startedEventId=" + this.getStartedEventId() + ", workflowExecution=" + this.getWorkflowExecution() + ", activityType=" + this.getActivityType() + ", input=" + this.getInput() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ActivityTaskBuilder {
        private String taskToken;
        private String activityId;
        private Long startedEventId;
        private WorkflowExecution workflowExecution;
        private ActivityType activityType;
        private String input;

        ActivityTaskBuilder() {
        }

        public ActivityTaskBuilder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public ActivityTaskBuilder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public ActivityTaskBuilder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public ActivityTaskBuilder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public ActivityTaskBuilder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public ActivityTaskBuilder input(String input) {
            this.input = input;
            return this;
        }

        public ActivityTask build() {
            return new ActivityTask(this.taskToken, this.activityId, this.startedEventId, this.workflowExecution, this.activityType, this.input);
        }

        public String toString() {
            return "ActivityTask.ActivityTaskBuilder(taskToken=" + this.taskToken + ", activityId=" + this.activityId + ", startedEventId=" + this.startedEventId + ", workflowExecution=" + this.workflowExecution + ", activityType=" + this.activityType + ", input=" + this.input + ")";
        }
    }
}

