/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.config;

import com.amazonaws.services.simpleworkflow.flow.config.DeciderAffinityConfig;
import java.time.Duration;

public class SimpleWorkflowClientConfig {
    private final Duration pollingRequestTimeout;
    private final Duration dataPlaneRequestTimeout;
    private final Duration controlPlaneRequestTimeout;
    private final int maxRetryForCancelingExternalWorkflow;
    private final Duration initialSleepForDecisionThrottle;
    private final Duration maxSleepForDecisionThrottle;
    private final double backoffCoefficientForDecisionThrottle;
    private final DeciderAffinityConfig deciderAffinityConfig;
    private static final int DEFAULT_POLLING_REQUEST_TIMEOUT_IN_SEC = 70;
    private static final int DEFAULT_DATA_PLANE_REQUEST_TIMEOUT_IN_SEC = 6;
    private static final int DEFAULT_CONTROL_PLANE_REQUEST_TIMEOUT_IN_SEC = 10;
    private static final int DEFAULT_MAX_RETRY_FOR_CANCELING_EXTERNAL_WORKFLOW = 0;
    private static final int DEFAULT_INITIAL_SLEEP_FOR_DECISION_THROTTLE_IN_SEC = 1;
    private static final int DEFAULT_MAX_SLEEP_FOR_DECISION_THROTTLE_IN_SEC = 0;
    private static final double DEFAULT_BACKOFF_COEFFICIENT_FOR_DECISION_THROTTLE = 2.0;
    private static final DeciderAffinityConfig DEFAULT_DECIDER_AFFINITY_CONFIG = null;

    public static SimpleWorkflowClientConfig ofDefaults() {
        return new SimpleWorkflowClientConfigBuilder().build();
    }

    public SimpleWorkflowClientConfig(Duration pollingRequestTimeout, Duration dataPlaneRequestTimeout, Duration controlPlaneRequestTimeout) {
        this(pollingRequestTimeout, dataPlaneRequestTimeout, controlPlaneRequestTimeout, 0, Duration.ofSeconds(1L), Duration.ofSeconds(0L), 2.0, DEFAULT_DECIDER_AFFINITY_CONFIG);
    }

    public int getDataPlaneRequestTimeoutInMillis() {
        return (int)this.dataPlaneRequestTimeout.toMillis();
    }

    public int getPollingRequestTimeoutInMillis() {
        return (int)this.pollingRequestTimeout.toMillis();
    }

    public int getControlPlaneRequestTimeoutInMillis() {
        return (int)this.controlPlaneRequestTimeout.toMillis();
    }

    public int getInitialSleepForDecisionThrottleInMillis() {
        return (int)this.initialSleepForDecisionThrottle.toMillis();
    }

    public int getMaxSleepForDecisionThrottleInMillis() {
        return (int)this.maxSleepForDecisionThrottle.toMillis();
    }

    public static SimpleWorkflowClientConfigBuilder builder() {
        return new SimpleWorkflowClientConfigBuilder();
    }

    public SimpleWorkflowClientConfig(Duration pollingRequestTimeout, Duration dataPlaneRequestTimeout, Duration controlPlaneRequestTimeout, int maxRetryForCancelingExternalWorkflow, Duration initialSleepForDecisionThrottle, Duration maxSleepForDecisionThrottle, double backoffCoefficientForDecisionThrottle, DeciderAffinityConfig deciderAffinityConfig) {
        this.pollingRequestTimeout = pollingRequestTimeout;
        this.dataPlaneRequestTimeout = dataPlaneRequestTimeout;
        this.controlPlaneRequestTimeout = controlPlaneRequestTimeout;
        this.maxRetryForCancelingExternalWorkflow = maxRetryForCancelingExternalWorkflow;
        this.initialSleepForDecisionThrottle = initialSleepForDecisionThrottle;
        this.maxSleepForDecisionThrottle = maxSleepForDecisionThrottle;
        this.backoffCoefficientForDecisionThrottle = backoffCoefficientForDecisionThrottle;
        this.deciderAffinityConfig = deciderAffinityConfig;
    }

    public int getMaxRetryForCancelingExternalWorkflow() {
        return this.maxRetryForCancelingExternalWorkflow;
    }

    public double getBackoffCoefficientForDecisionThrottle() {
        return this.backoffCoefficientForDecisionThrottle;
    }

    public DeciderAffinityConfig getDeciderAffinityConfig() {
        return this.deciderAffinityConfig;
    }

    static /* synthetic */ DeciderAffinityConfig access$000() {
        return DEFAULT_DECIDER_AFFINITY_CONFIG;
    }

    public static class SimpleWorkflowClientConfigBuilder {
        private Duration pollingRequestTimeout = Duration.ofSeconds(70L);
        private Duration dataPlaneRequestTimeout = Duration.ofSeconds(6L);
        private Duration controlPlaneRequestTimeout = Duration.ofSeconds(10L);
        private int maxRetryForCancelingExternalWorkflow = 0;
        private Duration initialSleepForDecisionThrottle = Duration.ofSeconds(1L);
        private Duration maxSleepForDecisionThrottle = Duration.ofSeconds(0L);
        private double backoffCoefficientForDecisionThrottle = 2.0;
        private DeciderAffinityConfig deciderAffinityConfig = SimpleWorkflowClientConfig.access$000();

        public SimpleWorkflowClientConfigBuilder pollingRequestTimeout(Duration pollingRequestTimeout) {
            this.pollingRequestTimeout = pollingRequestTimeout;
            return this;
        }

        public SimpleWorkflowClientConfigBuilder dataPlaneRequestTimeout(Duration dataPlaneRequestTimeout) {
            this.dataPlaneRequestTimeout = dataPlaneRequestTimeout;
            return this;
        }

        public SimpleWorkflowClientConfigBuilder controlPlaneRequestTimeout(Duration controlPlaneRequestTimeout) {
            this.controlPlaneRequestTimeout = controlPlaneRequestTimeout;
            return this;
        }

        public SimpleWorkflowClientConfigBuilder maxRetryForCancelingExternalWorkflow(int maxRetryForCancelingExternalWorkflow) {
            this.maxRetryForCancelingExternalWorkflow = maxRetryForCancelingExternalWorkflow;
            return this;
        }

        public SimpleWorkflowClientConfigBuilder initialSleepForDecisionThrottle(Duration initialSleepForDecisionThrottle) {
            this.initialSleepForDecisionThrottle = initialSleepForDecisionThrottle;
            return this;
        }

        public SimpleWorkflowClientConfigBuilder maxSleepForDecisionThrottle(Duration maxSleepForDecisionThrottle) {
            this.maxSleepForDecisionThrottle = maxSleepForDecisionThrottle;
            return this;
        }

        public SimpleWorkflowClientConfigBuilder backoffCoefficientForDecisionThrottle(double backoffCoefficientForDecisionThrottle) {
            this.backoffCoefficientForDecisionThrottle = backoffCoefficientForDecisionThrottle;
            return this;
        }

        public SimpleWorkflowClientConfigBuilder deciderAffinityConfig(DeciderAffinityConfig deciderAffinityConfig) {
            this.deciderAffinityConfig = deciderAffinityConfig;
            return this;
        }

        public SimpleWorkflowClientConfig build() {
            return new SimpleWorkflowClientConfig(this.pollingRequestTimeout, this.dataPlaneRequestTimeout, this.controlPlaneRequestTimeout, this.maxRetryForCancelingExternalWorkflow, this.initialSleepForDecisionThrottle, this.maxSleepForDecisionThrottle, this.backoffCoefficientForDecisionThrottle, this.deciderAffinityConfig);
        }

        public String toString() {
            return "SimpleWorkflowClientConfig.SimpleWorkflowClientConfigBuilder(pollingRequestTimeout=" + this.pollingRequestTimeout + ", dataPlaneRequestTimeout=" + this.dataPlaneRequestTimeout + ", controlPlaneRequestTimeout=" + this.controlPlaneRequestTimeout + ", maxRetryForCancelingExternalWorkflow=" + this.maxRetryForCancelingExternalWorkflow + ", initialSleepForDecisionThrottle=" + this.initialSleepForDecisionThrottle + ", maxSleepForDecisionThrottle=" + this.maxSleepForDecisionThrottle + ", backoffCoefficientForDecisionThrottle=" + this.backoffCoefficientForDecisionThrottle + ", deciderAffinityConfig=" + this.deciderAffinityConfig + ")";
        }
    }
}

