/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.common;

import com.amazonaws.services.simpleworkflow.flow.common.FlowValueConstraint;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.CloseStatus;
import software.amazon.awssdk.services.swf.model.Decision;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.EventType;
import software.amazon.awssdk.services.swf.model.ExecutionStatus;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionCompletedEventAttributes;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo;
import software.amazon.awssdk.utils.builder.CopyableBuilder;

public class WorkflowExecutionUtils {
    private static final String SDK_V2_SUFFIX_DECISION_ATTRIBUTE = "DecisionAttributes";

    public static WorkflowExecutionCompletedEventAttributes waitForWorkflowExecutionResult(SwfClient service, String domain, WorkflowExecution workflowExecution) throws InterruptedException {
        return WorkflowExecutionUtils.waitForWorkflowExecutionResult(service, domain, workflowExecution, null);
    }

    public static WorkflowExecutionCompletedEventAttributes waitForWorkflowExecutionResult(SwfClient service, String domain, WorkflowExecution workflowExecution, SimpleWorkflowClientConfig config) throws InterruptedException {
        try {
            return WorkflowExecutionUtils.waitForWorkflowExecutionResult(service, domain, workflowExecution, 0L, config);
        }
        catch (TimeoutException e) {
            throw new Error("should never happen", e);
        }
    }

    public static WorkflowExecutionCompletedEventAttributes waitForWorkflowExecutionResult(SwfClient service, String domain, WorkflowExecution workflowExecution, long timeoutSeconds) throws InterruptedException, TimeoutException {
        return WorkflowExecutionUtils.waitForWorkflowExecutionResult(service, domain, workflowExecution, timeoutSeconds, null);
    }

    public static WorkflowExecutionCompletedEventAttributes waitForWorkflowExecutionResult(SwfClient service, String domain, WorkflowExecution workflowExecution, long timeoutSeconds, SimpleWorkflowClientConfig config) throws InterruptedException, TimeoutException {
        if (!WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, workflowExecution, timeoutSeconds, config).equals(CloseStatus.COMPLETED.toString())) {
            String historyDump = WorkflowExecutionUtils.prettyPrintHistory(service, domain, workflowExecution, config);
            throw new RuntimeException("Workflow instance is not in completed state:\n" + historyDump);
        }
        return WorkflowExecutionUtils.getWorkflowExecutionResult(service, domain, workflowExecution, config);
    }

    public static WorkflowExecutionCompletedEventAttributes getWorkflowExecutionResult(SwfClient service, String domain, WorkflowExecution workflowExecution) {
        return WorkflowExecutionUtils.getWorkflowExecutionResult(service, domain, workflowExecution, null);
    }

    public static WorkflowExecutionCompletedEventAttributes getWorkflowExecutionResult(SwfClient service, String domain, WorkflowExecution workflowExecution, SimpleWorkflowClientConfig config) {
        HistoryEvent closeEvent = WorkflowExecutionUtils.getInstanceCloseEvent(service, domain, workflowExecution, config);
        if (closeEvent == null) {
            throw new IllegalStateException("Workflow is still running");
        }
        if (closeEvent.eventTypeAsString().equals(EventType.WORKFLOW_EXECUTION_COMPLETED.toString())) {
            return closeEvent.workflowExecutionCompletedEventAttributes();
        }
        throw new RuntimeException("Workflow end state is not completed: " + WorkflowExecutionUtils.prettyPrintHistoryEvent(closeEvent));
    }

    public static HistoryEvent getInstanceCloseEvent(SwfClient service, String domain, WorkflowExecution workflowExecution) {
        return WorkflowExecutionUtils.getInstanceCloseEvent(service, domain, workflowExecution, null);
    }

    public static HistoryEvent getInstanceCloseEvent(SwfClient service, String domain, WorkflowExecution workflowExecution, SimpleWorkflowClientConfig config) {
        WorkflowExecutionInfo executionInfo = WorkflowExecutionUtils.describeWorkflowInstance(service, domain, workflowExecution, config);
        if (executionInfo == null || executionInfo.executionStatusAsString().equals(ExecutionStatus.OPEN.toString())) {
            return null;
        }
        List<HistoryEvent> events = WorkflowExecutionUtils.getHistory(service, domain, workflowExecution, true, config);
        if (events.size() == 0) {
            throw new IllegalStateException("empty history");
        }
        HistoryEvent last = events.get(0);
        if (!WorkflowExecutionUtils.isWorkflowExecutionCompletedEvent(last)) {
            throw new IllegalStateException("unexpected last history event for workflow in " + executionInfo.executionStatusAsString() + " state: " + last.eventType());
        }
        return last;
    }

    public static boolean isWorkflowExecutionCompletedEvent(HistoryEvent event) {
        return event != null && (event.eventTypeAsString().equals(EventType.WORKFLOW_EXECUTION_COMPLETED.toString()) || event.eventTypeAsString().equals(EventType.WORKFLOW_EXECUTION_CANCELED.toString()) || event.eventTypeAsString().equals(EventType.WORKFLOW_EXECUTION_FAILED.toString()) || event.eventTypeAsString().equals(EventType.WORKFLOW_EXECUTION_TIMED_OUT.toString()) || event.eventTypeAsString().equals(EventType.WORKFLOW_EXECUTION_CONTINUED_AS_NEW.toString()) || event.eventTypeAsString().equals(EventType.WORKFLOW_EXECUTION_TERMINATED.toString()));
    }

    public static boolean isActivityTaskClosedEvent(HistoryEvent event) {
        return event != null && (event.eventTypeAsString().equals(EventType.ACTIVITY_TASK_COMPLETED.toString()) || event.eventTypeAsString().equals(EventType.ACTIVITY_TASK_CANCELED.toString()) || event.eventTypeAsString().equals(EventType.ACTIVITY_TASK_FAILED.toString()) || event.eventTypeAsString().equals(EventType.ACTIVITY_TASK_TIMED_OUT.toString()));
    }

    public static boolean isExternalWorkflowClosedEvent(HistoryEvent event) {
        return event != null && (event.eventTypeAsString().equals(EventType.CHILD_WORKFLOW_EXECUTION_COMPLETED.toString()) || event.eventTypeAsString().equals(EventType.CHILD_WORKFLOW_EXECUTION_CANCELED.toString()) || event.eventTypeAsString().equals(EventType.CHILD_WORKFLOW_EXECUTION_FAILED.toString()) || event.eventTypeAsString().equals(EventType.CHILD_WORKFLOW_EXECUTION_TERMINATED.toString()) || event.eventTypeAsString().equals(EventType.CHILD_WORKFLOW_EXECUTION_TIMED_OUT.toString()));
    }

    public static WorkflowExecution getWorkflowIdFromExternalWorkflowCompletedEvent(HistoryEvent event) {
        if (event != null) {
            software.amazon.awssdk.services.swf.model.WorkflowExecution sdkv2Execution = null;
            if (event.eventTypeAsString().equals(EventType.CHILD_WORKFLOW_EXECUTION_COMPLETED.toString())) {
                sdkv2Execution = event.childWorkflowExecutionCompletedEventAttributes().workflowExecution();
            } else if (event.eventTypeAsString().equals(EventType.CHILD_WORKFLOW_EXECUTION_CANCELED.toString())) {
                sdkv2Execution = event.childWorkflowExecutionCanceledEventAttributes().workflowExecution();
            } else if (event.eventTypeAsString().equals(EventType.CHILD_WORKFLOW_EXECUTION_FAILED.toString())) {
                sdkv2Execution = event.childWorkflowExecutionFailedEventAttributes().workflowExecution();
            } else if (event.eventTypeAsString().equals(EventType.CHILD_WORKFLOW_EXECUTION_TERMINATED.toString())) {
                sdkv2Execution = event.childWorkflowExecutionTerminatedEventAttributes().workflowExecution();
            } else if (event.eventTypeAsString().equals(EventType.CHILD_WORKFLOW_EXECUTION_TIMED_OUT.toString())) {
                sdkv2Execution = event.childWorkflowExecutionTimedOutEventAttributes().workflowExecution();
            }
            return WorkflowExecution.fromSdkType(sdkv2Execution);
        }
        return null;
    }

    public static String getId(HistoryEvent historyEvent) {
        String id = null;
        if (historyEvent != null) {
            if (historyEvent.eventTypeAsString().equals(EventType.START_CHILD_WORKFLOW_EXECUTION_FAILED.toString())) {
                id = historyEvent.startChildWorkflowExecutionFailedEventAttributes().workflowId();
            } else if (historyEvent.eventTypeAsString().equals(EventType.SCHEDULE_ACTIVITY_TASK_FAILED.toString())) {
                id = historyEvent.scheduleActivityTaskFailedEventAttributes().activityId();
            } else if (historyEvent.eventTypeAsString().equals(EventType.START_TIMER_FAILED.toString())) {
                id = historyEvent.startTimerFailedEventAttributes().timerId();
            }
        }
        return id;
    }

    public static String getFailureCause(HistoryEvent historyEvent) {
        String failureCause = null;
        if (historyEvent != null) {
            if (historyEvent.eventTypeAsString().equals(EventType.START_CHILD_WORKFLOW_EXECUTION_FAILED.toString())) {
                failureCause = historyEvent.startChildWorkflowExecutionFailedEventAttributes().causeAsString();
            } else if (historyEvent.eventTypeAsString().equals(EventType.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED.toString())) {
                failureCause = historyEvent.signalExternalWorkflowExecutionFailedEventAttributes().causeAsString();
            } else if (historyEvent.eventTypeAsString().equals(EventType.SCHEDULE_ACTIVITY_TASK_FAILED.toString())) {
                failureCause = historyEvent.scheduleActivityTaskFailedEventAttributes().causeAsString();
            } else if (historyEvent.eventTypeAsString().equals(EventType.START_TIMER_FAILED.toString())) {
                failureCause = historyEvent.startTimerFailedEventAttributes().causeAsString();
            } else if (historyEvent.eventTypeAsString().equals(EventType.CONTINUE_AS_NEW_WORKFLOW_EXECUTION_FAILED.toString())) {
                failureCause = historyEvent.continueAsNewWorkflowExecutionFailedEventAttributes().causeAsString();
            } else if (historyEvent.eventTypeAsString().equals(EventType.RECORD_MARKER_FAILED.toString())) {
                failureCause = historyEvent.recordMarkerFailedEventAttributes().causeAsString();
            }
        }
        return failureCause;
    }

    public static String waitForWorkflowInstanceCompletion(SwfClient service, String domain, WorkflowExecution workflowExecution) throws InterruptedException {
        return WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, workflowExecution, null);
    }

    public static String waitForWorkflowInstanceCompletion(SwfClient service, String domain, WorkflowExecution workflowExecution, SimpleWorkflowClientConfig config) throws InterruptedException {
        try {
            return WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, workflowExecution, 0L, config);
        }
        catch (TimeoutException e) {
            throw new Error("should never happen", e);
        }
    }

    public static String waitForWorkflowInstanceCompletion(SwfClient service, String domain, WorkflowExecution workflowExecution, long timeoutSeconds) throws InterruptedException, TimeoutException {
        return WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, workflowExecution, timeoutSeconds, null);
    }

    public static String waitForWorkflowInstanceCompletion(SwfClient service, String domain, WorkflowExecution workflowExecution, long timeoutSeconds, SimpleWorkflowClientConfig config) throws InterruptedException, TimeoutException {
        long start = System.currentTimeMillis();
        WorkflowExecutionInfo executionInfo = null;
        do {
            if (timeoutSeconds > 0L && System.currentTimeMillis() - start >= timeoutSeconds * 1000L) {
                String historyDump = WorkflowExecutionUtils.prettyPrintHistory(service, domain, workflowExecution, config);
                throw new TimeoutException("Workflow instance is not complete after " + timeoutSeconds + " seconds: \n" + historyDump);
            }
            if (executionInfo == null) continue;
            Thread.sleep(1000L);
        } while ((executionInfo = WorkflowExecutionUtils.describeWorkflowInstance(service, domain, workflowExecution, config)).executionStatusAsString().equals(ExecutionStatus.OPEN.toString()));
        return executionInfo.closeStatusAsString();
    }

    public static String waitForWorkflowInstanceCompletionAcrossGenerations(SwfClient service, String domain, WorkflowExecution workflowExecution, long timeoutSeconds) throws InterruptedException, TimeoutException {
        return WorkflowExecutionUtils.waitForWorkflowInstanceCompletionAcrossGenerations(service, domain, workflowExecution, timeoutSeconds, null);
    }

    public static String waitForWorkflowInstanceCompletionAcrossGenerations(SwfClient service, String domain, WorkflowExecution workflowExecution, long timeoutSeconds, SimpleWorkflowClientConfig config) throws InterruptedException, TimeoutException {
        WorkflowExecution lastExecutionToRun = workflowExecution;
        long millisecondsAtFirstWait = System.currentTimeMillis();
        String lastExecutionToRunCloseStatus = WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, lastExecutionToRun, timeoutSeconds, config);
        while (lastExecutionToRunCloseStatus.equals(CloseStatus.CONTINUED_AS_NEW.toString())) {
            HistoryEvent closeEvent = WorkflowExecutionUtils.getInstanceCloseEvent(service, domain, lastExecutionToRun, config);
            WorkflowExecutionContinuedAsNewEventAttributes continuedAsNewAttributes = closeEvent.workflowExecutionContinuedAsNewEventAttributes();
            WorkflowExecution newGenerationExecution = WorkflowExecution.builder().workflowId(lastExecutionToRun.getWorkflowId()).runId(continuedAsNewAttributes.newExecutionRunId()).build();
            long currentTime = System.currentTimeMillis();
            long millisecondsSinceFirstWait = currentTime - millisecondsAtFirstWait;
            long timeoutInSecondsForNextWait = timeoutSeconds - millisecondsSinceFirstWait / 1000L;
            lastExecutionToRunCloseStatus = WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, newGenerationExecution, timeoutInSecondsForNextWait, config);
            lastExecutionToRun = newGenerationExecution;
        }
        return lastExecutionToRunCloseStatus;
    }

    public static String waitForWorkflowInstanceCompletionAcrossGenerations(SwfClient service, String domain, WorkflowExecution workflowExecution) throws InterruptedException {
        try {
            return WorkflowExecutionUtils.waitForWorkflowInstanceCompletionAcrossGenerations(service, domain, workflowExecution, 0L, null);
        }
        catch (TimeoutException e) {
            throw new Error("should never happen", e);
        }
    }

    public static WorkflowExecutionInfo describeWorkflowInstance(SwfClient service, String domain, WorkflowExecution workflowExecution) {
        return WorkflowExecutionUtils.describeWorkflowInstance(service, domain, workflowExecution, null);
    }

    public static WorkflowExecutionInfo describeWorkflowInstance(SwfClient service, String domain, WorkflowExecution workflowExecution, SimpleWorkflowClientConfig config) {
        DescribeWorkflowExecutionRequest describeRequest = (DescribeWorkflowExecutionRequest)DescribeWorkflowExecutionRequest.builder().domain(domain).execution(workflowExecution.toSdkType()).build();
        describeRequest = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(describeRequest, config);
        DescribeWorkflowExecutionResponse executionDetail = service.describeWorkflowExecution(describeRequest);
        return executionDetail.executionInfo();
    }

    public static String prettyPrintHistory(SwfClient service, String domain, WorkflowExecution workflowExecution) {
        return WorkflowExecutionUtils.prettyPrintHistory(service, domain, workflowExecution, null);
    }

    public static String prettyPrintHistory(SwfClient service, String domain, WorkflowExecution workflowExecution, SimpleWorkflowClientConfig config) {
        return WorkflowExecutionUtils.prettyPrintHistory(service, domain, workflowExecution, true, config);
    }

    public static String prettyPrintHistory(SwfClient service, String domain, WorkflowExecution workflowExecution, boolean showWorkflowTasks) {
        return WorkflowExecutionUtils.prettyPrintHistory(service, domain, workflowExecution, showWorkflowTasks, null);
    }

    public static String prettyPrintHistory(SwfClient service, String domain, WorkflowExecution workflowExecution, boolean showWorkflowTasks, SimpleWorkflowClientConfig config) {
        List<HistoryEvent> events = WorkflowExecutionUtils.getHistory(service, domain, workflowExecution, config);
        return WorkflowExecutionUtils.prettyPrintHistory(events, showWorkflowTasks);
    }

    public static List<HistoryEvent> getHistory(SwfClient service, String domain, WorkflowExecution workflowExecution) {
        return WorkflowExecutionUtils.getHistory(service, domain, workflowExecution, false, null);
    }

    public static List<HistoryEvent> getHistory(SwfClient service, String domain, WorkflowExecution workflowExecution, SimpleWorkflowClientConfig config) {
        return WorkflowExecutionUtils.getHistory(service, domain, workflowExecution, false, config);
    }

    public static List<HistoryEvent> getHistory(SwfClient service, String domain, WorkflowExecution workflowExecution, boolean reverseOrder) {
        return WorkflowExecutionUtils.getHistory(service, domain, workflowExecution, reverseOrder, null);
    }

    public static List<HistoryEvent> getHistory(SwfClient service, String domain, WorkflowExecution workflowExecution, boolean reverseOrder, SimpleWorkflowClientConfig config) {
        GetWorkflowExecutionHistoryResponse history;
        ArrayList<HistoryEvent> events = new ArrayList<HistoryEvent>();
        String nextPageToken = null;
        do {
            history = WorkflowExecutionUtils.getHistoryPage(nextPageToken, service, domain, workflowExecution, reverseOrder, config);
            events.addAll(history.events());
        } while ((nextPageToken = history.nextPageToken()) != null);
        return events;
    }

    public static GetWorkflowExecutionHistoryResponse getHistoryPage(String nextPageToken, SwfClient service, String domain, WorkflowExecution workflowExecution) {
        return WorkflowExecutionUtils.getHistoryPage(nextPageToken, service, domain, workflowExecution, false, null);
    }

    public static GetWorkflowExecutionHistoryResponse getHistoryPage(String nextPageToken, SwfClient service, String domain, WorkflowExecution workflowExecution, SimpleWorkflowClientConfig config) {
        return WorkflowExecutionUtils.getHistoryPage(nextPageToken, service, domain, workflowExecution, false, config);
    }

    public static GetWorkflowExecutionHistoryResponse getHistoryPage(String nextPageToken, SwfClient service, String domain, WorkflowExecution workflowExecution, boolean reverseOrder) {
        return WorkflowExecutionUtils.getHistoryPage(nextPageToken, service, domain, workflowExecution, reverseOrder, null);
    }

    public static GetWorkflowExecutionHistoryResponse getHistoryPage(String nextPageToken, SwfClient service, String domain, WorkflowExecution workflowExecution, boolean reverseOrder, SimpleWorkflowClientConfig config) {
        GetWorkflowExecutionHistoryRequest getHistoryRequest = (GetWorkflowExecutionHistoryRequest)GetWorkflowExecutionHistoryRequest.builder().domain(domain).execution(workflowExecution.toSdkType()).reverseOrder(Boolean.valueOf(reverseOrder)).nextPageToken(nextPageToken).build();
        GetWorkflowExecutionHistoryRequest finalGetHistoryRequest = getHistoryRequest = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(getHistoryRequest, config);
        GetWorkflowExecutionHistoryResponse history = ThreadLocalMetrics.getMetrics().recordSupplier(() -> service.getWorkflowExecutionHistory(finalGetHistoryRequest), MetricName.Operation.GET_WORKFLOW_EXECUTION_HISTORY.getName(), TimeUnit.MILLISECONDS);
        if (history == null) {
            throw new IllegalArgumentException("unknown workflow execution: " + workflowExecution);
        }
        return history;
    }

    public static String prettyPrintHistory(GetWorkflowExecutionHistoryResponse history, boolean showWorkflowTasks) {
        return WorkflowExecutionUtils.prettyPrintHistory(history.events(), showWorkflowTasks);
    }

    public static String prettyPrintHistory(Iterable<HistoryEvent> events, boolean showWorkflowTasks) {
        StringBuffer result = new StringBuffer();
        result.append("{");
        boolean first = true;
        for (HistoryEvent event : events) {
            if (!showWorkflowTasks && event.eventTypeAsString().startsWith("WorkflowTask")) continue;
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append("\n    ");
            result.append(WorkflowExecutionUtils.prettyPrintHistoryEvent(event));
        }
        result.append("\n}");
        return result.toString();
    }

    public static String prettyPrintDecisions(Iterable<Decision> decisions) {
        StringBuffer result = new StringBuffer();
        result.append("{");
        boolean first = true;
        for (Decision decision : decisions) {
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append("\n    ");
            result.append(WorkflowExecutionUtils.prettyPrintDecision(decision));
        }
        result.append("\n}");
        return result.toString();
    }

    public static String prettyPrintHistoryEvent(HistoryEvent event) {
        String eventType = event.eventTypeAsString();
        StringBuffer result = new StringBuffer();
        result.append(eventType);
        result.append(WorkflowExecutionUtils.prettyPrintObject(event, "getType", true, "    ", false));
        return result.toString();
    }

    public static String prettyPrintDecision(Decision decision) {
        return WorkflowExecutionUtils.prettyPrintObject(decision, "getDecisionType", true, "", true);
    }

    private static String prettyPrintObject(Object object, String methodToSkip, boolean skipNullsAndEmptyCollections, String indentation, boolean skipLevel) {
        StringBuffer result = new StringBuffer();
        if (object == null) {
            return "null";
        }
        Class<?> clz = object.getClass();
        if (Number.class.isAssignableFrom(clz)) {
            return String.valueOf(object);
        }
        if (Boolean.class.isAssignableFrom(clz)) {
            return String.valueOf(object);
        }
        if (clz.equals(String.class)) {
            return (String)object;
        }
        if (clz.equals(Date.class) || clz.equals(Instant.class)) {
            return String.valueOf(object);
        }
        if (Map.class.isAssignableFrom(clz)) {
            return String.valueOf(object);
        }
        if (Collection.class.isAssignableFrom(clz)) {
            return String.valueOf(object);
        }
        if (!skipLevel) {
            result.append(" {");
        }
        if (object instanceof Decision.Builder) {
            result = new StringBuffer();
        }
        Method[] eventMethods = object.getClass().getMethods();
        Arrays.sort(eventMethods, Comparator.comparing(Method::getName));
        boolean first = true;
        for (Method method : eventMethods) {
            Object value;
            boolean isNotBuilder;
            String name = method.getName();
            boolean bl = isNotBuilder = !name.contains("toBuilder") || !method.getReturnType().equals(CopyableBuilder.class);
            if ((!name.startsWith("get") || name.startsWith("getValueForField")) && isNotBuilder || name.equals(methodToSkip) || name.equals("getClass") || Modifier.isStatic(method.getModifiers())) continue;
            try {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                if ((value = method.invoke(object, (Object[])null)) != null && value.getClass().equals(String.class) && name.equals("getDetails")) {
                    value = WorkflowExecutionUtils.printDetails((String)value);
                }
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (skipNullsAndEmptyCollections && (value == null || value instanceof Map && ((Map)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty())) continue;
            if (name.contains("toBuilder")) {
                skipLevel = true;
                result = new StringBuffer();
            }
            if (!skipLevel) {
                if (first) {
                    first = false;
                } else {
                    result.append(";");
                }
                name = name.substring(3);
                if (!name.endsWith(SDK_V2_SUFFIX_DECISION_ATTRIBUTE)) {
                    result.append("\n");
                    result.append(indentation);
                    result.append("    ");
                    result.append(name);
                    result.append(" = ");
                } else {
                    result.trimToSize();
                    result.append(indentation);
                    result.append(name, 0, name.length() - SDK_V2_SUFFIX_DECISION_ATTRIBUTE.length()).append(" ");
                    skipLevel = true;
                }
                result.append(WorkflowExecutionUtils.prettyPrintObject(value, methodToSkip, skipNullsAndEmptyCollections, indentation + "    ", false));
                continue;
            }
            result.append(WorkflowExecutionUtils.prettyPrintObject(value, methodToSkip, skipNullsAndEmptyCollections, indentation, false));
        }
        if (!skipLevel) {
            result.append("\n");
            result.append(indentation);
            result.append("}");
        }
        return result.toString();
    }

    public static String printDetails(String details) {
        Throwable failure = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.activateDefaultTyping((PolymorphicTypeValidator)BasicPolymorphicTypeValidator.builder().allowIfBaseType(Object.class).build(), ObjectMapper.DefaultTyping.NON_FINAL);
            failure = (Throwable)mapper.readValue(details, Throwable.class);
        }
        catch (Exception mapper) {
            // empty catch block
        }
        if (failure != null) {
            StringBuilder builder = new StringBuilder();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            failure.printStackTrace(pw);
            builder.append(sw.toString());
            details = builder.toString();
        }
        return details;
    }

    public static String truncateReason(String reason) {
        if (reason != null && reason.length() > FlowValueConstraint.FAILURE_REASON.getMaxSize()) {
            reason = reason.substring(0, FlowValueConstraint.FAILURE_REASON.getMaxSize());
        }
        return reason;
    }

    public static String truncateDetails(String details) {
        if (details != null && details.length() > FlowValueConstraint.FAILURE_DETAILS.getMaxSize()) {
            details = details.substring(0, FlowValueConstraint.FAILURE_DETAILS.getMaxSize());
        }
        return details;
    }

    public static Throwable truncateStackTrace(Throwable throwable) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            cause.setStackTrace(new StackTraceElement[0]);
        }
        return throwable;
    }
}

