/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class WorkflowExecutionLocal<T> {
    private final ThreadLocal<Wrapper<T>> value = new ThreadLocal();
    private final String workflowExecutionLocalId = UUID.randomUUID().toString();
    private static final Map<String, WorkflowExecutionLocal<?>> locals = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void before() {
        HashMap currentLocals;
        Map<String, WorkflowExecutionLocal<?>> map = locals;
        synchronized (map) {
            currentLocals = new HashMap(locals);
        }
        for (WorkflowExecutionLocal local : currentLocals.values()) {
            Wrapper w = new Wrapper();
            w.wrapped = local.initialValue();
            local.set(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void after() {
        HashMap currentLocals;
        Map<String, WorkflowExecutionLocal<?>> map = locals;
        synchronized (map) {
            currentLocals = new HashMap(locals);
        }
        for (WorkflowExecutionLocal local : currentLocals.values()) {
            local.removeAfter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Wrapper> saveCurrentValues() {
        HashMap currentLocals;
        Map<String, WorkflowExecutionLocal<?>> map = locals;
        synchronized (map) {
            currentLocals = new HashMap(locals);
        }
        HashMap<String, Wrapper> currentValues = new HashMap<String, Wrapper>();
        currentLocals.forEach((id, local) -> {
            if (local.value.get() != null) {
                Wrapper w = new Wrapper();
                w.wrapped = local.value.get().wrapped;
                currentValues.put((String)id, w);
            }
        });
        return currentValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreFromSavedValues(Map<String, Wrapper> savedValues) {
        HashMap currentLocals;
        Map<String, WorkflowExecutionLocal<?>> map = locals;
        synchronized (map) {
            currentLocals = new HashMap(locals);
        }
        currentLocals.forEach((id, local) -> {
            if (savedValues.containsKey(id)) {
                local.set((Wrapper)savedValues.get(id));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowExecutionLocal() {
        Wrapper w = new Wrapper();
        w.wrapped = this.initialValue();
        this.set(w);
        Map<String, WorkflowExecutionLocal<?>> map = locals;
        synchronized (map) {
            locals.put(this.workflowExecutionLocalId, this);
        }
    }

    public T get() {
        Wrapper<T> w = this.getWrapped();
        return w.wrapped;
    }

    private Wrapper<T> getWrapped() {
        Wrapper<T> w = this.value.get();
        if (w == null) {
            throw new IllegalStateException("Called outside of the workflow definition code.");
        }
        return w;
    }

    public int hashCode() {
        Wrapper<T> w = this.getWrapped();
        return w.wrapped.hashCode();
    }

    public void remove() {
        Wrapper<T> w = this.getWrapped();
        w.wrapped = null;
    }

    public void set(T v) {
        Wrapper<T> w = this.getWrapped();
        w.wrapped = v;
    }

    private void set(Wrapper<T> w) {
        this.value.set(w);
    }

    private void removeAfter() {
        this.value.remove();
    }

    protected T initialValue() {
        return null;
    }

    public static class Wrapper<T> {
        public T wrapped;
    }
}

