/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonDataConverter
extends DataConverter {
    private static final Log log = LogFactory.getLog(JsonDataConverter.class);
    protected final ObjectMapper mapper;

    public JsonDataConverter() {
        this(new ObjectMapper());
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.activateDefaultTyping((PolymorphicTypeValidator)BasicPolymorphicTypeValidator.builder().allowIfBaseType(Object.class).build(), ObjectMapper.DefaultTyping.NON_FINAL);
        this.mapper.addMixIn(Throwable.class, ThrowableMixin.class);
    }

    public JsonDataConverter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String toData(Object value) throws DataConverterException {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (IOException e) {
            log.error((Object)"Unable to serialize data", (Throwable)e);
            this.throwDataConverterException(e, value);
            throw new IllegalStateException("not reachable");
        }
    }

    private void throwDataConverterException(Throwable e, Object value) {
        if (value == null) {
            throw new DataConverterException("Failure serializing null value", e);
        }
        throw new DataConverterException("Failure serializing \"" + value + "\" of type \"" + value.getClass() + "\"", e);
    }

    @Override
    public <T> T fromData(String serialized, Class<T> valueType) throws DataConverterException {
        try {
            return (T)this.mapper.readValue(serialized, valueType);
        }
        catch (IOException e) {
            log.error((Object)"Unable to deserialize data", (Throwable)e);
            throw new DataConverterException(e);
        }
    }

    abstract class ThrowableMixin {
        ThrowableMixin() {
        }

        @JsonIgnore
        abstract String getLocalizedMessage();
    }
}

