/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import com.amazonaws.services.simpleworkflow.flow.DynamicWorkflowClientExternal;
import com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.amazonaws.services.simpleworkflow.flow.StartWorkflowOptions;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClientExternal;
import com.amazonaws.services.simpleworkflow.flow.generic.SignalExternalWorkflowParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.TerminateWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.services.swf.model.ChildPolicy;

public class DynamicWorkflowClientExternalImpl
implements DynamicWorkflowClientExternal {
    protected DataConverter dataConverter;
    protected StartWorkflowOptions schedulingOptions;
    protected GenericWorkflowClientExternal genericClient;
    protected WorkflowExecution workflowExecution;
    protected WorkflowType workflowType;

    public DynamicWorkflowClientExternalImpl(String workflowId, WorkflowType workflowType) {
        this(WorkflowExecution.builder().workflowId(workflowId).build(), workflowType, null, null);
    }

    public DynamicWorkflowClientExternalImpl(WorkflowExecution workflowExecution) {
        this(workflowExecution, null, null, null);
    }

    public DynamicWorkflowClientExternalImpl(String workflowId, WorkflowType workflowType, StartWorkflowOptions options) {
        this(WorkflowExecution.builder().workflowId(workflowId).build(), workflowType, options, null, null);
    }

    public DynamicWorkflowClientExternalImpl(WorkflowExecution workflowExecution, WorkflowType workflowType, StartWorkflowOptions options) {
        this(workflowExecution, workflowType, options, null, null);
    }

    public DynamicWorkflowClientExternalImpl(WorkflowExecution workflowExecution, WorkflowType workflowType, StartWorkflowOptions options, DataConverter dataConverter) {
        this(workflowExecution, workflowType, options, dataConverter, null);
    }

    public DynamicWorkflowClientExternalImpl(WorkflowExecution workflowExecution, WorkflowType workflowType, StartWorkflowOptions options, DataConverter dataConverter, GenericWorkflowClientExternal genericClient) {
        this.workflowExecution = workflowExecution;
        this.workflowType = workflowType;
        this.schedulingOptions = options;
        this.dataConverter = dataConverter == null ? new JsonDataConverter() : dataConverter;
        this.genericClient = genericClient;
    }

    @Override
    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(DataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Override
    public StartWorkflowOptions getSchedulingOptions() {
        return this.schedulingOptions;
    }

    public void setSchedulingOptions(StartWorkflowOptions schedulingOptions) {
        this.schedulingOptions = schedulingOptions;
    }

    @Override
    public GenericWorkflowClientExternal getGenericClient() {
        return this.genericClient;
    }

    public void setGenericClient(GenericWorkflowClientExternal genericClient) {
        this.genericClient = genericClient;
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    public void setWorkflowExecution(WorkflowExecution workflowExecution) {
        this.workflowExecution = workflowExecution;
    }

    @Override
    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    @Override
    public void terminateWorkflowExecution(String reason, String details, ChildPolicy childPolicy) {
        TerminateWorkflowExecutionParameters terminateParameters = new TerminateWorkflowExecutionParameters();
        terminateParameters.setReason(reason);
        terminateParameters.setDetails(details);
        if (childPolicy != null) {
            terminateParameters.setChildPolicy(childPolicy);
        }
        terminateParameters.setWorkflowExecution(this.workflowExecution);
        this.genericClient.terminateWorkflowExecution(terminateParameters);
    }

    @Override
    public void requestCancelWorkflowExecution() {
        this.genericClient.requestCancelWorkflowExecution(this.workflowExecution);
    }

    @Override
    public void startWorkflowExecution(Object[] arguments) {
        this.startWorkflowExecution(arguments, null);
    }

    @Override
    public void startWorkflowExecution(Object[] arguments, StartWorkflowOptions startOptionsOverride) {
        if (this.workflowType == null) {
            throw new IllegalStateException("Required property workflowType is null");
        }
        if (this.workflowExecution == null) {
            throw new IllegalStateException("wokflowExecution is null");
        }
        if (this.workflowExecution.getWorkflowId() == null) {
            throw new IllegalStateException("wokflowId is null");
        }
        StartWorkflowExecutionParameters parameters = new StartWorkflowExecutionParameters();
        parameters.setWorkflowType(this.workflowType);
        parameters.setWorkflowId(this.workflowExecution.getWorkflowId());
        String input = ThreadLocalMetrics.getMetrics().recordSupplier(() -> this.dataConverter.toData(arguments), this.dataConverter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS);
        parameters.setInput(input);
        parameters = parameters.createStartWorkflowExecutionParametersFromOptions(this.schedulingOptions, startOptionsOverride);
        WorkflowExecution newExecution = this.genericClient.startWorkflow(parameters);
        String runId = newExecution.getRunId();
        this.workflowExecution = this.workflowExecution.toBuilder().runId(runId).build();
    }

    @Override
    public void signalWorkflowExecution(String signalName, Object[] arguments) {
        SignalExternalWorkflowParameters signalParameters = new SignalExternalWorkflowParameters();
        signalParameters.setRunId(this.workflowExecution.getRunId());
        signalParameters.setWorkflowId(this.workflowExecution.getWorkflowId());
        signalParameters.setSignalName(signalName);
        String input = ThreadLocalMetrics.getMetrics().recordSupplier(() -> this.dataConverter.toData(arguments), this.dataConverter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS);
        signalParameters.setInput(input);
        this.genericClient.signalWorkflowExecution(signalParameters);
    }

    @Override
    public <T> T getWorkflowExecutionState(Class<T> returnType) throws Throwable {
        String state = this.genericClient.getWorkflowState(this.workflowExecution);
        if (state == null) {
            return null;
        }
        try {
            Throwable failure = ThreadLocalMetrics.getMetrics().recordSupplier(() -> this.dataConverter.fromData(state, Throwable.class), this.dataConverter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_DESERIALIZE.getName(), TimeUnit.MILLISECONDS);
            if (failure != null) {
                throw failure;
            }
        }
        catch (DataConverterException dataConverterException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return (T)ThreadLocalMetrics.getMetrics().recordSupplier(() -> this.dataConverter.fromData(state, returnType), this.dataConverter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_DESERIALIZE.getName(), TimeUnit.MILLISECONDS);
    }

    @Override
    public Map<String, Integer> getImplementationVersions() {
        return this.genericClient.getImplementationVersions(this.workflowExecution);
    }
}

