/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.supportapp;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.supportapp.AWSSupportApp;
import com.amazonaws.services.supportapp.AWSSupportAppClientBuilder;
import com.amazonaws.services.supportapp.model.AWSSupportAppException;
import com.amazonaws.services.supportapp.model.CreateSlackChannelConfigurationRequest;
import com.amazonaws.services.supportapp.model.CreateSlackChannelConfigurationResult;
import com.amazonaws.services.supportapp.model.DeleteAccountAliasRequest;
import com.amazonaws.services.supportapp.model.DeleteAccountAliasResult;
import com.amazonaws.services.supportapp.model.DeleteSlackChannelConfigurationRequest;
import com.amazonaws.services.supportapp.model.DeleteSlackChannelConfigurationResult;
import com.amazonaws.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest;
import com.amazonaws.services.supportapp.model.DeleteSlackWorkspaceConfigurationResult;
import com.amazonaws.services.supportapp.model.GetAccountAliasRequest;
import com.amazonaws.services.supportapp.model.GetAccountAliasResult;
import com.amazonaws.services.supportapp.model.ListSlackChannelConfigurationsRequest;
import com.amazonaws.services.supportapp.model.ListSlackChannelConfigurationsResult;
import com.amazonaws.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest;
import com.amazonaws.services.supportapp.model.ListSlackWorkspaceConfigurationsResult;
import com.amazonaws.services.supportapp.model.PutAccountAliasRequest;
import com.amazonaws.services.supportapp.model.PutAccountAliasResult;
import com.amazonaws.services.supportapp.model.UpdateSlackChannelConfigurationRequest;
import com.amazonaws.services.supportapp.model.UpdateSlackChannelConfigurationResult;
import com.amazonaws.services.supportapp.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.CreateSlackChannelConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.supportapp.model.transform.CreateSlackChannelConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.DeleteAccountAliasRequestProtocolMarshaller;
import com.amazonaws.services.supportapp.model.transform.DeleteAccountAliasResultJsonUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.DeleteSlackChannelConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.supportapp.model.transform.DeleteSlackChannelConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.DeleteSlackWorkspaceConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.supportapp.model.transform.DeleteSlackWorkspaceConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.GetAccountAliasRequestProtocolMarshaller;
import com.amazonaws.services.supportapp.model.transform.GetAccountAliasResultJsonUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.ListSlackChannelConfigurationsRequestProtocolMarshaller;
import com.amazonaws.services.supportapp.model.transform.ListSlackChannelConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.ListSlackWorkspaceConfigurationsRequestProtocolMarshaller;
import com.amazonaws.services.supportapp.model.transform.ListSlackWorkspaceConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.PutAccountAliasRequestProtocolMarshaller;
import com.amazonaws.services.supportapp.model.transform.PutAccountAliasResultJsonUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.UpdateSlackChannelConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.supportapp.model.transform.UpdateSlackChannelConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.supportapp.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSSupportAppClient
extends AmazonWebServiceClient
implements AWSSupportApp {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSupportApp.class);
    private static final String DEFAULT_SIGNING_NAME = "supportapp";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSSupportAppException.class));

    public static AWSSupportAppClientBuilder builder() {
        return AWSSupportAppClientBuilder.standard();
    }

    AWSSupportAppClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSupportAppClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("supportapp.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/supportapp/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/supportapp/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateSlackChannelConfigurationResult createSlackChannelConfiguration(CreateSlackChannelConfigurationRequest request) {
        request = (CreateSlackChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executeCreateSlackChannelConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSlackChannelConfigurationResult executeCreateSlackChannelConfiguration(CreateSlackChannelConfigurationRequest createSlackChannelConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSlackChannelConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSlackChannelConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSlackChannelConfigurationRequestProtocolMarshaller(protocolFactory).marshall((CreateSlackChannelConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSlackChannelConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Support App");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSlackChannelConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSlackChannelConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSlackChannelConfigurationResult createSlackChannelConfigurationResult = (CreateSlackChannelConfigurationResult)response.getAwsResponse();
            return createSlackChannelConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAccountAliasResult deleteAccountAlias(DeleteAccountAliasRequest request) {
        request = (DeleteAccountAliasRequest)this.beforeClientExecution(request);
        return this.executeDeleteAccountAlias(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAccountAliasResult executeDeleteAccountAlias(DeleteAccountAliasRequest deleteAccountAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAccountAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAccountAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAccountAliasRequestProtocolMarshaller(protocolFactory).marshall((DeleteAccountAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAccountAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Support App");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAccountAlias");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAccountAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAccountAliasResult deleteAccountAliasResult = (DeleteAccountAliasResult)response.getAwsResponse();
            return deleteAccountAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSlackChannelConfigurationResult deleteSlackChannelConfiguration(DeleteSlackChannelConfigurationRequest request) {
        request = (DeleteSlackChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteSlackChannelConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSlackChannelConfigurationResult executeDeleteSlackChannelConfiguration(DeleteSlackChannelConfigurationRequest deleteSlackChannelConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSlackChannelConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSlackChannelConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSlackChannelConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeleteSlackChannelConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSlackChannelConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Support App");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSlackChannelConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSlackChannelConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSlackChannelConfigurationResult deleteSlackChannelConfigurationResult = (DeleteSlackChannelConfigurationResult)response.getAwsResponse();
            return deleteSlackChannelConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSlackWorkspaceConfigurationResult deleteSlackWorkspaceConfiguration(DeleteSlackWorkspaceConfigurationRequest request) {
        request = (DeleteSlackWorkspaceConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteSlackWorkspaceConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSlackWorkspaceConfigurationResult executeDeleteSlackWorkspaceConfiguration(DeleteSlackWorkspaceConfigurationRequest deleteSlackWorkspaceConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSlackWorkspaceConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSlackWorkspaceConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSlackWorkspaceConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeleteSlackWorkspaceConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSlackWorkspaceConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Support App");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSlackWorkspaceConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSlackWorkspaceConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSlackWorkspaceConfigurationResult deleteSlackWorkspaceConfigurationResult = (DeleteSlackWorkspaceConfigurationResult)response.getAwsResponse();
            return deleteSlackWorkspaceConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccountAliasResult getAccountAlias(GetAccountAliasRequest request) {
        request = (GetAccountAliasRequest)this.beforeClientExecution(request);
        return this.executeGetAccountAlias(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccountAliasResult executeGetAccountAlias(GetAccountAliasRequest getAccountAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccountAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccountAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccountAliasRequestProtocolMarshaller(protocolFactory).marshall((GetAccountAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccountAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Support App");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccountAlias");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAccountAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAccountAliasResult getAccountAliasResult = (GetAccountAliasResult)response.getAwsResponse();
            return getAccountAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSlackChannelConfigurationsResult listSlackChannelConfigurations(ListSlackChannelConfigurationsRequest request) {
        request = (ListSlackChannelConfigurationsRequest)this.beforeClientExecution(request);
        return this.executeListSlackChannelConfigurations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSlackChannelConfigurationsResult executeListSlackChannelConfigurations(ListSlackChannelConfigurationsRequest listSlackChannelConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSlackChannelConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSlackChannelConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSlackChannelConfigurationsRequestProtocolMarshaller(protocolFactory).marshall((ListSlackChannelConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSlackChannelConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Support App");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSlackChannelConfigurations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSlackChannelConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSlackChannelConfigurationsResult listSlackChannelConfigurationsResult = (ListSlackChannelConfigurationsResult)response.getAwsResponse();
            return listSlackChannelConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSlackWorkspaceConfigurationsResult listSlackWorkspaceConfigurations(ListSlackWorkspaceConfigurationsRequest request) {
        request = (ListSlackWorkspaceConfigurationsRequest)this.beforeClientExecution(request);
        return this.executeListSlackWorkspaceConfigurations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSlackWorkspaceConfigurationsResult executeListSlackWorkspaceConfigurations(ListSlackWorkspaceConfigurationsRequest listSlackWorkspaceConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSlackWorkspaceConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSlackWorkspaceConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSlackWorkspaceConfigurationsRequestProtocolMarshaller(protocolFactory).marshall((ListSlackWorkspaceConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSlackWorkspaceConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Support App");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSlackWorkspaceConfigurations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSlackWorkspaceConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSlackWorkspaceConfigurationsResult listSlackWorkspaceConfigurationsResult = (ListSlackWorkspaceConfigurationsResult)response.getAwsResponse();
            return listSlackWorkspaceConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutAccountAliasResult putAccountAlias(PutAccountAliasRequest request) {
        request = (PutAccountAliasRequest)this.beforeClientExecution(request);
        return this.executePutAccountAlias(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutAccountAliasResult executePutAccountAlias(PutAccountAliasRequest putAccountAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAccountAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutAccountAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutAccountAliasRequestProtocolMarshaller(protocolFactory).marshall((PutAccountAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)putAccountAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Support App");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutAccountAlias");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutAccountAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutAccountAliasResult putAccountAliasResult = (PutAccountAliasResult)response.getAwsResponse();
            return putAccountAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSlackChannelConfigurationResult updateSlackChannelConfiguration(UpdateSlackChannelConfigurationRequest request) {
        request = (UpdateSlackChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateSlackChannelConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSlackChannelConfigurationResult executeUpdateSlackChannelConfiguration(UpdateSlackChannelConfigurationRequest updateSlackChannelConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSlackChannelConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSlackChannelConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSlackChannelConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateSlackChannelConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSlackChannelConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Support App");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSlackChannelConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSlackChannelConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSlackChannelConfigurationResult updateSlackChannelConfigurationResult = (UpdateSlackChannelConfigurationResult)response.getAwsResponse();
            return updateSlackChannelConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

