/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.support.AWSSupportAsync;
import com.amazonaws.services.support.AWSSupportAsyncClientBuilder;
import com.amazonaws.services.support.AWSSupportClient;
import com.amazonaws.services.support.model.AddAttachmentsToSetRequest;
import com.amazonaws.services.support.model.AddAttachmentsToSetResult;
import com.amazonaws.services.support.model.AddCommunicationToCaseRequest;
import com.amazonaws.services.support.model.AddCommunicationToCaseResult;
import com.amazonaws.services.support.model.CreateCaseRequest;
import com.amazonaws.services.support.model.CreateCaseResult;
import com.amazonaws.services.support.model.DescribeAttachmentRequest;
import com.amazonaws.services.support.model.DescribeAttachmentResult;
import com.amazonaws.services.support.model.DescribeCasesRequest;
import com.amazonaws.services.support.model.DescribeCasesResult;
import com.amazonaws.services.support.model.DescribeCommunicationsRequest;
import com.amazonaws.services.support.model.DescribeCommunicationsResult;
import com.amazonaws.services.support.model.DescribeServicesRequest;
import com.amazonaws.services.support.model.DescribeServicesResult;
import com.amazonaws.services.support.model.DescribeSeverityLevelsRequest;
import com.amazonaws.services.support.model.DescribeSeverityLevelsResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckResultRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckResultResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckSummariesResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorChecksRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorChecksResult;
import com.amazonaws.services.support.model.RefreshTrustedAdvisorCheckRequest;
import com.amazonaws.services.support.model.RefreshTrustedAdvisorCheckResult;
import com.amazonaws.services.support.model.ResolveCaseRequest;
import com.amazonaws.services.support.model.ResolveCaseResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSupportAsyncClient
extends AWSSupportClient
implements AWSSupportAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSSupportAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSSupportAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSSupportAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSSupportAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSSupportAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSSupportAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSSupportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSSupportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSSupportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSSupportAsyncClientBuilder asyncBuilder() {
        return AWSSupportAsyncClientBuilder.standard();
    }

    AWSSupportAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSupportAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddAttachmentsToSetResult> addAttachmentsToSetAsync(AddAttachmentsToSetRequest request) {
        return this.addAttachmentsToSetAsync(request, null);
    }

    @Override
    public Future<AddAttachmentsToSetResult> addAttachmentsToSetAsync(AddAttachmentsToSetRequest request, final AsyncHandler<AddAttachmentsToSetRequest, AddAttachmentsToSetResult> asyncHandler) {
        final AddAttachmentsToSetRequest finalRequest = (AddAttachmentsToSetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddAttachmentsToSetResult>(){

            @Override
            public AddAttachmentsToSetResult call() throws Exception {
                AddAttachmentsToSetResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeAddAttachmentsToSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddCommunicationToCaseResult> addCommunicationToCaseAsync(AddCommunicationToCaseRequest request) {
        return this.addCommunicationToCaseAsync(request, null);
    }

    @Override
    public Future<AddCommunicationToCaseResult> addCommunicationToCaseAsync(AddCommunicationToCaseRequest request, final AsyncHandler<AddCommunicationToCaseRequest, AddCommunicationToCaseResult> asyncHandler) {
        final AddCommunicationToCaseRequest finalRequest = (AddCommunicationToCaseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddCommunicationToCaseResult>(){

            @Override
            public AddCommunicationToCaseResult call() throws Exception {
                AddCommunicationToCaseResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeAddCommunicationToCase(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCaseResult> createCaseAsync(CreateCaseRequest request) {
        return this.createCaseAsync(request, null);
    }

    @Override
    public Future<CreateCaseResult> createCaseAsync(CreateCaseRequest request, final AsyncHandler<CreateCaseRequest, CreateCaseResult> asyncHandler) {
        final CreateCaseRequest finalRequest = (CreateCaseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCaseResult>(){

            @Override
            public CreateCaseResult call() throws Exception {
                CreateCaseResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeCreateCase(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAttachmentResult> describeAttachmentAsync(DescribeAttachmentRequest request) {
        return this.describeAttachmentAsync(request, null);
    }

    @Override
    public Future<DescribeAttachmentResult> describeAttachmentAsync(DescribeAttachmentRequest request, final AsyncHandler<DescribeAttachmentRequest, DescribeAttachmentResult> asyncHandler) {
        final DescribeAttachmentRequest finalRequest = (DescribeAttachmentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAttachmentResult>(){

            @Override
            public DescribeAttachmentResult call() throws Exception {
                DescribeAttachmentResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeDescribeAttachment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCasesResult> describeCasesAsync(DescribeCasesRequest request) {
        return this.describeCasesAsync(request, null);
    }

    @Override
    public Future<DescribeCasesResult> describeCasesAsync(DescribeCasesRequest request, final AsyncHandler<DescribeCasesRequest, DescribeCasesResult> asyncHandler) {
        final DescribeCasesRequest finalRequest = (DescribeCasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCasesResult>(){

            @Override
            public DescribeCasesResult call() throws Exception {
                DescribeCasesResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeDescribeCases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCasesResult> describeCasesAsync() {
        return this.describeCasesAsync(new DescribeCasesRequest());
    }

    @Override
    public Future<DescribeCasesResult> describeCasesAsync(AsyncHandler<DescribeCasesRequest, DescribeCasesResult> asyncHandler) {
        return this.describeCasesAsync(new DescribeCasesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeCommunicationsResult> describeCommunicationsAsync(DescribeCommunicationsRequest request) {
        return this.describeCommunicationsAsync(request, null);
    }

    @Override
    public Future<DescribeCommunicationsResult> describeCommunicationsAsync(DescribeCommunicationsRequest request, final AsyncHandler<DescribeCommunicationsRequest, DescribeCommunicationsResult> asyncHandler) {
        final DescribeCommunicationsRequest finalRequest = (DescribeCommunicationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCommunicationsResult>(){

            @Override
            public DescribeCommunicationsResult call() throws Exception {
                DescribeCommunicationsResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeDescribeCommunications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(DescribeServicesRequest request) {
        return this.describeServicesAsync(request, null);
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(DescribeServicesRequest request, final AsyncHandler<DescribeServicesRequest, DescribeServicesResult> asyncHandler) {
        final DescribeServicesRequest finalRequest = (DescribeServicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeServicesResult>(){

            @Override
            public DescribeServicesResult call() throws Exception {
                DescribeServicesResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeDescribeServices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync() {
        return this.describeServicesAsync(new DescribeServicesRequest());
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(AsyncHandler<DescribeServicesRequest, DescribeServicesResult> asyncHandler) {
        return this.describeServicesAsync(new DescribeServicesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeSeverityLevelsResult> describeSeverityLevelsAsync(DescribeSeverityLevelsRequest request) {
        return this.describeSeverityLevelsAsync(request, null);
    }

    @Override
    public Future<DescribeSeverityLevelsResult> describeSeverityLevelsAsync(DescribeSeverityLevelsRequest request, final AsyncHandler<DescribeSeverityLevelsRequest, DescribeSeverityLevelsResult> asyncHandler) {
        final DescribeSeverityLevelsRequest finalRequest = (DescribeSeverityLevelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSeverityLevelsResult>(){

            @Override
            public DescribeSeverityLevelsResult call() throws Exception {
                DescribeSeverityLevelsResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeDescribeSeverityLevels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSeverityLevelsResult> describeSeverityLevelsAsync() {
        return this.describeSeverityLevelsAsync(new DescribeSeverityLevelsRequest());
    }

    @Override
    public Future<DescribeSeverityLevelsResult> describeSeverityLevelsAsync(AsyncHandler<DescribeSeverityLevelsRequest, DescribeSeverityLevelsResult> asyncHandler) {
        return this.describeSeverityLevelsAsync(new DescribeSeverityLevelsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckRefreshStatusesResult> describeTrustedAdvisorCheckRefreshStatusesAsync(DescribeTrustedAdvisorCheckRefreshStatusesRequest request) {
        return this.describeTrustedAdvisorCheckRefreshStatusesAsync(request, null);
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckRefreshStatusesResult> describeTrustedAdvisorCheckRefreshStatusesAsync(DescribeTrustedAdvisorCheckRefreshStatusesRequest request, final AsyncHandler<DescribeTrustedAdvisorCheckRefreshStatusesRequest, DescribeTrustedAdvisorCheckRefreshStatusesResult> asyncHandler) {
        final DescribeTrustedAdvisorCheckRefreshStatusesRequest finalRequest = (DescribeTrustedAdvisorCheckRefreshStatusesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorCheckRefreshStatusesResult>(){

            @Override
            public DescribeTrustedAdvisorCheckRefreshStatusesResult call() throws Exception {
                DescribeTrustedAdvisorCheckRefreshStatusesResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeDescribeTrustedAdvisorCheckRefreshStatuses(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckResultResult> describeTrustedAdvisorCheckResultAsync(DescribeTrustedAdvisorCheckResultRequest request) {
        return this.describeTrustedAdvisorCheckResultAsync(request, null);
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckResultResult> describeTrustedAdvisorCheckResultAsync(DescribeTrustedAdvisorCheckResultRequest request, final AsyncHandler<DescribeTrustedAdvisorCheckResultRequest, DescribeTrustedAdvisorCheckResultResult> asyncHandler) {
        final DescribeTrustedAdvisorCheckResultRequest finalRequest = (DescribeTrustedAdvisorCheckResultRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorCheckResultResult>(){

            @Override
            public DescribeTrustedAdvisorCheckResultResult call() throws Exception {
                DescribeTrustedAdvisorCheckResultResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeDescribeTrustedAdvisorCheckResult(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckSummariesResult> describeTrustedAdvisorCheckSummariesAsync(DescribeTrustedAdvisorCheckSummariesRequest request) {
        return this.describeTrustedAdvisorCheckSummariesAsync(request, null);
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckSummariesResult> describeTrustedAdvisorCheckSummariesAsync(DescribeTrustedAdvisorCheckSummariesRequest request, final AsyncHandler<DescribeTrustedAdvisorCheckSummariesRequest, DescribeTrustedAdvisorCheckSummariesResult> asyncHandler) {
        final DescribeTrustedAdvisorCheckSummariesRequest finalRequest = (DescribeTrustedAdvisorCheckSummariesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorCheckSummariesResult>(){

            @Override
            public DescribeTrustedAdvisorCheckSummariesResult call() throws Exception {
                DescribeTrustedAdvisorCheckSummariesResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeDescribeTrustedAdvisorCheckSummaries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTrustedAdvisorChecksResult> describeTrustedAdvisorChecksAsync(DescribeTrustedAdvisorChecksRequest request) {
        return this.describeTrustedAdvisorChecksAsync(request, null);
    }

    @Override
    public Future<DescribeTrustedAdvisorChecksResult> describeTrustedAdvisorChecksAsync(DescribeTrustedAdvisorChecksRequest request, final AsyncHandler<DescribeTrustedAdvisorChecksRequest, DescribeTrustedAdvisorChecksResult> asyncHandler) {
        final DescribeTrustedAdvisorChecksRequest finalRequest = (DescribeTrustedAdvisorChecksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorChecksResult>(){

            @Override
            public DescribeTrustedAdvisorChecksResult call() throws Exception {
                DescribeTrustedAdvisorChecksResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeDescribeTrustedAdvisorChecks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RefreshTrustedAdvisorCheckResult> refreshTrustedAdvisorCheckAsync(RefreshTrustedAdvisorCheckRequest request) {
        return this.refreshTrustedAdvisorCheckAsync(request, null);
    }

    @Override
    public Future<RefreshTrustedAdvisorCheckResult> refreshTrustedAdvisorCheckAsync(RefreshTrustedAdvisorCheckRequest request, final AsyncHandler<RefreshTrustedAdvisorCheckRequest, RefreshTrustedAdvisorCheckResult> asyncHandler) {
        final RefreshTrustedAdvisorCheckRequest finalRequest = (RefreshTrustedAdvisorCheckRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RefreshTrustedAdvisorCheckResult>(){

            @Override
            public RefreshTrustedAdvisorCheckResult call() throws Exception {
                RefreshTrustedAdvisorCheckResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeRefreshTrustedAdvisorCheck(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResolveCaseResult> resolveCaseAsync(ResolveCaseRequest request) {
        return this.resolveCaseAsync(request, null);
    }

    @Override
    public Future<ResolveCaseResult> resolveCaseAsync(ResolveCaseRequest request, final AsyncHandler<ResolveCaseRequest, ResolveCaseResult> asyncHandler) {
        final ResolveCaseRequest finalRequest = (ResolveCaseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResolveCaseResult>(){

            @Override
            public ResolveCaseResult call() throws Exception {
                ResolveCaseResult result = null;
                try {
                    result = AWSSupportAsyncClient.this.executeResolveCase(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResolveCaseResult> resolveCaseAsync() {
        return this.resolveCaseAsync(new ResolveCaseRequest());
    }

    @Override
    public Future<ResolveCaseResult> resolveCaseAsync(AsyncHandler<ResolveCaseRequest, ResolveCaseResult> asyncHandler) {
        return this.resolveCaseAsync(new ResolveCaseRequest(), asyncHandler);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

