/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.supplychain;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.supplychain.AWSSupplyChainAsync;
import com.amazonaws.services.supplychain.AWSSupplyChainAsyncClientBuilder;
import com.amazonaws.services.supplychain.AWSSupplyChainClient;
import com.amazonaws.services.supplychain.model.CreateBillOfMaterialsImportJobRequest;
import com.amazonaws.services.supplychain.model.CreateBillOfMaterialsImportJobResult;
import com.amazonaws.services.supplychain.model.GetBillOfMaterialsImportJobRequest;
import com.amazonaws.services.supplychain.model.GetBillOfMaterialsImportJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSupplyChainAsyncClient
extends AWSSupplyChainClient
implements AWSSupplyChainAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSupplyChainAsyncClientBuilder asyncBuilder() {
        return AWSSupplyChainAsyncClientBuilder.standard();
    }

    AWSSupplyChainAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSupplyChainAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateBillOfMaterialsImportJobResult> createBillOfMaterialsImportJobAsync(CreateBillOfMaterialsImportJobRequest request) {
        return this.createBillOfMaterialsImportJobAsync(request, null);
    }

    @Override
    public Future<CreateBillOfMaterialsImportJobResult> createBillOfMaterialsImportJobAsync(CreateBillOfMaterialsImportJobRequest request, final AsyncHandler<CreateBillOfMaterialsImportJobRequest, CreateBillOfMaterialsImportJobResult> asyncHandler) {
        final CreateBillOfMaterialsImportJobRequest finalRequest = (CreateBillOfMaterialsImportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBillOfMaterialsImportJobResult>(){

            @Override
            public CreateBillOfMaterialsImportJobResult call() throws Exception {
                CreateBillOfMaterialsImportJobResult result = null;
                try {
                    result = AWSSupplyChainAsyncClient.this.executeCreateBillOfMaterialsImportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBillOfMaterialsImportJobResult> getBillOfMaterialsImportJobAsync(GetBillOfMaterialsImportJobRequest request) {
        return this.getBillOfMaterialsImportJobAsync(request, null);
    }

    @Override
    public Future<GetBillOfMaterialsImportJobResult> getBillOfMaterialsImportJobAsync(GetBillOfMaterialsImportJobRequest request, final AsyncHandler<GetBillOfMaterialsImportJobRequest, GetBillOfMaterialsImportJobResult> asyncHandler) {
        final GetBillOfMaterialsImportJobRequest finalRequest = (GetBillOfMaterialsImportJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBillOfMaterialsImportJobResult>(){

            @Override
            public GetBillOfMaterialsImportJobResult call() throws Exception {
                GetBillOfMaterialsImportJobResult result = null;
                try {
                    result = AWSSupplyChainAsyncClient.this.executeGetBillOfMaterialsImportJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

