/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.storagegateway.model.CreateTapesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateTapesRequestMarshaller
implements Marshaller<Request<CreateTapesRequest>, CreateTapesRequest> {
    public Request<CreateTapesRequest> marshall(CreateTapesRequest createTapesRequest) {
        if (createTapesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTapesRequest, "AWSStorageGateway");
        String target = "StorageGateway_20130630.CreateTapes";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createTapesRequest.getGatewayARN() != null) {
                jsonWriter.key("GatewayARN").value((Object)createTapesRequest.getGatewayARN());
            }
            if (createTapesRequest.getTapeSizeInBytes() != null) {
                jsonWriter.key("TapeSizeInBytes").value((Object)createTapesRequest.getTapeSizeInBytes());
            }
            if (createTapesRequest.getClientToken() != null) {
                jsonWriter.key("ClientToken").value((Object)createTapesRequest.getClientToken());
            }
            if (createTapesRequest.getNumTapesToCreate() != null) {
                jsonWriter.key("NumTapesToCreate").value((Object)createTapesRequest.getNumTapesToCreate());
            }
            if (createTapesRequest.getTapeBarcodePrefix() != null) {
                jsonWriter.key("TapeBarcodePrefix").value((Object)createTapesRequest.getTapeBarcodePrefix());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

