/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.CreateNFSFileShareRequest;
import com.amazonaws.services.storagegateway.model.transform.NFSFileShareDefaultsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateNFSFileShareRequestMarshaller
implements Marshaller<Request<CreateNFSFileShareRequest>, CreateNFSFileShareRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateNFSFileShareRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateNFSFileShareRequest> marshall(CreateNFSFileShareRequest createNFSFileShareRequest) {
        if (createNFSFileShareRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNFSFileShareRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.CreateNFSFileShare");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList clientListList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createNFSFileShareRequest.getClientToken() != null) {
                jsonGenerator.writeFieldName("ClientToken").writeValue(createNFSFileShareRequest.getClientToken());
            }
            if (createNFSFileShareRequest.getNFSFileShareDefaults() != null) {
                jsonGenerator.writeFieldName("NFSFileShareDefaults");
                NFSFileShareDefaultsJsonMarshaller.getInstance().marshall(createNFSFileShareRequest.getNFSFileShareDefaults(), jsonGenerator);
            }
            if (createNFSFileShareRequest.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(createNFSFileShareRequest.getGatewayARN());
            }
            if (createNFSFileShareRequest.getKMSEncrypted() != null) {
                jsonGenerator.writeFieldName("KMSEncrypted").writeValue(createNFSFileShareRequest.getKMSEncrypted().booleanValue());
            }
            if (createNFSFileShareRequest.getKMSKey() != null) {
                jsonGenerator.writeFieldName("KMSKey").writeValue(createNFSFileShareRequest.getKMSKey());
            }
            if (createNFSFileShareRequest.getRole() != null) {
                jsonGenerator.writeFieldName("Role").writeValue(createNFSFileShareRequest.getRole());
            }
            if (createNFSFileShareRequest.getLocationARN() != null) {
                jsonGenerator.writeFieldName("LocationARN").writeValue(createNFSFileShareRequest.getLocationARN());
            }
            if (createNFSFileShareRequest.getDefaultStorageClass() != null) {
                jsonGenerator.writeFieldName("DefaultStorageClass").writeValue(createNFSFileShareRequest.getDefaultStorageClass());
            }
            if (!(clientListList = (SdkInternalList)createNFSFileShareRequest.getClientList()).isEmpty() || !clientListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ClientList");
                jsonGenerator.writeStartArray();
                for (String clientListListValue : clientListList) {
                    if (clientListListValue == null) continue;
                    jsonGenerator.writeValue(clientListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

