/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.TapeArchive;

public class TapeArchiveJsonMarshaller {
    private static TapeArchiveJsonMarshaller instance;

    public void marshall(TapeArchive tapeArchive, StructuredJsonGenerator jsonGenerator) {
        if (tapeArchive == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (tapeArchive.getTapeARN() != null) {
                jsonGenerator.writeFieldName("TapeARN").writeValue(tapeArchive.getTapeARN());
            }
            if (tapeArchive.getTapeBarcode() != null) {
                jsonGenerator.writeFieldName("TapeBarcode").writeValue(tapeArchive.getTapeBarcode());
            }
            if (tapeArchive.getTapeSizeInBytes() != null) {
                jsonGenerator.writeFieldName("TapeSizeInBytes").writeValue(tapeArchive.getTapeSizeInBytes().longValue());
            }
            if (tapeArchive.getCompletionTime() != null) {
                jsonGenerator.writeFieldName("CompletionTime").writeValue(tapeArchive.getCompletionTime());
            }
            if (tapeArchive.getRetrievedTo() != null) {
                jsonGenerator.writeFieldName("RetrievedTo").writeValue(tapeArchive.getRetrievedTo());
            }
            if (tapeArchive.getTapeStatus() != null) {
                jsonGenerator.writeFieldName("TapeStatus").writeValue(tapeArchive.getTapeStatus());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TapeArchiveJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TapeArchiveJsonMarshaller();
        }
        return instance;
    }
}

