/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

@SdkInternalApi
public final class JacksonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(new MapperFeature[]{MapperFeature.USE_ANNOTATIONS}).disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS}).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});

    private JacksonUtils() {
    }

    public static String jsonToString(JsonNode node) {
        try {
            return node == null ? null : MAPPER.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new SdkClientException("Could not serialize JSON", (Throwable)e);
        }
    }

    public static JsonNode stringToJsonNode(String paramName, String val) {
        if (val == null) {
            return null;
        }
        try {
            return MAPPER.readTree(val);
        }
        catch (IOException e) {
            throw new SdkClientException(paramName + " must be a valid JSON document", (Throwable)e);
        }
    }

    public static JsonNode objectToJsonNode(Object val) {
        return MAPPER.valueToTree(val);
    }
}

