/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.stepfunctions.model.EncryptionType;
import com.amazonaws.services.stepfunctions.model.transform.EncryptionConfigurationMarshaller;
import java.io.Serializable;

public class EncryptionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String kmsKeyId;
    private Integer kmsDataKeyReusePeriodSeconds;
    private String type;

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public EncryptionConfiguration withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setKmsDataKeyReusePeriodSeconds(Integer kmsDataKeyReusePeriodSeconds) {
        this.kmsDataKeyReusePeriodSeconds = kmsDataKeyReusePeriodSeconds;
    }

    public Integer getKmsDataKeyReusePeriodSeconds() {
        return this.kmsDataKeyReusePeriodSeconds;
    }

    public EncryptionConfiguration withKmsDataKeyReusePeriodSeconds(Integer kmsDataKeyReusePeriodSeconds) {
        this.setKmsDataKeyReusePeriodSeconds(kmsDataKeyReusePeriodSeconds);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public EncryptionConfiguration withType(String type) {
        this.setType(type);
        return this;
    }

    public EncryptionConfiguration withType(EncryptionType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getKmsDataKeyReusePeriodSeconds() != null) {
            sb.append("KmsDataKeyReusePeriodSeconds: ").append(this.getKmsDataKeyReusePeriodSeconds()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration)obj;
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getKmsDataKeyReusePeriodSeconds() == null ^ this.getKmsDataKeyReusePeriodSeconds() == null) {
            return false;
        }
        if (other.getKmsDataKeyReusePeriodSeconds() != null && !other.getKmsDataKeyReusePeriodSeconds().equals(this.getKmsDataKeyReusePeriodSeconds())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getKmsDataKeyReusePeriodSeconds() == null ? 0 : this.getKmsDataKeyReusePeriodSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public EncryptionConfiguration clone() {
        try {
            return (EncryptionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

