/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.stepfunctions.builder.StateMachine;
import com.amazonaws.services.stepfunctions.builder.StateMachineAdapter;
import com.amazonaws.services.stepfunctions.model.LoggingConfiguration;
import com.amazonaws.services.stepfunctions.model.StateMachineType;
import com.amazonaws.services.stepfunctions.model.Tag;
import com.amazonaws.services.stepfunctions.model.TracingConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateStateMachineRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String definition;
    private String roleArn;
    private String type;
    private LoggingConfiguration loggingConfiguration;
    private List<Tag> tags;
    private TracingConfiguration tracingConfiguration;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateStateMachineRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getDefinition() {
        return this.definition;
    }

    public CreateStateMachineRequest withDefinition(String definition) {
        this.setDefinition(definition);
        return this;
    }

    public void setDefinition(StateMachine definition) {
        this.setDefinition(new StateMachineAdapter().adapt(definition));
    }

    public CreateStateMachineRequest withDefinition(StateMachine definition) {
        this.setDefinition(new StateMachineAdapter().adapt(definition));
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateStateMachineRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateStateMachineRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateStateMachineRequest withType(StateMachineType type) {
        this.type = type.toString();
        return this;
    }

    public void setLoggingConfiguration(LoggingConfiguration loggingConfiguration) {
        this.loggingConfiguration = loggingConfiguration;
    }

    public LoggingConfiguration getLoggingConfiguration() {
        return this.loggingConfiguration;
    }

    public CreateStateMachineRequest withLoggingConfiguration(LoggingConfiguration loggingConfiguration) {
        this.setLoggingConfiguration(loggingConfiguration);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateStateMachineRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateStateMachineRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setTracingConfiguration(TracingConfiguration tracingConfiguration) {
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingConfiguration getTracingConfiguration() {
        return this.tracingConfiguration;
    }

    public CreateStateMachineRequest withTracingConfiguration(TracingConfiguration tracingConfiguration) {
        this.setTracingConfiguration(tracingConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDefinition() != null) {
            sb.append("Definition: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getLoggingConfiguration() != null) {
            sb.append("LoggingConfiguration: ").append(this.getLoggingConfiguration()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTracingConfiguration() != null) {
            sb.append("TracingConfiguration: ").append(this.getTracingConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStateMachineRequest)) {
            return false;
        }
        CreateStateMachineRequest other = (CreateStateMachineRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDefinition() == null ^ this.getDefinition() == null) {
            return false;
        }
        if (other.getDefinition() != null && !other.getDefinition().equals(this.getDefinition())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getLoggingConfiguration() == null ^ this.getLoggingConfiguration() == null) {
            return false;
        }
        if (other.getLoggingConfiguration() != null && !other.getLoggingConfiguration().equals(this.getLoggingConfiguration())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTracingConfiguration() == null ^ this.getTracingConfiguration() == null) {
            return false;
        }
        return other.getTracingConfiguration() == null || other.getTracingConfiguration().equals(this.getTracingConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDefinition() == null ? 0 : this.getDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getLoggingConfiguration() == null ? 0 : this.getLoggingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTracingConfiguration() == null ? 0 : this.getTracingConfiguration().hashCode());
        return hashCode;
    }

    public CreateStateMachineRequest clone() {
        return (CreateStateMachineRequest)super.clone();
    }
}

