/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ssoadmin;

import javax.annotation.Generated;

import com.amazonaws.services.ssoadmin.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSSSOAdmin}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSSSOAdmin implements AWSSSOAdmin {

    protected AbstractAWSSSOAdmin() {
    }

    @Override
    public AttachCustomerManagedPolicyReferenceToPermissionSetResult attachCustomerManagedPolicyReferenceToPermissionSet(
            AttachCustomerManagedPolicyReferenceToPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AttachManagedPolicyToPermissionSetResult attachManagedPolicyToPermissionSet(AttachManagedPolicyToPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAccountAssignmentResult createAccountAssignment(CreateAccountAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInstanceAccessControlAttributeConfigurationResult createInstanceAccessControlAttributeConfiguration(
            CreateInstanceAccessControlAttributeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePermissionSetResult createPermissionSet(CreatePermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccountAssignmentResult deleteAccountAssignment(DeleteAccountAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInlinePolicyFromPermissionSetResult deleteInlinePolicyFromPermissionSet(DeleteInlinePolicyFromPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInstanceAccessControlAttributeConfigurationResult deleteInstanceAccessControlAttributeConfiguration(
            DeleteInstanceAccessControlAttributeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePermissionSetResult deletePermissionSet(DeletePermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePermissionsBoundaryFromPermissionSetResult deletePermissionsBoundaryFromPermissionSet(DeletePermissionsBoundaryFromPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountAssignmentCreationStatusResult describeAccountAssignmentCreationStatus(DescribeAccountAssignmentCreationStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountAssignmentDeletionStatusResult describeAccountAssignmentDeletionStatus(DescribeAccountAssignmentDeletionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInstanceAccessControlAttributeConfigurationResult describeInstanceAccessControlAttributeConfiguration(
            DescribeInstanceAccessControlAttributeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePermissionSetResult describePermissionSet(DescribePermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePermissionSetProvisioningStatusResult describePermissionSetProvisioningStatus(DescribePermissionSetProvisioningStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachCustomerManagedPolicyReferenceFromPermissionSetResult detachCustomerManagedPolicyReferenceFromPermissionSet(
            DetachCustomerManagedPolicyReferenceFromPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachManagedPolicyFromPermissionSetResult detachManagedPolicyFromPermissionSet(DetachManagedPolicyFromPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInlinePolicyForPermissionSetResult getInlinePolicyForPermissionSet(GetInlinePolicyForPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPermissionsBoundaryForPermissionSetResult getPermissionsBoundaryForPermissionSet(GetPermissionsBoundaryForPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountAssignmentCreationStatusResult listAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountAssignmentDeletionStatusResult listAccountAssignmentDeletionStatus(ListAccountAssignmentDeletionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountAssignmentsResult listAccountAssignments(ListAccountAssignmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountsForProvisionedPermissionSetResult listAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCustomerManagedPolicyReferencesInPermissionSetResult listCustomerManagedPolicyReferencesInPermissionSet(
            ListCustomerManagedPolicyReferencesInPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInstancesResult listInstances(ListInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListManagedPoliciesInPermissionSetResult listManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPermissionSetProvisioningStatusResult listPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPermissionSetsResult listPermissionSets(ListPermissionSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPermissionSetsProvisionedToAccountResult listPermissionSetsProvisionedToAccount(ListPermissionSetsProvisionedToAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ProvisionPermissionSetResult provisionPermissionSet(ProvisionPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutInlinePolicyToPermissionSetResult putInlinePolicyToPermissionSet(PutInlinePolicyToPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutPermissionsBoundaryToPermissionSetResult putPermissionsBoundaryToPermissionSet(PutPermissionsBoundaryToPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInstanceAccessControlAttributeConfigurationResult updateInstanceAccessControlAttributeConfiguration(
            UpdateInstanceAccessControlAttributeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePermissionSetResult updatePermissionSet(UpdatePermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
