/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ssmsap.model.ApplicationCredential;
import com.amazonaws.services.ssmsap.model.ApplicationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegisterApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationId;
    private String applicationType;
    private List<String> instances;
    private String sapInstanceNumber;
    private String sid;
    private Map<String, String> tags;
    private List<ApplicationCredential> credentials;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public RegisterApplicationRequest withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public RegisterApplicationRequest withApplicationType(String applicationType) {
        this.setApplicationType(applicationType);
        return this;
    }

    public RegisterApplicationRequest withApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType.toString();
        return this;
    }

    public List<String> getInstances() {
        return this.instances;
    }

    public void setInstances(Collection<String> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new ArrayList<String>(instances);
    }

    public RegisterApplicationRequest withInstances(String ... instances) {
        if (this.instances == null) {
            this.setInstances(new ArrayList<String>(instances.length));
        }
        for (String ele : instances) {
            this.instances.add(ele);
        }
        return this;
    }

    public RegisterApplicationRequest withInstances(Collection<String> instances) {
        this.setInstances(instances);
        return this;
    }

    public void setSapInstanceNumber(String sapInstanceNumber) {
        this.sapInstanceNumber = sapInstanceNumber;
    }

    public String getSapInstanceNumber() {
        return this.sapInstanceNumber;
    }

    public RegisterApplicationRequest withSapInstanceNumber(String sapInstanceNumber) {
        this.setSapInstanceNumber(sapInstanceNumber);
        return this;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getSid() {
        return this.sid;
    }

    public RegisterApplicationRequest withSid(String sid) {
        this.setSid(sid);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public RegisterApplicationRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public RegisterApplicationRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public RegisterApplicationRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<ApplicationCredential> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Collection<ApplicationCredential> credentials) {
        if (credentials == null) {
            this.credentials = null;
            return;
        }
        this.credentials = new ArrayList<ApplicationCredential>(credentials);
    }

    public RegisterApplicationRequest withCredentials(ApplicationCredential ... credentials) {
        if (this.credentials == null) {
            this.setCredentials(new ArrayList<ApplicationCredential>(credentials.length));
        }
        for (ApplicationCredential ele : credentials) {
            this.credentials.add(ele);
        }
        return this;
    }

    public RegisterApplicationRequest withCredentials(Collection<ApplicationCredential> credentials) {
        this.setCredentials(credentials);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getApplicationType() != null) {
            sb.append("ApplicationType: ").append(this.getApplicationType()).append(",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getSapInstanceNumber() != null) {
            sb.append("SapInstanceNumber: ").append(this.getSapInstanceNumber()).append(",");
        }
        if (this.getSid() != null) {
            sb.append("Sid: ").append(this.getSid()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCredentials() != null) {
            sb.append("Credentials: ").append(this.getCredentials());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterApplicationRequest)) {
            return false;
        }
        RegisterApplicationRequest other = (RegisterApplicationRequest)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getApplicationType() == null ^ this.getApplicationType() == null) {
            return false;
        }
        if (other.getApplicationType() != null && !other.getApplicationType().equals(this.getApplicationType())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getSapInstanceNumber() == null ^ this.getSapInstanceNumber() == null) {
            return false;
        }
        if (other.getSapInstanceNumber() != null && !other.getSapInstanceNumber().equals(this.getSapInstanceNumber())) {
            return false;
        }
        if (other.getSid() == null ^ this.getSid() == null) {
            return false;
        }
        if (other.getSid() != null && !other.getSid().equals(this.getSid())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCredentials() == null ^ this.getCredentials() == null) {
            return false;
        }
        return other.getCredentials() == null || other.getCredentials().equals(this.getCredentials());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationType() == null ? 0 : this.getApplicationType().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getSapInstanceNumber() == null ? 0 : this.getSapInstanceNumber().hashCode());
        hashCode = 31 * hashCode + (this.getSid() == null ? 0 : this.getSid().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCredentials() == null ? 0 : this.getCredentials().hashCode());
        return hashCode;
    }

    public RegisterApplicationRequest clone() {
        return (RegisterApplicationRequest)super.clone();
    }
}

