/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmcontacts.model.Stage;
import com.amazonaws.services.ssmcontacts.model.transform.PlanMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Plan
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Stage> stages;
    private List<String> rotationIds;

    public List<Stage> getStages() {
        return this.stages;
    }

    public void setStages(Collection<Stage> stages) {
        if (stages == null) {
            this.stages = null;
            return;
        }
        this.stages = new ArrayList<Stage>(stages);
    }

    public Plan withStages(Stage ... stages) {
        if (this.stages == null) {
            this.setStages(new ArrayList<Stage>(stages.length));
        }
        for (Stage ele : stages) {
            this.stages.add(ele);
        }
        return this;
    }

    public Plan withStages(Collection<Stage> stages) {
        this.setStages(stages);
        return this;
    }

    public List<String> getRotationIds() {
        return this.rotationIds;
    }

    public void setRotationIds(Collection<String> rotationIds) {
        if (rotationIds == null) {
            this.rotationIds = null;
            return;
        }
        this.rotationIds = new ArrayList<String>(rotationIds);
    }

    public Plan withRotationIds(String ... rotationIds) {
        if (this.rotationIds == null) {
            this.setRotationIds(new ArrayList<String>(rotationIds.length));
        }
        for (String ele : rotationIds) {
            this.rotationIds.add(ele);
        }
        return this;
    }

    public Plan withRotationIds(Collection<String> rotationIds) {
        this.setRotationIds(rotationIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStages() != null) {
            sb.append("Stages: ").append(this.getStages()).append(",");
        }
        if (this.getRotationIds() != null) {
            sb.append("RotationIds: ").append(this.getRotationIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Plan)) {
            return false;
        }
        Plan other = (Plan)obj;
        if (other.getStages() == null ^ this.getStages() == null) {
            return false;
        }
        if (other.getStages() != null && !other.getStages().equals(this.getStages())) {
            return false;
        }
        if (other.getRotationIds() == null ^ this.getRotationIds() == null) {
            return false;
        }
        return other.getRotationIds() == null || other.getRotationIds().equals(this.getRotationIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStages() == null ? 0 : this.getStages().hashCode());
        hashCode = 31 * hashCode + (this.getRotationIds() == null ? 0 : this.getRotationIds().hashCode());
        return hashCode;
    }

    public Plan clone() {
        try {
            return (Plan)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PlanMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

