/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ssmcontacts.model.ContactType;
import com.amazonaws.services.ssmcontacts.model.Plan;
import com.amazonaws.services.ssmcontacts.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateContactRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String alias;
    private String displayName;
    private String type;
    private Plan plan;
    private List<Tag> tags;
    private String idempotencyToken;

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public CreateContactRequest withAlias(String alias) {
        this.setAlias(alias);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreateContactRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateContactRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateContactRequest withType(ContactType type) {
        this.type = type.toString();
        return this;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public CreateContactRequest withPlan(Plan plan) {
        this.setPlan(plan);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateContactRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateContactRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public CreateContactRequest withIdempotencyToken(String idempotencyToken) {
        this.setIdempotencyToken(idempotencyToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlias() != null) {
            sb.append("Alias: ").append(this.getAlias()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getPlan() != null) {
            sb.append("Plan: ").append(this.getPlan()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getIdempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.getIdempotencyToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactRequest)) {
            return false;
        }
        CreateContactRequest other = (CreateContactRequest)obj;
        if (other.getAlias() == null ^ this.getAlias() == null) {
            return false;
        }
        if (other.getAlias() != null && !other.getAlias().equals(this.getAlias())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getPlan() == null ^ this.getPlan() == null) {
            return false;
        }
        if (other.getPlan() != null && !other.getPlan().equals(this.getPlan())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null) {
            return false;
        }
        return other.getIdempotencyToken() == null || other.getIdempotencyToken().equals(this.getIdempotencyToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlias() == null ? 0 : this.getAlias().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getPlan() == null ? 0 : this.getPlan().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getIdempotencyToken() == null ? 0 : this.getIdempotencyToken().hashCode());
        return hashCode;
    }

    public CreateContactRequest clone() {
        return (CreateContactRequest)super.clone();
    }
}

