/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.OperatingSystem;
import com.amazonaws.services.simplesystemsmanagement.model.PatchAction;
import com.amazonaws.services.simplesystemsmanagement.model.PatchComplianceLevel;
import com.amazonaws.services.simplesystemsmanagement.model.PatchFilterGroup;
import com.amazonaws.services.simplesystemsmanagement.model.PatchRuleGroup;
import com.amazonaws.services.simplesystemsmanagement.model.PatchSource;
import com.amazonaws.services.simplesystemsmanagement.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreatePatchBaselineRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String operatingSystem;
    private String name;
    private PatchFilterGroup globalFilters;
    private PatchRuleGroup approvalRules;
    private SdkInternalList<String> approvedPatches;
    private String approvedPatchesComplianceLevel;
    private Boolean approvedPatchesEnableNonSecurity;
    private SdkInternalList<String> rejectedPatches;
    private String rejectedPatchesAction;
    private String description;
    private SdkInternalList<PatchSource> sources;
    private String clientToken;
    private SdkInternalList<Tag> tags;

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public CreatePatchBaselineRequest withOperatingSystem(String operatingSystem) {
        this.setOperatingSystem(operatingSystem);
        return this;
    }

    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.withOperatingSystem(operatingSystem);
    }

    public CreatePatchBaselineRequest withOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreatePatchBaselineRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setGlobalFilters(PatchFilterGroup globalFilters) {
        this.globalFilters = globalFilters;
    }

    public PatchFilterGroup getGlobalFilters() {
        return this.globalFilters;
    }

    public CreatePatchBaselineRequest withGlobalFilters(PatchFilterGroup globalFilters) {
        this.setGlobalFilters(globalFilters);
        return this;
    }

    public void setApprovalRules(PatchRuleGroup approvalRules) {
        this.approvalRules = approvalRules;
    }

    public PatchRuleGroup getApprovalRules() {
        return this.approvalRules;
    }

    public CreatePatchBaselineRequest withApprovalRules(PatchRuleGroup approvalRules) {
        this.setApprovalRules(approvalRules);
        return this;
    }

    public List<String> getApprovedPatches() {
        if (this.approvedPatches == null) {
            this.approvedPatches = new SdkInternalList();
        }
        return this.approvedPatches;
    }

    public void setApprovedPatches(Collection<String> approvedPatches) {
        if (approvedPatches == null) {
            this.approvedPatches = null;
            return;
        }
        this.approvedPatches = new SdkInternalList(approvedPatches);
    }

    public CreatePatchBaselineRequest withApprovedPatches(String ... approvedPatches) {
        if (this.approvedPatches == null) {
            this.setApprovedPatches((Collection<String>)new SdkInternalList(approvedPatches.length));
        }
        for (String ele : approvedPatches) {
            this.approvedPatches.add((Object)ele);
        }
        return this;
    }

    public CreatePatchBaselineRequest withApprovedPatches(Collection<String> approvedPatches) {
        this.setApprovedPatches(approvedPatches);
        return this;
    }

    public void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
        this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
    }

    public String getApprovedPatchesComplianceLevel() {
        return this.approvedPatchesComplianceLevel;
    }

    public CreatePatchBaselineRequest withApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
        this.setApprovedPatchesComplianceLevel(approvedPatchesComplianceLevel);
        return this;
    }

    public void setApprovedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
        this.withApprovedPatchesComplianceLevel(approvedPatchesComplianceLevel);
    }

    public CreatePatchBaselineRequest withApprovedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
        this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel.toString();
        return this;
    }

    public void setApprovedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
        this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
    }

    public Boolean getApprovedPatchesEnableNonSecurity() {
        return this.approvedPatchesEnableNonSecurity;
    }

    public CreatePatchBaselineRequest withApprovedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
        this.setApprovedPatchesEnableNonSecurity(approvedPatchesEnableNonSecurity);
        return this;
    }

    public Boolean isApprovedPatchesEnableNonSecurity() {
        return this.approvedPatchesEnableNonSecurity;
    }

    public List<String> getRejectedPatches() {
        if (this.rejectedPatches == null) {
            this.rejectedPatches = new SdkInternalList();
        }
        return this.rejectedPatches;
    }

    public void setRejectedPatches(Collection<String> rejectedPatches) {
        if (rejectedPatches == null) {
            this.rejectedPatches = null;
            return;
        }
        this.rejectedPatches = new SdkInternalList(rejectedPatches);
    }

    public CreatePatchBaselineRequest withRejectedPatches(String ... rejectedPatches) {
        if (this.rejectedPatches == null) {
            this.setRejectedPatches((Collection<String>)new SdkInternalList(rejectedPatches.length));
        }
        for (String ele : rejectedPatches) {
            this.rejectedPatches.add((Object)ele);
        }
        return this;
    }

    public CreatePatchBaselineRequest withRejectedPatches(Collection<String> rejectedPatches) {
        this.setRejectedPatches(rejectedPatches);
        return this;
    }

    public void setRejectedPatchesAction(String rejectedPatchesAction) {
        this.rejectedPatchesAction = rejectedPatchesAction;
    }

    public String getRejectedPatchesAction() {
        return this.rejectedPatchesAction;
    }

    public CreatePatchBaselineRequest withRejectedPatchesAction(String rejectedPatchesAction) {
        this.setRejectedPatchesAction(rejectedPatchesAction);
        return this;
    }

    public void setRejectedPatchesAction(PatchAction rejectedPatchesAction) {
        this.withRejectedPatchesAction(rejectedPatchesAction);
    }

    public CreatePatchBaselineRequest withRejectedPatchesAction(PatchAction rejectedPatchesAction) {
        this.rejectedPatchesAction = rejectedPatchesAction.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreatePatchBaselineRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<PatchSource> getSources() {
        if (this.sources == null) {
            this.sources = new SdkInternalList();
        }
        return this.sources;
    }

    public void setSources(Collection<PatchSource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new SdkInternalList(sources);
    }

    public CreatePatchBaselineRequest withSources(PatchSource ... sources) {
        if (this.sources == null) {
            this.setSources((Collection<PatchSource>)new SdkInternalList(sources.length));
        }
        for (PatchSource ele : sources) {
            this.sources.add((Object)ele);
        }
        return this;
    }

    public CreatePatchBaselineRequest withSources(Collection<PatchSource> sources) {
        this.setSources(sources);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreatePatchBaselineRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreatePatchBaselineRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreatePatchBaselineRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOperatingSystem() != null) {
            sb.append("OperatingSystem: ").append(this.getOperatingSystem()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getGlobalFilters() != null) {
            sb.append("GlobalFilters: ").append(this.getGlobalFilters()).append(",");
        }
        if (this.getApprovalRules() != null) {
            sb.append("ApprovalRules: ").append(this.getApprovalRules()).append(",");
        }
        if (this.getApprovedPatches() != null) {
            sb.append("ApprovedPatches: ").append(this.getApprovedPatches()).append(",");
        }
        if (this.getApprovedPatchesComplianceLevel() != null) {
            sb.append("ApprovedPatchesComplianceLevel: ").append(this.getApprovedPatchesComplianceLevel()).append(",");
        }
        if (this.getApprovedPatchesEnableNonSecurity() != null) {
            sb.append("ApprovedPatchesEnableNonSecurity: ").append(this.getApprovedPatchesEnableNonSecurity()).append(",");
        }
        if (this.getRejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(this.getRejectedPatches()).append(",");
        }
        if (this.getRejectedPatchesAction() != null) {
            sb.append("RejectedPatchesAction: ").append(this.getRejectedPatchesAction()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePatchBaselineRequest)) {
            return false;
        }
        CreatePatchBaselineRequest other = (CreatePatchBaselineRequest)obj;
        if (other.getOperatingSystem() == null ^ this.getOperatingSystem() == null) {
            return false;
        }
        if (other.getOperatingSystem() != null && !other.getOperatingSystem().equals(this.getOperatingSystem())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getGlobalFilters() == null ^ this.getGlobalFilters() == null) {
            return false;
        }
        if (other.getGlobalFilters() != null && !other.getGlobalFilters().equals(this.getGlobalFilters())) {
            return false;
        }
        if (other.getApprovalRules() == null ^ this.getApprovalRules() == null) {
            return false;
        }
        if (other.getApprovalRules() != null && !other.getApprovalRules().equals(this.getApprovalRules())) {
            return false;
        }
        if (other.getApprovedPatches() == null ^ this.getApprovedPatches() == null) {
            return false;
        }
        if (other.getApprovedPatches() != null && !other.getApprovedPatches().equals(this.getApprovedPatches())) {
            return false;
        }
        if (other.getApprovedPatchesComplianceLevel() == null ^ this.getApprovedPatchesComplianceLevel() == null) {
            return false;
        }
        if (other.getApprovedPatchesComplianceLevel() != null && !other.getApprovedPatchesComplianceLevel().equals(this.getApprovedPatchesComplianceLevel())) {
            return false;
        }
        if (other.getApprovedPatchesEnableNonSecurity() == null ^ this.getApprovedPatchesEnableNonSecurity() == null) {
            return false;
        }
        if (other.getApprovedPatchesEnableNonSecurity() != null && !other.getApprovedPatchesEnableNonSecurity().equals(this.getApprovedPatchesEnableNonSecurity())) {
            return false;
        }
        if (other.getRejectedPatches() == null ^ this.getRejectedPatches() == null) {
            return false;
        }
        if (other.getRejectedPatches() != null && !other.getRejectedPatches().equals(this.getRejectedPatches())) {
            return false;
        }
        if (other.getRejectedPatchesAction() == null ^ this.getRejectedPatchesAction() == null) {
            return false;
        }
        if (other.getRejectedPatchesAction() != null && !other.getRejectedPatchesAction().equals(this.getRejectedPatchesAction())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOperatingSystem() == null ? 0 : this.getOperatingSystem().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalFilters() == null ? 0 : this.getGlobalFilters().hashCode());
        hashCode = 31 * hashCode + (this.getApprovalRules() == null ? 0 : this.getApprovalRules().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatches() == null ? 0 : this.getApprovedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatchesComplianceLevel() == null ? 0 : this.getApprovedPatchesComplianceLevel().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatchesEnableNonSecurity() == null ? 0 : this.getApprovedPatchesEnableNonSecurity().hashCode());
        hashCode = 31 * hashCode + (this.getRejectedPatches() == null ? 0 : this.getRejectedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getRejectedPatchesAction() == null ? 0 : this.getRejectedPatchesAction().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreatePatchBaselineRequest clone() {
        return (CreatePatchBaselineRequest)super.clone();
    }
}

