/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.Signer;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQSClientConfigurationFactory;
import com.amazonaws.services.sqs.internal.auth.SQSSignerProvider;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.AddPermissionResult;
import com.amazonaws.services.sqs.model.AmazonSQSException;
import com.amazonaws.services.sqs.model.CancelMessageMoveTaskRequest;
import com.amazonaws.services.sqs.model.CancelMessageMoveTaskResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityResult;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.DeleteQueueResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesResult;
import com.amazonaws.services.sqs.model.ListMessageMoveTasksRequest;
import com.amazonaws.services.sqs.model.ListMessageMoveTasksResult;
import com.amazonaws.services.sqs.model.ListQueueTagsRequest;
import com.amazonaws.services.sqs.model.ListQueueTagsResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.PurgeQueueResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.services.sqs.model.RemovePermissionResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesResult;
import com.amazonaws.services.sqs.model.StartMessageMoveTaskRequest;
import com.amazonaws.services.sqs.model.StartMessageMoveTaskResult;
import com.amazonaws.services.sqs.model.TagQueueRequest;
import com.amazonaws.services.sqs.model.TagQueueResult;
import com.amazonaws.services.sqs.model.UntagQueueRequest;
import com.amazonaws.services.sqs.model.UntagQueueResult;
import com.amazonaws.services.sqs.model.transform.AddPermissionRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.AddPermissionResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.BatchEntryIdsNotDistinctExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.BatchRequestTooLongExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.CancelMessageMoveTaskRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.CancelMessageMoveTaskResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ChangeMessageVisibilityBatchRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.ChangeMessageVisibilityBatchResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ChangeMessageVisibilityRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.ChangeMessageVisibilityResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.CreateQueueRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.CreateQueueResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteMessageBatchRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteMessageBatchResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteMessageRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteMessageResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteQueueRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteQueueResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.EmptyBatchRequestExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueAttributesRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueAttributesResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueUrlRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueUrlResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidAddressExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidAttributeNameExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidAttributeValueExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidBatchEntryIdExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidIdFormatExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidMessageContentsExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidSecurityExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.KmsAccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.KmsDisabledExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.KmsInvalidKeyUsageExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.KmsInvalidStateExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.KmsNotFoundExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.KmsOptInRequiredExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.KmsThrottledExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ListDeadLetterSourceQueuesRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.ListDeadLetterSourceQueuesResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ListMessageMoveTasksRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.ListMessageMoveTasksResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ListQueueTagsRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.ListQueueTagsResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ListQueuesRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.ListQueuesResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.MessageNotInflightExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.OverLimitExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.PurgeQueueInProgressExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.PurgeQueueRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.PurgeQueueResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.QueueDeletedRecentlyExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.QueueDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.QueueNameExistsExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ReceiptHandleIsInvalidExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ReceiveMessageRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.ReceiveMessageResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.RemovePermissionRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.RemovePermissionResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.RequestThrottledExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageBatchRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageBatchResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.SetQueueAttributesRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.SetQueueAttributesResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.StartMessageMoveTaskRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.StartMessageMoveTaskResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.TagQueueRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.TagQueueResultJsonUnmarshaller;
import com.amazonaws.services.sqs.model.transform.TooManyEntriesInBatchRequestExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.UnsupportedOperationExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.UntagQueueRequestProtocolMarshaller;
import com.amazonaws.services.sqs.model.transform.UntagQueueResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonSQSClient
extends AmazonWebServiceClient
implements AmazonSQS {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSQS.class);
    private static final String DEFAULT_SIGNING_NAME = "sqs";
    protected static final AmazonSQSClientConfigurationFactory configFactory = new AmazonSQSClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).withAwsQueryCompatible(true).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PurgeQueueInProgress").withExceptionUnmarshaller((JsonErrorUnmarshaller)PurgeQueueInProgressExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsInvalidKeyUsage").withExceptionUnmarshaller((JsonErrorUnmarshaller)KmsInvalidKeyUsageExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidAttributeName").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidAttributeNameExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestThrottled").withExceptionUnmarshaller((JsonErrorUnmarshaller)RequestThrottledExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BatchEntryIdsNotDistinct").withExceptionUnmarshaller((JsonErrorUnmarshaller)BatchEntryIdsNotDistinctExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyEntriesInBatchRequest").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyEntriesInBatchRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BatchRequestTooLong").withExceptionUnmarshaller((JsonErrorUnmarshaller)BatchRequestTooLongExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedOperation").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedOperationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsInvalidState").withExceptionUnmarshaller((JsonErrorUnmarshaller)KmsInvalidStateExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidIdFormat").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidIdFormatExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsNotFound").withExceptionUnmarshaller((JsonErrorUnmarshaller)KmsNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsThrottled").withExceptionUnmarshaller((JsonErrorUnmarshaller)KmsThrottledExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsOptInRequired").withExceptionUnmarshaller((JsonErrorUnmarshaller)KmsOptInRequiredExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsAccessDenied").withExceptionUnmarshaller((JsonErrorUnmarshaller)KmsAccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OverLimit").withExceptionUnmarshaller((JsonErrorUnmarshaller)OverLimitExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("QueueDoesNotExist").withExceptionUnmarshaller((JsonErrorUnmarshaller)QueueDoesNotExistExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsDisabled").withExceptionUnmarshaller((JsonErrorUnmarshaller)KmsDisabledExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("QueueNameExists").withExceptionUnmarshaller((JsonErrorUnmarshaller)QueueNameExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MessageNotInflight").withExceptionUnmarshaller((JsonErrorUnmarshaller)MessageNotInflightExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ReceiptHandleIsInvalid").withExceptionUnmarshaller((JsonErrorUnmarshaller)ReceiptHandleIsInvalidExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidAttributeValue").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidAttributeValueExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidMessageContents").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidMessageContentsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("QueueDeletedRecently").withExceptionUnmarshaller((JsonErrorUnmarshaller)QueueDeletedRecentlyExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EmptyBatchRequest").withExceptionUnmarshaller((JsonErrorUnmarshaller)EmptyBatchRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSecurity").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidSecurityExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidAddress").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidAddressExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidBatchEntryId").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidBatchEntryIdExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonSQSException.class));

    @Deprecated
    public AmazonSQSClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonSQSClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonSQSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonSQSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AmazonSQSClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonSQSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonSQSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AmazonSQSClientBuilder builder() {
        return AmazonSQSClientBuilder.standard();
    }

    AmazonSQSClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonSQSClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://sqs.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/sqs/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/sqs/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AddPermissionResult addPermission(AddPermissionRequest request) {
        request = (AddPermissionRequest)this.beforeClientExecution(request);
        return this.executeAddPermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddPermissionResult executeAddPermission(AddPermissionRequest addPermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addPermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddPermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddPermissionRequestProtocolMarshaller(protocolFactory).marshall((AddPermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)addPermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddPermission");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddPermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddPermissionResult addPermissionResult = (AddPermissionResult)response.getAwsResponse();
            return addPermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AddPermissionResult addPermission(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions) {
        return this.addPermission(new AddPermissionRequest().withQueueUrl(queueUrl).withLabel(label).withAWSAccountIds(aWSAccountIds).withActions(actions));
    }

    @Override
    public CancelMessageMoveTaskResult cancelMessageMoveTask(CancelMessageMoveTaskRequest request) {
        request = (CancelMessageMoveTaskRequest)this.beforeClientExecution(request);
        return this.executeCancelMessageMoveTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelMessageMoveTaskResult executeCancelMessageMoveTask(CancelMessageMoveTaskRequest cancelMessageMoveTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelMessageMoveTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelMessageMoveTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelMessageMoveTaskRequestProtocolMarshaller(protocolFactory).marshall((CancelMessageMoveTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelMessageMoveTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelMessageMoveTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelMessageMoveTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelMessageMoveTaskResult cancelMessageMoveTaskResult = (CancelMessageMoveTaskResult)response.getAwsResponse();
            return cancelMessageMoveTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ChangeMessageVisibilityResult changeMessageVisibility(ChangeMessageVisibilityRequest request) {
        request = (ChangeMessageVisibilityRequest)this.beforeClientExecution(request);
        return this.executeChangeMessageVisibility(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ChangeMessageVisibilityResult executeChangeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(changeMessageVisibilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ChangeMessageVisibilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ChangeMessageVisibilityRequestProtocolMarshaller(protocolFactory).marshall((ChangeMessageVisibilityRequest)super.beforeMarshalling((AmazonWebServiceRequest)changeMessageVisibilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ChangeMessageVisibility");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ChangeMessageVisibilityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ChangeMessageVisibilityResult changeMessageVisibilityResult = (ChangeMessageVisibilityResult)response.getAwsResponse();
            return changeMessageVisibilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ChangeMessageVisibilityResult changeMessageVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout) {
        return this.changeMessageVisibility(new ChangeMessageVisibilityRequest().withQueueUrl(queueUrl).withReceiptHandle(receiptHandle).withVisibilityTimeout(visibilityTimeout));
    }

    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest request) {
        request = (ChangeMessageVisibilityBatchRequest)this.beforeClientExecution(request);
        return this.executeChangeMessageVisibilityBatch(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ChangeMessageVisibilityBatchResult executeChangeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(changeMessageVisibilityBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ChangeMessageVisibilityBatchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ChangeMessageVisibilityBatchRequestProtocolMarshaller(protocolFactory).marshall((ChangeMessageVisibilityBatchRequest)super.beforeMarshalling((AmazonWebServiceRequest)changeMessageVisibilityBatchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ChangeMessageVisibilityBatch");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ChangeMessageVisibilityBatchResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ChangeMessageVisibilityBatchResult changeMessageVisibilityBatchResult = (ChangeMessageVisibilityBatchResult)response.getAwsResponse();
            return changeMessageVisibilityBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries) {
        return this.changeMessageVisibilityBatch(new ChangeMessageVisibilityBatchRequest().withQueueUrl(queueUrl).withEntries(entries));
    }

    @Override
    public CreateQueueResult createQueue(CreateQueueRequest request) {
        request = (CreateQueueRequest)this.beforeClientExecution(request);
        return this.executeCreateQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateQueueResult executeCreateQueue(CreateQueueRequest createQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateQueueRequestProtocolMarshaller(protocolFactory).marshall((CreateQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)createQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateQueue");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateQueueResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateQueueResult createQueueResult = (CreateQueueResult)response.getAwsResponse();
            return createQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateQueueResult createQueue(String queueName) {
        return this.createQueue(new CreateQueueRequest().withQueueName(queueName));
    }

    @Override
    public DeleteMessageResult deleteMessage(DeleteMessageRequest request) {
        request = (DeleteMessageRequest)this.beforeClientExecution(request);
        return this.executeDeleteMessage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMessageResult executeDeleteMessage(DeleteMessageRequest deleteMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMessageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMessageRequestProtocolMarshaller(protocolFactory).marshall((DeleteMessageRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMessageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMessage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMessageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMessageResult deleteMessageResult = (DeleteMessageResult)response.getAwsResponse();
            return deleteMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMessageResult deleteMessage(String queueUrl, String receiptHandle) {
        return this.deleteMessage(new DeleteMessageRequest().withQueueUrl(queueUrl).withReceiptHandle(receiptHandle));
    }

    @Override
    public DeleteMessageBatchResult deleteMessageBatch(DeleteMessageBatchRequest request) {
        request = (DeleteMessageBatchRequest)this.beforeClientExecution(request);
        return this.executeDeleteMessageBatch(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMessageBatchResult executeDeleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMessageBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMessageBatchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMessageBatchRequestProtocolMarshaller(protocolFactory).marshall((DeleteMessageBatchRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMessageBatchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMessageBatch");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMessageBatchResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMessageBatchResult deleteMessageBatchResult = (DeleteMessageBatchResult)response.getAwsResponse();
            return deleteMessageBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMessageBatchResult deleteMessageBatch(String queueUrl, List<DeleteMessageBatchRequestEntry> entries) {
        return this.deleteMessageBatch(new DeleteMessageBatchRequest().withQueueUrl(queueUrl).withEntries(entries));
    }

    @Override
    public DeleteQueueResult deleteQueue(DeleteQueueRequest request) {
        request = (DeleteQueueRequest)this.beforeClientExecution(request);
        return this.executeDeleteQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteQueueResult executeDeleteQueue(DeleteQueueRequest deleteQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteQueueRequestProtocolMarshaller(protocolFactory).marshall((DeleteQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteQueue");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteQueueResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteQueueResult deleteQueueResult = (DeleteQueueResult)response.getAwsResponse();
            return deleteQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteQueueResult deleteQueue(String queueUrl) {
        return this.deleteQueue(new DeleteQueueRequest().withQueueUrl(queueUrl));
    }

    @Override
    public GetQueueAttributesResult getQueueAttributes(GetQueueAttributesRequest request) {
        request = (GetQueueAttributesRequest)this.beforeClientExecution(request);
        return this.executeGetQueueAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetQueueAttributesResult executeGetQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQueueAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetQueueAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetQueueAttributesRequestProtocolMarshaller(protocolFactory).marshall((GetQueueAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getQueueAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetQueueAttributes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQueueAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetQueueAttributesResult getQueueAttributesResult = (GetQueueAttributesResult)response.getAwsResponse();
            return getQueueAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetQueueAttributesResult getQueueAttributes(String queueUrl, List<String> attributeNames) {
        return this.getQueueAttributes(new GetQueueAttributesRequest().withQueueUrl(queueUrl).withAttributeNames(attributeNames));
    }

    @Override
    public GetQueueUrlResult getQueueUrl(GetQueueUrlRequest request) {
        request = (GetQueueUrlRequest)this.beforeClientExecution(request);
        return this.executeGetQueueUrl(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetQueueUrlResult executeGetQueueUrl(GetQueueUrlRequest getQueueUrlRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQueueUrlRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetQueueUrlRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetQueueUrlRequestProtocolMarshaller(protocolFactory).marshall((GetQueueUrlRequest)super.beforeMarshalling((AmazonWebServiceRequest)getQueueUrlRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetQueueUrl");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQueueUrlResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetQueueUrlResult getQueueUrlResult = (GetQueueUrlResult)response.getAwsResponse();
            return getQueueUrlResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetQueueUrlResult getQueueUrl(String queueName) {
        return this.getQueueUrl(new GetQueueUrlRequest().withQueueName(queueName));
    }

    @Override
    public ListDeadLetterSourceQueuesResult listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest request) {
        request = (ListDeadLetterSourceQueuesRequest)this.beforeClientExecution(request);
        return this.executeListDeadLetterSourceQueues(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDeadLetterSourceQueuesResult executeListDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDeadLetterSourceQueuesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDeadLetterSourceQueuesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDeadLetterSourceQueuesRequestProtocolMarshaller(protocolFactory).marshall((ListDeadLetterSourceQueuesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDeadLetterSourceQueuesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDeadLetterSourceQueues");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDeadLetterSourceQueuesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDeadLetterSourceQueuesResult listDeadLetterSourceQueuesResult = (ListDeadLetterSourceQueuesResult)response.getAwsResponse();
            return listDeadLetterSourceQueuesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMessageMoveTasksResult listMessageMoveTasks(ListMessageMoveTasksRequest request) {
        request = (ListMessageMoveTasksRequest)this.beforeClientExecution(request);
        return this.executeListMessageMoveTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMessageMoveTasksResult executeListMessageMoveTasks(ListMessageMoveTasksRequest listMessageMoveTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMessageMoveTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMessageMoveTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMessageMoveTasksRequestProtocolMarshaller(protocolFactory).marshall((ListMessageMoveTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMessageMoveTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMessageMoveTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMessageMoveTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMessageMoveTasksResult listMessageMoveTasksResult = (ListMessageMoveTasksResult)response.getAwsResponse();
            return listMessageMoveTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListQueueTagsResult listQueueTags(ListQueueTagsRequest request) {
        request = (ListQueueTagsRequest)this.beforeClientExecution(request);
        return this.executeListQueueTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListQueueTagsResult executeListQueueTags(ListQueueTagsRequest listQueueTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listQueueTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListQueueTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListQueueTagsRequestProtocolMarshaller(protocolFactory).marshall((ListQueueTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listQueueTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListQueueTags");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListQueueTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListQueueTagsResult listQueueTagsResult = (ListQueueTagsResult)response.getAwsResponse();
            return listQueueTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListQueueTagsResult listQueueTags(String queueUrl) {
        return this.listQueueTags(new ListQueueTagsRequest().withQueueUrl(queueUrl));
    }

    @Override
    public ListQueuesResult listQueues(ListQueuesRequest request) {
        request = (ListQueuesRequest)this.beforeClientExecution(request);
        return this.executeListQueues(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListQueuesResult executeListQueues(ListQueuesRequest listQueuesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listQueuesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListQueuesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListQueuesRequestProtocolMarshaller(protocolFactory).marshall((ListQueuesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listQueuesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListQueues");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListQueuesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListQueuesResult listQueuesResult = (ListQueuesResult)response.getAwsResponse();
            return listQueuesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListQueuesResult listQueues() {
        return this.listQueues(new ListQueuesRequest());
    }

    @Override
    public ListQueuesResult listQueues(String queueNamePrefix) {
        return this.listQueues(new ListQueuesRequest().withQueueNamePrefix(queueNamePrefix));
    }

    @Override
    public PurgeQueueResult purgeQueue(PurgeQueueRequest request) {
        request = (PurgeQueueRequest)this.beforeClientExecution(request);
        return this.executePurgeQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PurgeQueueResult executePurgeQueue(PurgeQueueRequest purgeQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(purgeQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PurgeQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PurgeQueueRequestProtocolMarshaller(protocolFactory).marshall((PurgeQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)purgeQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PurgeQueue");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PurgeQueueResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PurgeQueueResult purgeQueueResult = (PurgeQueueResult)response.getAwsResponse();
            return purgeQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest request) {
        request = (ReceiveMessageRequest)this.beforeClientExecution(request);
        return this.executeReceiveMessage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ReceiveMessageResult executeReceiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(receiveMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReceiveMessageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReceiveMessageRequestProtocolMarshaller(protocolFactory).marshall((ReceiveMessageRequest)super.beforeMarshalling((AmazonWebServiceRequest)receiveMessageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ReceiveMessage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ReceiveMessageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ReceiveMessageResult receiveMessageResult = (ReceiveMessageResult)response.getAwsResponse();
            return receiveMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ReceiveMessageResult receiveMessage(String queueUrl) {
        return this.receiveMessage(new ReceiveMessageRequest().withQueueUrl(queueUrl));
    }

    @Override
    public RemovePermissionResult removePermission(RemovePermissionRequest request) {
        request = (RemovePermissionRequest)this.beforeClientExecution(request);
        return this.executeRemovePermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemovePermissionResult executeRemovePermission(RemovePermissionRequest removePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemovePermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemovePermissionRequestProtocolMarshaller(protocolFactory).marshall((RemovePermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)removePermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RemovePermission");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemovePermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemovePermissionResult removePermissionResult = (RemovePermissionResult)response.getAwsResponse();
            return removePermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemovePermissionResult removePermission(String queueUrl, String label) {
        return this.removePermission(new RemovePermissionRequest().withQueueUrl(queueUrl).withLabel(label));
    }

    @Override
    public SendMessageResult sendMessage(SendMessageRequest request) {
        request = (SendMessageRequest)this.beforeClientExecution(request);
        return this.executeSendMessage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SendMessageResult executeSendMessage(SendMessageRequest sendMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendMessageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendMessageRequestProtocolMarshaller(protocolFactory).marshall((SendMessageRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendMessageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SendMessage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendMessageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SendMessageResult sendMessageResult = (SendMessageResult)response.getAwsResponse();
            return sendMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SendMessageResult sendMessage(String queueUrl, String messageBody) {
        return this.sendMessage(new SendMessageRequest().withQueueUrl(queueUrl).withMessageBody(messageBody));
    }

    @Override
    public SendMessageBatchResult sendMessageBatch(SendMessageBatchRequest request) {
        request = (SendMessageBatchRequest)this.beforeClientExecution(request);
        return this.executeSendMessageBatch(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SendMessageBatchResult executeSendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendMessageBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendMessageBatchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendMessageBatchRequestProtocolMarshaller(protocolFactory).marshall((SendMessageBatchRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendMessageBatchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SendMessageBatch");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendMessageBatchResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SendMessageBatchResult sendMessageBatchResult = (SendMessageBatchResult)response.getAwsResponse();
            return sendMessageBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SendMessageBatchResult sendMessageBatch(String queueUrl, List<SendMessageBatchRequestEntry> entries) {
        return this.sendMessageBatch(new SendMessageBatchRequest().withQueueUrl(queueUrl).withEntries(entries));
    }

    @Override
    public SetQueueAttributesResult setQueueAttributes(SetQueueAttributesRequest request) {
        request = (SetQueueAttributesRequest)this.beforeClientExecution(request);
        return this.executeSetQueueAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SetQueueAttributesResult executeSetQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setQueueAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetQueueAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetQueueAttributesRequestProtocolMarshaller(protocolFactory).marshall((SetQueueAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)setQueueAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SetQueueAttributes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetQueueAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetQueueAttributesResult setQueueAttributesResult = (SetQueueAttributesResult)response.getAwsResponse();
            return setQueueAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SetQueueAttributesResult setQueueAttributes(String queueUrl, Map<String, String> attributes) {
        return this.setQueueAttributes(new SetQueueAttributesRequest().withQueueUrl(queueUrl).withAttributes(attributes));
    }

    @Override
    public StartMessageMoveTaskResult startMessageMoveTask(StartMessageMoveTaskRequest request) {
        request = (StartMessageMoveTaskRequest)this.beforeClientExecution(request);
        return this.executeStartMessageMoveTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartMessageMoveTaskResult executeStartMessageMoveTask(StartMessageMoveTaskRequest startMessageMoveTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startMessageMoveTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartMessageMoveTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartMessageMoveTaskRequestProtocolMarshaller(protocolFactory).marshall((StartMessageMoveTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)startMessageMoveTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartMessageMoveTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartMessageMoveTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartMessageMoveTaskResult startMessageMoveTaskResult = (StartMessageMoveTaskResult)response.getAwsResponse();
            return startMessageMoveTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagQueueResult tagQueue(TagQueueRequest request) {
        request = (TagQueueRequest)this.beforeClientExecution(request);
        return this.executeTagQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagQueueResult executeTagQueue(TagQueueRequest tagQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagQueueRequestProtocolMarshaller(protocolFactory).marshall((TagQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagQueue");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagQueueResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagQueueResult tagQueueResult = (TagQueueResult)response.getAwsResponse();
            return tagQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagQueueResult tagQueue(String queueUrl, Map<String, String> tags) {
        return this.tagQueue(new TagQueueRequest().withQueueUrl(queueUrl).withTags(tags));
    }

    @Override
    public UntagQueueResult untagQueue(UntagQueueRequest request) {
        request = (UntagQueueRequest)this.beforeClientExecution(request);
        return this.executeUntagQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagQueueResult executeUntagQueue(UntagQueueRequest untagQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagQueueRequestProtocolMarshaller(protocolFactory).marshall((UntagQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagQueue");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagQueueResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagQueueResult untagQueueResult = (UntagQueueResult)response.getAwsResponse();
            return untagQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagQueueResult untagQueue(String queueUrl, List<String> tagKeys) {
        return this.untagQueue(new UntagQueueRequest().withQueueUrl(queueUrl).withTagKeys(tagKeys));
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    protected final SignerProvider createSignerProvider(Signer signer) {
        return new SQSSignerProvider(this, signer);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata().withAwsQueryCompatible(Boolean.valueOf(true)));
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

