/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sqs.model.transform.MessageAttributeValueMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public class MessageAttributeValue
implements Serializable,
Cloneable,
StructuredPojo {
    private String stringValue;
    private ByteBuffer binaryValue;
    private SdkInternalList<String> stringListValues;
    private SdkInternalList<ByteBuffer> binaryListValues;
    private String dataType;

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public MessageAttributeValue withStringValue(String stringValue) {
        this.setStringValue(stringValue);
        return this;
    }

    public void setBinaryValue(ByteBuffer binaryValue) {
        this.binaryValue = binaryValue;
    }

    public ByteBuffer getBinaryValue() {
        return this.binaryValue;
    }

    public MessageAttributeValue withBinaryValue(ByteBuffer binaryValue) {
        this.setBinaryValue(binaryValue);
        return this;
    }

    public List<String> getStringListValues() {
        if (this.stringListValues == null) {
            this.stringListValues = new SdkInternalList();
        }
        return this.stringListValues;
    }

    public void setStringListValues(Collection<String> stringListValues) {
        if (stringListValues == null) {
            this.stringListValues = null;
            return;
        }
        this.stringListValues = new SdkInternalList(stringListValues);
    }

    public MessageAttributeValue withStringListValues(String ... stringListValues) {
        if (this.stringListValues == null) {
            this.setStringListValues((Collection<String>)new SdkInternalList(stringListValues.length));
        }
        for (String ele : stringListValues) {
            this.stringListValues.add((Object)ele);
        }
        return this;
    }

    public MessageAttributeValue withStringListValues(Collection<String> stringListValues) {
        this.setStringListValues(stringListValues);
        return this;
    }

    public List<ByteBuffer> getBinaryListValues() {
        if (this.binaryListValues == null) {
            this.binaryListValues = new SdkInternalList();
        }
        return this.binaryListValues;
    }

    public void setBinaryListValues(Collection<ByteBuffer> binaryListValues) {
        if (binaryListValues == null) {
            this.binaryListValues = null;
            return;
        }
        this.binaryListValues = new SdkInternalList(binaryListValues);
    }

    public MessageAttributeValue withBinaryListValues(ByteBuffer ... binaryListValues) {
        if (this.binaryListValues == null) {
            this.setBinaryListValues((Collection<ByteBuffer>)new SdkInternalList(binaryListValues.length));
        }
        for (ByteBuffer ele : binaryListValues) {
            this.binaryListValues.add((Object)ele);
        }
        return this;
    }

    public MessageAttributeValue withBinaryListValues(Collection<ByteBuffer> binaryListValues) {
        this.setBinaryListValues(binaryListValues);
        return this;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public MessageAttributeValue withDataType(String dataType) {
        this.setDataType(dataType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStringValue() != null) {
            sb.append("StringValue: ").append(this.getStringValue()).append(",");
        }
        if (this.getBinaryValue() != null) {
            sb.append("BinaryValue: ").append(this.getBinaryValue()).append(",");
        }
        if (this.getStringListValues() != null) {
            sb.append("StringListValues: ").append(this.getStringListValues()).append(",");
        }
        if (this.getBinaryListValues() != null) {
            sb.append("BinaryListValues: ").append(this.getBinaryListValues()).append(",");
        }
        if (this.getDataType() != null) {
            sb.append("DataType: ").append(this.getDataType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageAttributeValue)) {
            return false;
        }
        MessageAttributeValue other = (MessageAttributeValue)obj;
        if (other.getStringValue() == null ^ this.getStringValue() == null) {
            return false;
        }
        if (other.getStringValue() != null && !other.getStringValue().equals(this.getStringValue())) {
            return false;
        }
        if (other.getBinaryValue() == null ^ this.getBinaryValue() == null) {
            return false;
        }
        if (other.getBinaryValue() != null && !other.getBinaryValue().equals(this.getBinaryValue())) {
            return false;
        }
        if (other.getStringListValues() == null ^ this.getStringListValues() == null) {
            return false;
        }
        if (other.getStringListValues() != null && !other.getStringListValues().equals(this.getStringListValues())) {
            return false;
        }
        if (other.getBinaryListValues() == null ^ this.getBinaryListValues() == null) {
            return false;
        }
        if (other.getBinaryListValues() != null && !other.getBinaryListValues().equals(this.getBinaryListValues())) {
            return false;
        }
        if (other.getDataType() == null ^ this.getDataType() == null) {
            return false;
        }
        return other.getDataType() == null || other.getDataType().equals(this.getDataType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStringValue() == null ? 0 : this.getStringValue().hashCode());
        hashCode = 31 * hashCode + (this.getBinaryValue() == null ? 0 : this.getBinaryValue().hashCode());
        hashCode = 31 * hashCode + (this.getStringListValues() == null ? 0 : this.getStringListValues().hashCode());
        hashCode = 31 * hashCode + (this.getBinaryListValues() == null ? 0 : this.getBinaryListValues().hashCode());
        hashCode = 31 * hashCode + (this.getDataType() == null ? 0 : this.getDataType().hashCode());
        return hashCode;
    }

    public MessageAttributeValue clone() {
        try {
            return (MessageAttributeValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageAttributeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

