/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteMessageRequestMarshaller
implements Marshaller<Request<DeleteMessageRequest>, DeleteMessageRequest> {
    public Request<DeleteMessageRequest> marshall(DeleteMessageRequest deleteMessageRequest) {
        if (deleteMessageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteMessageRequest, "AmazonSQS");
        request.addParameter("Action", "DeleteMessage");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteMessageRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)deleteMessageRequest.getQueueUrl()));
        }
        if (deleteMessageRequest.getReceiptHandle() != null) {
            request.addParameter("ReceiptHandle", StringUtils.fromString((String)deleteMessageRequest.getReceiptHandle()));
        }
        return request;
    }
}

